/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeFileConst;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;

public class ShpParseUtil
implements ShapeFileConst {
    public static CoordinateSequence readCoordinates(ShapeReader reader, int numPoints, GeometryFactory geometryFactory) throws IOException {
        CoordinateSequence coordinateSequence = geometryFactory.getCoordinateSequenceFactory().create(numPoints, 2);
        double[] ordinates = new double[numPoints * 2];
        reader.read(ordinates);
        for (int i = 0; i < numPoints; ++i) {
            coordinateSequence.setOrdinate(i, 0, ordinates[i * 2]);
            coordinateSequence.setOrdinate(i, 1, ordinates[i * 2 + 1]);
        }
        return coordinateSequence;
    }

    public static boolean pointInList(Coordinate testPoint, Coordinate[] pointList) {
        for (int t = pointList.length - 1; t >= 0; --t) {
            Coordinate p = pointList[t];
            if (testPoint.x != p.x || testPoint.y != p.y || testPoint.z != p.z && testPoint.z == testPoint.z) continue;
            return true;
        }
        return false;
    }
}

