/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.joinJudgement;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.datasyslab.geospark.geometryObjects.PairGeometry;

public class GeometryByPolygonJudgement
implements FlatMapFunction2<Iterator<Object>, Iterator<Object>, PairGeometry>,
Serializable {
    boolean considerBoundaryIntersection = false;

    public GeometryByPolygonJudgement(boolean considerBoundaryIntersection) {
        this.considerBoundaryIntersection = considerBoundaryIntersection;
    }

    public Iterator<PairGeometry> call(Iterator<Object> iteratorObject, Iterator<Object> iteratorWindow) throws Exception {
        ArrayList<PairGeometry> result = new ArrayList<PairGeometry>();
        ArrayList<Object> queryObjects = new ArrayList<Object>();
        while (iteratorObject.hasNext()) {
            queryObjects.add(iteratorObject.next());
        }
        while (iteratorWindow.hasNext()) {
            Polygon window = (Polygon)iteratorWindow.next();
            HashSet<Geometry> resultHashSet = new HashSet<Geometry>();
            for (int i = 0; i < queryObjects.size(); ++i) {
                Geometry object = (Geometry)queryObjects.get(i);
                if (this.considerBoundaryIntersection) {
                    if (!window.intersects(object)) continue;
                    resultHashSet.add(object);
                    continue;
                }
                if (!window.covers(object)) continue;
                resultHashSet.add(object);
            }
            if (resultHashSet.size() == 0) continue;
            result.add(new PairGeometry(window, resultHashSet));
        }
        return result.iterator();
    }
}

