/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.rangeJudgement;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.io.Serializable;
import org.apache.spark.api.java.function.Function;

public class RangeFilter
implements Function<Object, Boolean>,
Serializable {
    boolean considerBoundaryIntersection = false;
    Object queryWindow;

    public RangeFilter(Envelope queryWindow, boolean considerBoundaryIntersection) {
        this.considerBoundaryIntersection = considerBoundaryIntersection;
        this.queryWindow = queryWindow;
    }

    public RangeFilter(Polygon queryWindow, boolean considerBoundaryIntersection) {
        this.considerBoundaryIntersection = considerBoundaryIntersection;
        this.queryWindow = queryWindow;
    }

    public Boolean call(Object tuple) throws Exception {
        if (!this.considerBoundaryIntersection) {
            if (this.queryWindow instanceof Envelope) {
                if (((Envelope)this.queryWindow).contains(((Geometry)tuple).getEnvelopeInternal())) {
                    return true;
                }
                return false;
            }
            if (((Polygon)this.queryWindow).contains((Geometry)tuple)) {
                return true;
            }
            return false;
        }
        if (this.queryWindow instanceof Envelope) {
            if (((Envelope)this.queryWindow).intersects(((Geometry)tuple).getEnvelopeInternal())) {
                return true;
            }
            return false;
        }
        if (((Polygon)this.queryWindow).intersects((Geometry)tuple)) {
            return true;
        }
        return false;
    }
}

