/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.rangeJudgement;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;

public class RangeFilterUsingIndex
implements FlatMapFunction<Iterator<Object>, Object>,
Serializable {
    boolean considerBoundaryIntersection = false;
    Object queryWindow;

    public RangeFilterUsingIndex(Envelope queryWindow, boolean considerBoundaryIntersection) {
        this.considerBoundaryIntersection = considerBoundaryIntersection;
        this.queryWindow = queryWindow;
    }

    public RangeFilterUsingIndex(Polygon queryWindow, boolean considerBoundaryIntersection) {
        this.considerBoundaryIntersection = considerBoundaryIntersection;
        this.queryWindow = queryWindow;
    }

    public Iterator<Object> call(Iterator<Object> treeIndexes) throws Exception {
        assert (treeIndexes.hasNext());
        Object treeIndex = treeIndexes.next();
        if (treeIndex instanceof STRtree) {
            STRtree strtree = (STRtree)treeIndex;
            List result = new ArrayList();
            if (this.queryWindow instanceof Envelope) {
                if (this.considerBoundaryIntersection) {
                    result = strtree.query((Envelope)this.queryWindow);
                } else {
                    List intermediateResult = strtree.query((Envelope)this.queryWindow);
                    for (Object spatialObject : intermediateResult) {
                        if (!((Envelope)this.queryWindow).contains(((Geometry)spatialObject).getEnvelopeInternal())) continue;
                        result.add(spatialObject);
                    }
                }
            } else {
                List tempResult = new ArrayList();
                tempResult = strtree.query(((Polygon)this.queryWindow).getEnvelopeInternal());
                for (Object spatialObject : tempResult) {
                    if (this.considerBoundaryIntersection) {
                        if (!((Polygon)this.queryWindow).intersects((Geometry)spatialObject)) continue;
                        result.add(spatialObject);
                        continue;
                    }
                    if (!((Polygon)this.queryWindow).covers((Geometry)spatialObject)) continue;
                    result.add(spatialObject);
                }
            }
            return result.iterator();
        }
        Quadtree quadtree = (Quadtree)treeIndex;
        List result = new ArrayList();
        if (this.queryWindow instanceof Envelope) {
            result = quadtree.query((Envelope)this.queryWindow);
        } else {
            List tempResult = new ArrayList();
            tempResult = quadtree.query(((Polygon)this.queryWindow).getEnvelopeInternal());
            for (Object spatialObject : tempResult) {
                if (this.considerBoundaryIntersection) {
                    if (!((Polygon)this.queryWindow).intersects((Geometry)spatialObject)) continue;
                    result.add(spatialObject);
                    continue;
                }
                if (!((Polygon)this.queryWindow).covers((Geometry)spatialObject)) continue;
                result.add(spatialObject);
            }
        }
        return result.iterator();
    }
}

