/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.showcase;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.storage.StorageLevel$;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.enums.GridType;
import org.datasyslab.geospark.enums.IndexType;
import org.datasyslab.geospark.formatMapper.shapefileParser.ShapefileRDD;
import org.datasyslab.geospark.showcase.ScalaExample;
import org.datasyslab.geospark.spatialOperator.JoinQuery;
import org.datasyslab.geospark.spatialOperator.KNNQuery;
import org.datasyslab.geospark.spatialOperator.RangeQuery;
import org.datasyslab.geospark.spatialRDD.CircleRDD;
import org.datasyslab.geospark.spatialRDD.PointRDD;
import org.datasyslab.geospark.spatialRDD.PolygonRDD;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class ScalaExample$
implements App {
    public static final ScalaExample$ MODULE$;
    private final SparkConf conf;
    private final SparkContext sc;
    private final String resourceFolder;
    private final String PointRDDInputLocation;
    private final FileDataSplitter PointRDDSplitter;
    private final IndexType PointRDDIndexType;
    private final int PointRDDNumPartitions;
    private final int PointRDDOffset;
    private final String PolygonRDDInputLocation;
    private final FileDataSplitter PolygonRDDSplitter;
    private final int PolygonRDDNumPartitions;
    private final int PolygonRDDStartOffset;
    private final int PolygonRDDEndOffset;
    private final GeometryFactory geometryFactory;
    private final Point kNNQueryPoint;
    private final Envelope rangeQueryWindow;
    private final GridType joinQueryPartitioningType;
    private final int eachQueryLoopTimes;
    private String ShapeFileInputLocation;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new ScalaExample$();
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public String resourceFolder() {
        return this.resourceFolder;
    }

    public String PointRDDInputLocation() {
        return this.PointRDDInputLocation;
    }

    public FileDataSplitter PointRDDSplitter() {
        return this.PointRDDSplitter;
    }

    public IndexType PointRDDIndexType() {
        return this.PointRDDIndexType;
    }

    public int PointRDDNumPartitions() {
        return this.PointRDDNumPartitions;
    }

    public int PointRDDOffset() {
        return this.PointRDDOffset;
    }

    public String PolygonRDDInputLocation() {
        return this.PolygonRDDInputLocation;
    }

    public FileDataSplitter PolygonRDDSplitter() {
        return this.PolygonRDDSplitter;
    }

    public int PolygonRDDNumPartitions() {
        return this.PolygonRDDNumPartitions;
    }

    public int PolygonRDDStartOffset() {
        return this.PolygonRDDStartOffset;
    }

    public int PolygonRDDEndOffset() {
        return this.PolygonRDDEndOffset;
    }

    public GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    public Point kNNQueryPoint() {
        return this.kNNQueryPoint;
    }

    public Envelope rangeQueryWindow() {
        return this.rangeQueryWindow;
    }

    public GridType joinQueryPartitioningType() {
        return this.joinQueryPartitioningType;
    }

    public int eachQueryLoopTimes() {
        return this.eachQueryLoopTimes;
    }

    public String ShapeFileInputLocation() {
        return this.ShapeFileInputLocation;
    }

    public void ShapeFileInputLocation_$eq(String x$1) {
        this.ShapeFileInputLocation = x$1;
    }

    public void testSpatialRangeQuery() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.rawSpatialRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)new Serializable(objectRDD){
            public static final long serialVersionUID = 0L;
            private final PointRDD objectRDD$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long l = RangeQuery.SpatialRangeQuery(this.objectRDD$1, ScalaExample$.MODULE$.rangeQueryWindow(), false, false).count();
            }
            {
                this.objectRDD$1 = objectRDD$1;
            }
        });
    }

    public void testSpatialRangeQueryUsingIndex() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.buildIndex(this.PointRDDIndexType(), false);
        objectRDD.indexedRawRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)new Serializable(objectRDD){
            public static final long serialVersionUID = 0L;
            private final PointRDD objectRDD$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long l = RangeQuery.SpatialRangeQuery(this.objectRDD$2, ScalaExample$.MODULE$.rangeQueryWindow(), false, true).count();
            }
            {
                this.objectRDD$2 = objectRDD$2;
            }
        });
    }

    public void testSpatialKnnQuery() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.rawSpatialRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)new Serializable(objectRDD){
            public static final long serialVersionUID = 0L;
            private final PointRDD objectRDD$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                List<Point> list = KNNQuery.SpatialKnnQuery(this.objectRDD$3, ScalaExample$.MODULE$.kNNQueryPoint(), Predef$.MODULE$.int2Integer(1000), false);
            }
            {
                this.objectRDD$3 = objectRDD$3;
            }
        });
    }

    public void testSpatialKnnQueryUsingIndex() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.buildIndex(this.PointRDDIndexType(), false);
        objectRDD.indexedRawRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)new Serializable(objectRDD){
            public static final long serialVersionUID = 0L;
            private final PointRDD objectRDD$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                List<Point> list = KNNQuery.SpatialKnnQuery(this.objectRDD$4, ScalaExample$.MODULE$.kNNQueryPoint(), Predef$.MODULE$.int2Integer(1000), true);
            }
            {
                this.objectRDD$4 = objectRDD$4;
            }
        });
    }

    public void testSpatialJoinQuery() {
        PolygonRDD queryWindowRDD = new PolygonRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PolygonRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PolygonRDDStartOffset()), Predef$.MODULE$.int2Integer(this.PolygonRDDEndOffset()), this.PolygonRDDSplitter(), true);
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.spatialPartitioning(this.joinQueryPartitioningType());
        queryWindowRDD.spatialPartitioning(objectRDD.partitionTree);
        objectRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)new Serializable(queryWindowRDD, objectRDD){
            public static final long serialVersionUID = 0L;
            private final PolygonRDD queryWindowRDD$1;
            private final PointRDD objectRDD$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long l = JoinQuery.SpatialJoinQuery(this.objectRDD$5, this.queryWindowRDD$1, false, true).count();
            }
            {
                this.queryWindowRDD$1 = queryWindowRDD$1;
                this.objectRDD$5 = objectRDD$5;
            }
        });
    }

    public void testSpatialJoinQueryUsingIndex() {
        PolygonRDD queryWindowRDD = new PolygonRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PolygonRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PolygonRDDStartOffset()), Predef$.MODULE$.int2Integer(this.PolygonRDDEndOffset()), this.PolygonRDDSplitter(), true);
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.spatialPartitioning(this.joinQueryPartitioningType());
        queryWindowRDD.spatialPartitioning(objectRDD.partitionTree);
        objectRDD.buildIndex(this.PointRDDIndexType(), true);
        objectRDD.indexedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)new Serializable(queryWindowRDD, objectRDD){
            public static final long serialVersionUID = 0L;
            private final PolygonRDD queryWindowRDD$2;
            private final PointRDD objectRDD$6;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long l = JoinQuery.SpatialJoinQuery(this.objectRDD$6, this.queryWindowRDD$2, true, false).count();
            }
            {
                this.queryWindowRDD$2 = queryWindowRDD$2;
                this.objectRDD$6 = objectRDD$6;
            }
        });
    }

    public void testDistanceJoinQuery() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        CircleRDD queryWindowRDD = new CircleRDD(objectRDD, Predef$.MODULE$.double2Double(0.1));
        objectRDD.spatialPartitioning(GridType.QUADTREE);
        queryWindowRDD.spatialPartitioning(objectRDD.partitionTree);
        objectRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)new Serializable(objectRDD, queryWindowRDD){
            public static final long serialVersionUID = 0L;
            private final PointRDD objectRDD$7;
            private final CircleRDD queryWindowRDD$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long l = JoinQuery.DistanceJoinQuery(this.objectRDD$7, this.queryWindowRDD$3, false, true).count();
            }
            {
                this.objectRDD$7 = objectRDD$7;
                this.queryWindowRDD$3 = queryWindowRDD$3;
            }
        });
    }

    public void testDistanceJoinQueryUsingIndex() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        CircleRDD queryWindowRDD = new CircleRDD(objectRDD, Predef$.MODULE$.double2Double(0.1));
        objectRDD.spatialPartitioning(GridType.QUADTREE);
        queryWindowRDD.spatialPartitioning(objectRDD.partitionTree);
        objectRDD.buildIndex(IndexType.RTREE, true);
        objectRDD.indexedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)new Serializable(objectRDD, queryWindowRDD){
            public static final long serialVersionUID = 0L;
            private final PointRDD objectRDD$8;
            private final CircleRDD queryWindowRDD$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long l = JoinQuery.DistanceJoinQuery(this.objectRDD$8, this.queryWindowRDD$4, true, true).count();
            }
            {
                this.objectRDD$8 = objectRDD$8;
                this.queryWindowRDD$4 = queryWindowRDD$4;
            }
        });
    }

    public void testCRSTransformationSpatialRangeQuery() throws Exception {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY(), "epsg:4326", "epsg:3005");
        objectRDD.rawSpatialRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        int i = 0;
        while (i < this.eachQueryLoopTimes()) {
            long resultSize = RangeQuery.SpatialRangeQuery(objectRDD, this.rangeQueryWindow(), false, false).count();
            Predef$.MODULE$.assert(resultSize > -1L);
            int cfr_ignored_0 = ++i - 1;
        }
    }

    public void testCRSTransformationSpatialRangeQueryUsingIndex() throws Exception {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY(), "epsg:4326", "epsg:3005");
        objectRDD.buildIndex(this.PointRDDIndexType(), false);
        objectRDD.indexedRawRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        int i = 0;
        while (i < this.eachQueryLoopTimes()) {
            long resultSize = RangeQuery.SpatialRangeQuery(objectRDD, this.rangeQueryWindow(), false, true).count();
            Predef$.MODULE$.assert(resultSize > -1L);
            int cfr_ignored_0 = ++i - 1;
        }
    }

    public void testLoadShapefileIntoPolygonRDD() throws Exception {
        ShapefileRDD shapefileRDD = new ShapefileRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.ShapeFileInputLocation());
        PolygonRDD spatialRDD = new PolygonRDD(shapefileRDD.getPolygonRDD());
        try {
            RangeQuery.SpatialRangeQuery(spatialRDD, new Envelope(-180.0, 180.0, -90.0, 90.0), false, false).count();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final void delayedEndpoint$org$datasyslab$geospark$showcase$ScalaExample$1() {
        this.conf = new SparkConf().setAppName("GeoSparkRunnableExample").setMaster("local[2]");
        this.sc = new SparkContext(this.conf());
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        this.resourceFolder = new StringBuilder().append((Object)System.getProperty("user.dir")).append((Object)"/src/test/resources/").toString();
        this.PointRDDInputLocation = new StringBuilder().append((Object)this.resourceFolder()).append((Object)"arealm-small.csv").toString();
        this.PointRDDSplitter = FileDataSplitter.CSV;
        this.PointRDDIndexType = IndexType.RTREE;
        this.PointRDDNumPartitions = 5;
        this.PointRDDOffset = 0;
        this.PolygonRDDInputLocation = new StringBuilder().append((Object)this.resourceFolder()).append((Object)"primaryroads-polygon.csv").toString();
        this.PolygonRDDSplitter = FileDataSplitter.CSV;
        this.PolygonRDDNumPartitions = 5;
        this.PolygonRDDStartOffset = 0;
        this.PolygonRDDEndOffset = 8;
        this.geometryFactory = new GeometryFactory();
        this.kNNQueryPoint = this.geometryFactory().createPoint(new Coordinate(-84.01, 34.01));
        this.rangeQueryWindow = new Envelope(-90.01, -80.01, 30.01, 40.01);
        this.joinQueryPartitioningType = GridType.QUADTREE;
        this.eachQueryLoopTimes = 5;
        this.ShapeFileInputLocation = new StringBuilder().append((Object)this.resourceFolder()).append((Object)"shapefiles/polygon").toString();
        this.testSpatialRangeQuery();
        this.testSpatialRangeQueryUsingIndex();
        this.testSpatialKnnQuery();
        this.testSpatialKnnQueryUsingIndex();
        this.testSpatialJoinQuery();
        this.testSpatialJoinQueryUsingIndex();
        this.testDistanceJoinQuery();
        this.testDistanceJoinQueryUsingIndex();
        this.testCRSTransformationSpatialRangeQuery();
        this.testCRSTransformationSpatialRangeQueryUsingIndex();
        this.sc().stop();
        System.out.println("All GeoSpark DEMOs passed!");
    }

    private ScalaExample$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new ScalaExample.delayedInit.body(this));
    }
}

