/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.geotools.resources.ClassChanger;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.Utilities;

public class MeasurementRange<T extends Number>
extends NumberRange<T> {
    private static final long serialVersionUID = 3980319420337513745L;
    private final Unit<?> units;

    public static MeasurementRange<Float> create(float minimum, float maximum, Unit<?> units) {
        return MeasurementRange.create(minimum, true, maximum, true, units);
    }

    public static MeasurementRange<Float> create(float minimum, boolean isMinIncluded, float maximum, boolean isMaxIncluded, Unit<?> units) {
        return new MeasurementRange<Float>(Float.class, Float.valueOf(minimum), isMinIncluded, Float.valueOf(maximum), isMaxIncluded, units);
    }

    public static MeasurementRange<Double> create(double minimum, double maximum, Unit<?> units) {
        return MeasurementRange.create(minimum, true, maximum, true, units);
    }

    public static MeasurementRange<Double> create(double minimum, boolean isMinIncluded, double maximum, boolean isMaxIncluded, Unit<?> units) {
        return new MeasurementRange<Double>(Double.class, minimum, isMinIncluded, maximum, isMaxIncluded, units);
    }

    public MeasurementRange(Class<T> type, T minimum, boolean isMinIncluded, T maximum, boolean isMaxIncluded, Unit<?> units) {
        super(type, minimum, isMinIncluded, maximum, isMaxIncluded);
        this.units = units;
    }

    public MeasurementRange(Range<T> range, Unit<?> units) {
        super(range);
        this.units = units;
    }

    private MeasurementRange(Class<T> type, Range<? extends Number> range, Unit<?> units) {
        super(type, range);
        this.units = units;
    }

    @Override
    MeasurementRange<T> create(T minValue, boolean isMinIncluded, T maxValue, boolean isMaxIncluded) {
        return new MeasurementRange<T>(this.elementClass, minValue, isMinIncluded, maxValue, isMaxIncluded, this.units);
    }

    @Override
    public Unit<?> getUnits() {
        return this.units;
    }

    public MeasurementRange convertTo(Unit<?> targetUnits) throws ConversionException {
        return this.convertAndCast(this.elementClass, targetUnits);
    }

    @Override
    public <N extends Number> MeasurementRange<N> castTo(Class<N> type) {
        return (MeasurementRange)this.damnJava5(this, type);
    }

    @Override
    <N extends Number> MeasurementRange<N> convertAndCast(Range<? extends Number> range, Class<N> type) throws IllegalArgumentException {
        if (range instanceof MeasurementRange) {
            MeasurementRange casted = (MeasurementRange)range;
            return casted.convertAndCast(type, this.units);
        }
        return new MeasurementRange<N>(type, range, this.units);
    }

    private <N extends Number> MeasurementRange<N> convertAndCast(Class<N> type, Unit<?> targetUnits) throws ConversionException {
        Double maximum;
        if (targetUnits == null || targetUnits.equals(this.units)) {
            if (type.equals(this.elementClass)) {
                MeasurementRange result = this;
                return result;
            }
            return new MeasurementRange<N>(type, this, this.units);
        }
        if (this.units == null) {
            return new MeasurementRange<N>(type, this, targetUnits);
        }
        UnitConverter converter = this.units.getConverterTo(targetUnits);
        if (converter.equals(UnitConverter.IDENTITY)) {
            return new MeasurementRange<N>(type, this, targetUnits);
        }
        boolean isMinIncluded = this.isMinIncluded();
        boolean isMaxIncluded = this.isMaxIncluded();
        Double minimum = converter.convert(this.getMinimum());
        if (minimum.compareTo(maximum = Double.valueOf(converter.convert(this.getMaximum()))) > 0) {
            Double td = minimum;
            minimum = maximum;
            maximum = td;
            boolean tb = isMinIncluded;
            isMinIncluded = isMaxIncluded;
            isMaxIncluded = tb;
        }
        return new MeasurementRange<N>(type, ClassChanger.cast(minimum, type), isMinIncluded, ClassChanger.cast(maximum, type), isMaxIncluded, targetUnits);
    }

    MeasurementRange<T>[] newArray(int length) {
        return new MeasurementRange[length];
    }

    @Override
    public MeasurementRange union(Range range) {
        return (MeasurementRange)super.union(range);
    }

    @Override
    public MeasurementRange intersect(Range range) {
        return (MeasurementRange)super.intersect(range);
    }

    public MeasurementRange[] subtract(Range range) {
        return (MeasurementRange[])super.subtract(range);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            if (object instanceof MeasurementRange) {
                MeasurementRange that = (MeasurementRange)object;
                return Utilities.equals(this.units, that.units);
            }
            return true;
        }
        return false;
    }
}

