/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannel<T>
implements HttpParser.RequestHandler<T>,
Runnable,
HttpParser.ProxyHandler {
    private static final Logger LOG = Log.getLogger(HttpChannel.class);
    private static final ThreadLocal<HttpChannel<?>> __currentChannel = new ThreadLocal();
    private final AtomicBoolean _committed = new AtomicBoolean();
    private final AtomicInteger _requests = new AtomicInteger();
    private final Connector _connector;
    private final HttpConfiguration _configuration;
    private final EndPoint _endPoint;
    private final HttpTransport _transport;
    private final HttpURI _uri;
    private final HttpChannelState _state;
    private final Request _request;
    private final Response _response;
    private HttpVersion _version = HttpVersion.HTTP_1_1;
    private boolean _expect = false;
    private boolean _expect100Continue = false;
    private boolean _expect102Processing = false;

    public static HttpChannel<?> getCurrentHttpChannel() {
        return __currentChannel.get();
    }

    protected static HttpChannel<?> setCurrentHttpChannel(HttpChannel<?> channel) {
        HttpChannel<?> last = __currentChannel.get();
        if (channel == null) {
            __currentChannel.remove();
        } else {
            __currentChannel.set(channel);
        }
        return last;
    }

    public HttpChannel(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport, HttpInput<T> input) {
        this._connector = connector;
        this._configuration = configuration;
        this._endPoint = endPoint;
        this._transport = transport;
        this._uri = new HttpURI(URIUtil.__CHARSET);
        this._state = new HttpChannelState(this);
        input.init(this._state);
        this._request = new Request(this, input);
        this._response = new Response(this, new HttpOutput(this));
    }

    public HttpChannelState getState() {
        return this._state;
    }

    public HttpVersion getHttpVersion() {
        return this._version;
    }

    public int getRequests() {
        return this._requests.get();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpTransport getHttpTransport() {
        return this._transport;
    }

    public ByteBufferPool getByteBufferPool() {
        return this._connector.getByteBufferPool();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._configuration;
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    public InetSocketAddress getLocalAddress() {
        return this._endPoint.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this._endPoint.getRemoteAddress();
    }

    @Override
    public int getHeaderCacheSize() {
        return this._configuration.getHeaderCacheSize();
    }

    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (available == 0) {
                if (this._response.isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    public void reset() {
        this._committed.set(false);
        this._expect = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        this._request.recycle();
        this._response.recycle();
        this._uri.clear();
    }

    @Override
    public void run() {
        this.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean handle() {
        block43: {
            if (HttpChannel.LOG.isDebugEnabled()) {
                HttpChannel.LOG.debug("{} handle enter", new Object[]{this});
            }
            last = HttpChannel.setCurrentHttpChannel(this);
            threadName = null;
            if (HttpChannel.LOG.isDebugEnabled()) {
                threadName = Thread.currentThread().getName();
                Thread.currentThread().setName(threadName + " - " + this._uri);
            }
            action = this._state.handling();
            try lbl-1000:
            // 11 sources

            {
                while (action.ordinal() < HttpChannelState.Action.WAIT.ordinal() && this.getServer().isRunning()) {
                    error = false;
                    try {
                        if (HttpChannel.LOG.isDebugEnabled()) {
                            HttpChannel.LOG.debug("{} action {}", new Object[]{this, action});
                        }
                        switch (1.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$Action[action.ordinal()]) {
                            case 1: {
                                this._request.setHandled(false);
                                this._response.getHttpOutput().reopen();
                                this._request.setDispatcherType(DispatcherType.REQUEST);
                                customizers = this._configuration.getCustomizers();
                                if (!customizers.isEmpty()) {
                                    for (HttpConfiguration.Customizer customizer : customizers) {
                                        customizer.customize(this.getConnector(), this._configuration, this._request);
                                    }
                                }
                                this.getServer().handle(this);
                                ** break;
                            }
                            case 2: {
                                this._request.setHandled(false);
                                this._response.getHttpOutput().reopen();
                                this._request.setDispatcherType(DispatcherType.ASYNC);
                                this.getServer().handleAsync(this);
                                ** break;
                            }
                            case 3: {
                                this._request.setHandled(false);
                                this._response.getHttpOutput().reopen();
                                this._request.setDispatcherType(DispatcherType.ERROR);
                                ex = this._state.getAsyncContextEvent().getThrowable();
                                reason = "Async Timeout";
                                if (ex != null) {
                                    reason = "Async Exception";
                                    this._request.setAttribute("javax.servlet.error.exception", ex);
                                }
                                this._request.setAttribute("javax.servlet.error.status_code", new Integer(500));
                                this._request.setAttribute("javax.servlet.error.message", reason);
                                this._request.setAttribute("javax.servlet.error.request_uri", this._request.getRequestURI());
                                this._response.setStatusWithReason(500, reason);
                                eh = ErrorHandler.getErrorHandler(this.getServer(), this._state.getContextHandler());
                                if (eh instanceof ErrorHandler.ErrorPageMapper && (error_page = ((ErrorHandler.ErrorPageMapper)eh).getErrorPage((HttpServletRequest)this._state.getAsyncContextEvent().getSuppliedRequest())) != null) {
                                    this._state.getAsyncContextEvent().setDispatchPath(error_page);
                                }
                                this.getServer().handleAsync(this);
                                ** break;
                            }
                            case 4: {
                                handler = this._state.getContextHandler();
                                if (handler != null) {
                                    handler.handle(this._request.getHttpInput());
                                    ** break;
                                }
                                this._request.getHttpInput().run();
                                ** break;
                            }
                            case 5: {
                                handler = this._state.getContextHandler();
                                if (handler != null) {
                                    handler.handle(this._response.getHttpOutput());
                                    ** break;
                                }
                                this._response.getHttpOutput().run();
                                ** break;
                            }
                            ** default:
lbl66:
                            // 1 sources

                            break block43;
                        }
                    }
                    catch (Error e) {
                        if ("ContinuationThrowable".equals(e.getClass().getSimpleName())) {
                            HttpChannel.LOG.ignore(e);
                            continue;
                        }
                        error = true;
                        throw e;
                    }
                    catch (Exception e) {
                        error = true;
                        if (e instanceof EofException) {
                            HttpChannel.LOG.debug(e);
                        } else {
                            HttpChannel.LOG.warn(String.valueOf(this._uri), e);
                        }
                        this._state.error(e);
                        this._request.setHandled(true);
                        this.handleException(e);
                    }
                    finally {
                        if (error && this._state.isAsyncStarted()) {
                            this._state.errorComplete();
                        }
                        action = this._state.unhandle();
                    }
                }
            }
            finally {
                HttpChannel.setCurrentHttpChannel(last);
                if (threadName != null && HttpChannel.LOG.isDebugEnabled()) {
                    Thread.currentThread().setName(threadName);
                }
            }
        }
        if (action == HttpChannelState.Action.COMPLETE) {
            try {
                this._state.completed();
                if (!this._response.isCommitted() && !this._request.isHandled()) {
                    this._response.sendError(404);
                } else {
                    this._response.closeOutput();
                }
            }
            catch (ClosedChannelException | EofException e) {
                HttpChannel.LOG.debug(e);
            }
            catch (Exception e) {
                HttpChannel.LOG.warn("complete failed", e);
            }
            finally {
                this._request.setHandled(true);
                this._transport.completed();
            }
        }
        if (HttpChannel.LOG.isDebugEnabled()) {
            HttpChannel.LOG.debug("{} handle exit, result {}", new Object[]{this, action});
        }
        return action != HttpChannelState.Action.WAIT;
    }

    protected void handleException(Throwable x) {
        try {
            this._request.setAttribute("javax.servlet.error.exception", x);
            this._request.setAttribute("javax.servlet.error.exception_type", x.getClass());
            if (this._state.isSuspended()) {
                HttpFields fields = new HttpFields();
                fields.add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(this._request.getHttpVersion(), fields, 0L, 500, null, this._request.isHead());
                boolean committed = this.sendResponse(info, null, true);
                if (!committed) {
                    LOG.warn("Could not send response error 500: " + x, new Object[0]);
                }
                this._request.getAsyncContext().complete();
            } else if (this.isCommitted()) {
                this._transport.abort();
                if (!(x instanceof EofException)) {
                    LOG.warn("Could not send response error 500: " + x, new Object[0]);
                }
            } else {
                this._response.setHeader(HttpHeader.CONNECTION.asString(), HttpHeaderValue.CLOSE.asString());
                this._response.sendError(500, x.getMessage());
            }
        }
        catch (IOException e) {
            LOG.debug("Could not commit response error 500", e);
        }
    }

    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    public boolean isExpecting102Processing() {
        return this._expect102Processing;
    }

    public String toString() {
        return String.format("%s@%x{r=%s,a=%s,uri=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._requests, this._state.getState(), this._state.getState() == HttpChannelState.State.IDLE ? "-" : this._request.getRequestURI()});
    }

    @Override
    public void proxied(String protocol, String sAddr, String dAddr, int sPort, int dPort) {
        this._request.setAttribute("PROXY", protocol);
        this._request.setServerName(sAddr);
        this._request.setServerPort(dPort);
        this._request.setRemoteAddr(InetSocketAddress.createUnresolved(sAddr, sPort));
    }

    @Override
    public boolean startRequest(HttpMethod httpMethod, String method, ByteBuffer uri, HttpVersion version) {
        String path;
        this._expect = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        this._request.setTimeStamp(System.currentTimeMillis());
        this._request.setMethod(httpMethod, method);
        if (httpMethod == HttpMethod.CONNECT) {
            this._uri.parseConnect(uri.array(), uri.arrayOffset() + uri.position(), uri.remaining());
        } else {
            this._uri.parse(uri.array(), uri.arrayOffset() + uri.position(), uri.remaining());
        }
        this._request.setUri(this._uri);
        try {
            path = this._uri.getDecodedPath();
        }
        catch (Exception e) {
            LOG.warn("Failed UTF-8 decode for request path, trying ISO-8859-1", new Object[0]);
            LOG.ignore(e);
            path = this._uri.getDecodedPath(StandardCharsets.ISO_8859_1);
        }
        String info = URIUtil.canonicalPath(path);
        if (info == null) {
            if (path == null && this._uri.getScheme() != null && this._uri.getHost() != null) {
                info = "/";
                this._request.setRequestURI("");
            } else {
                this.badMessage(400, null);
                return true;
            }
        }
        this._request.setPathInfo(info);
        this._version = version == null ? HttpVersion.HTTP_0_9 : version;
        this._request.setHttpVersion(this._version);
        return false;
    }

    @Override
    public boolean parsedHeader(HttpField field) {
        HttpHeader header = field.getHeader();
        String value = field.getValue();
        if (value == null) {
            value = "";
        }
        if (header != null) {
            block0 : switch (header) {
                case EXPECT: {
                    if (this._version.getVersion() < HttpVersion.HTTP_1_1.getVersion()) break;
                    HttpHeaderValue expect = HttpHeaderValue.CACHE.get(value);
                    switch (expect == null ? HttpHeaderValue.UNKNOWN : expect) {
                        case CONTINUE: {
                            this._expect100Continue = true;
                            break block0;
                        }
                        case PROCESSING: {
                            this._expect102Processing = true;
                            break block0;
                        }
                    }
                    String[] values = value.split(",");
                    block12: for (int i = 0; values != null && i < values.length; ++i) {
                        expect = HttpHeaderValue.CACHE.get(values[i].trim());
                        if (expect == null) {
                            this._expect = true;
                            continue;
                        }
                        switch (expect) {
                            case CONTINUE: {
                                this._expect100Continue = true;
                                continue block12;
                            }
                            case PROCESSING: {
                                this._expect102Processing = true;
                                continue block12;
                            }
                            default: {
                                this._expect = true;
                            }
                        }
                    }
                    break;
                }
                case CONTENT_TYPE: {
                    String charset;
                    MimeTypes.Type mime = MimeTypes.CACHE.get(value);
                    String string = charset = mime == null || mime.getCharset() == null ? MimeTypes.getCharsetFromContentType(value) : mime.getCharset().toString();
                    if (charset == null) break;
                    this._request.setCharacterEncodingUnchecked(charset);
                    break;
                }
            }
        }
        if (field.getName() != null) {
            this._request.getHttpFields().add(field);
        }
        return false;
    }

    @Override
    public boolean parsedHostHeader(String host, int port) {
        if (this._uri.getHost() == null) {
            this._request.setServerName(host);
            this._request.setServerPort(port);
        }
        return false;
    }

    @Override
    public boolean headerComplete() {
        this._requests.incrementAndGet();
        switch (this._version) {
            case HTTP_0_9: {
                break;
            }
            case HTTP_1_0: {
                if (!this._configuration.getSendDateHeader()) break;
                this._response.getHttpFields().put(this._connector.getServer().getDateField());
                break;
            }
            case HTTP_1_1: {
                if (this._configuration.getSendDateHeader()) {
                    this._response.getHttpFields().put(this._connector.getServer().getDateField());
                }
                if (!this._expect) break;
                this.badMessage(417, null);
                return true;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    @Override
    public boolean content(T item) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} content {}", this, item);
        }
        HttpInput<?> input = this._request.getHttpInput();
        input.content(item);
        return false;
    }

    @Override
    public boolean messageComplete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} messageComplete", this);
        }
        this._request.getHttpInput().messageComplete();
        return true;
    }

    @Override
    public void earlyEOF() {
        this._request.getHttpInput().earlyEOF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void badMessage(int status, String reason) {
        if (status < 400 || status > 599) {
            status = 400;
        }
        try {
            if (this._state.handling() == HttpChannelState.Action.REQUEST_DISPATCH) {
                ByteBuffer content = null;
                HttpFields fields = new HttpFields();
                ErrorHandler handler = this.getServer().getBean(ErrorHandler.class);
                if (handler != null) {
                    content = handler.badMessageError(status, reason, fields);
                }
                this.sendResponse(new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, fields, 0L, status, reason, false), content, true);
            }
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        finally {
            if (this._state.unhandle() != HttpChannelState.Action.COMPLETE) {
                throw new IllegalStateException();
            }
            this._state.completed();
        }
    }

    protected boolean sendResponse(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean complete, Callback callback) {
        boolean committing = this._committed.compareAndSet(false, true);
        if (committing) {
            int status;
            if (info == null) {
                info = this._response.newResponseInfo();
            }
            CommitCallback committed = (status = info.getStatus()) < 200 && status >= 100 ? new Commit100Callback(callback) : new CommitCallback(callback);
            this._transport.send(info, content, complete, committed);
        } else if (info == null) {
            this._transport.send(content, complete, callback);
        } else {
            callback.failed(new IllegalStateException("committed"));
        }
        return committing;
    }

    protected boolean sendResponse(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean complete) throws IOException {
        try (SharedBlockingCallback.Blocker blocker = this._response.getHttpOutput().acquireWriteBlockingCallback();){
            boolean committing = this.sendResponse(info, content, complete, blocker);
            blocker.block();
            boolean bl = committing;
            return bl;
        }
    }

    public boolean isCommitted() {
        return this._committed.get();
    }

    protected void write(ByteBuffer content, boolean complete, Callback callback) {
        this.sendResponse(null, content, complete, callback);
    }

    protected void execute(Runnable task) {
        this._connector.getExecutor().execute(task);
    }

    public Scheduler getScheduler() {
        return this._connector.getScheduler();
    }

    public boolean useDirectBuffers() {
        return this.getEndPoint() instanceof ChannelEndPoint;
    }

    public void abort() {
        this._transport.abort();
    }

    private class Commit100Callback
    extends CommitCallback {
        private Commit100Callback(Callback callback) {
            super(callback);
        }

        @Override
        public void succeeded() {
            HttpChannel.this._committed.set(false);
            super.succeeded();
        }
    }

    private class CommitCallback
    implements Callback {
        private final Callback _callback;

        private CommitCallback(Callback callback) {
            this._callback = callback;
        }

        @Override
        public void succeeded() {
            this._callback.succeeded();
        }

        @Override
        public void failed(final Throwable x) {
            if (x instanceof EofException || x instanceof ClosedChannelException) {
                LOG.debug(x);
                this._callback.failed(x);
                HttpChannel.this._response.getHttpOutput().closed();
            } else {
                LOG.warn("Commit failed", x);
                HttpChannel.this._transport.send(HttpGenerator.RESPONSE_500_INFO, null, true, new Callback(){

                    @Override
                    public void succeeded() {
                        CommitCallback.this._callback.failed(x);
                        HttpChannel.this._response.getHttpOutput().closed();
                    }

                    @Override
                    public void failed(Throwable th) {
                        LOG.ignore(th);
                        CommitCallback.this._callback.failed(x);
                        HttpChannel.this._response.getHttpOutput().closed();
                    }
                });
            }
        }
    }
}

