/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfig;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.jsr356.Configurable;
import org.eclipse.jetty.websocket.jsr356.metadata.DecoderMetadata;
import org.eclipse.jetty.websocket.jsr356.metadata.DecoderMetadataSet;

public class DecoderFactory
implements Configurable {
    private static final Logger LOG = Log.getLogger(DecoderFactory.class);
    private final DecoderMetadataSet metadatas;
    private DecoderFactory parentFactory;
    private Map<Class<?>, Wrapper> activeWrappers;

    public DecoderFactory(DecoderMetadataSet metadatas) {
        this.metadatas = metadatas;
        this.activeWrappers = new ConcurrentHashMap();
    }

    public DecoderFactory(DecoderMetadataSet metadatas, DecoderFactory parentFactory) {
        this(metadatas);
        this.parentFactory = parentFactory;
    }

    public Decoder getDecoderFor(Class<?> type) {
        Wrapper wrapper = this.getWrapperFor(type);
        if (wrapper == null) {
            return null;
        }
        return wrapper.decoder;
    }

    public DecoderMetadata getMetadataFor(Class<?> type) {
        DecoderMetadata metadata;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getMetadataFor({})", type);
        }
        if ((metadata = (DecoderMetadata)this.metadatas.getMetadataByType(type)) != null) {
            return metadata;
        }
        if (this.parentFactory != null) {
            return this.parentFactory.getMetadataFor(type);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wrapper getWrapperFor(Class<?> type) {
        Map<Class<?>, Wrapper> map = this.activeWrappers;
        synchronized (map) {
            Wrapper wrapper = this.activeWrappers.get(type);
            if (wrapper == null && this.parentFactory != null) {
                wrapper = this.parentFactory.getWrapperFor(type);
            }
            if (wrapper == null) {
                DecoderMetadata metadata = (DecoderMetadata)this.metadatas.getMetadataByType(type);
                if (metadata == null) {
                    return null;
                }
                wrapper = this.newWrapper(metadata);
                this.activeWrappers.put(type, wrapper);
            }
            return wrapper;
        }
    }

    @Override
    public void init(EndpointConfig config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("init({})", config);
        }
        for (DecoderMetadata metadata : this.metadatas) {
            Wrapper wrapper = this.newWrapper(metadata);
            this.activeWrappers.put(metadata.getObjectType(), wrapper);
        }
        for (Wrapper wrapper : this.activeWrappers.values()) {
            wrapper.decoder.init(config);
        }
    }

    public Wrapper newWrapper(DecoderMetadata metadata) {
        Class decoderClass = metadata.getCoderClass();
        try {
            Decoder decoder = (Decoder)decoderClass.newInstance();
            return new Wrapper(decoder, metadata);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate Decoder: " + decoderClass.getName());
        }
    }

    public static class Wrapper
    implements Configurable {
        private final Decoder decoder;
        private final DecoderMetadata metadata;

        private Wrapper(Decoder decoder, DecoderMetadata metadata) {
            this.decoder = decoder;
            this.metadata = metadata;
        }

        public Decoder getDecoder() {
            return this.decoder;
        }

        public DecoderMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public void init(EndpointConfig config) {
            this.decoder.init(config);
        }
    }
}

