/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.FileInitializer;
import org.eclipse.jetty.start.Licensing;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.builders.StartDirBuilder;
import org.eclipse.jetty.start.builders.StartIniBuilder;
import org.eclipse.jetty.start.fileinits.MavenLocalRepoFileInitializer;
import org.eclipse.jetty.start.fileinits.TestFileInitializer;
import org.eclipse.jetty.start.fileinits.UriFileInitializer;
import org.eclipse.jetty.start.graph.HowSetPredicate;
import org.eclipse.jetty.start.graph.HowUniquePredicate;
import org.eclipse.jetty.start.graph.Selection;

public class BaseBuilder {
    private static final String EXITING_LICENSE_NOT_ACKNOWLEDGED = "Exiting: license not acknowledged!";
    private final BaseHome baseHome;
    private final List<FileInitializer> fileInitializers;
    private final StartArgs startArgs;

    public BaseBuilder(BaseHome baseHome, StartArgs args) {
        this.baseHome = baseHome;
        this.startArgs = args;
        this.fileInitializers = new ArrayList<FileInitializer>();
        if (args.isTestingModeEnabled()) {
            this.fileInitializers.add(new TestFileInitializer());
        } else if (args.isDownload()) {
            Path localRepoDir = args.getMavenLocalRepoDir();
            if (localRepoDir != null) {
                this.fileInitializers.add(new MavenLocalRepoFileInitializer(baseHome, localRepoDir));
            } else {
                this.fileInitializers.add(new MavenLocalRepoFileInitializer(baseHome));
            }
            this.fileInitializers.add(new UriFileInitializer(baseHome));
        }
    }

    private void ackLicenses() throws IOException {
        if (this.startArgs.isLicenseCheckRequired()) {
            if (this.startArgs.isApproveAllLicenses()) {
                StartLog.info("All Licenses Approved via Command Line Option", new Object[0]);
            } else {
                Licensing licensing = new Licensing();
                for (Module module : this.startArgs.getAllModules().getSelected()) {
                    if (module.hasFiles(this.baseHome)) continue;
                    licensing.addModule(module);
                }
                if (licensing.hasLicenses()) {
                    StartLog.debug("Requesting License Acknowledgement", new Object[0]);
                    if (!licensing.acknowledgeLicenses()) {
                        StartLog.warn(EXITING_LICENSE_NOT_ACKNOWLEDGED, new Object[0]);
                        System.exit(1);
                    }
                }
            }
        }
    }

    public boolean build() throws IOException {
        Config builder;
        Modules modules = this.startArgs.getAllModules();
        boolean dirty = false;
        String dirSource = "<add-to-startd>";
        String iniSource = "<add-to-start-ini>";
        Selection startDirSelection = new Selection(dirSource);
        Selection startIniSelection = new Selection(iniSource);
        ArrayList<String> startDNames = new ArrayList<String>();
        startDNames.addAll(this.startArgs.getAddToStartdIni());
        ArrayList<String> startIniNames = new ArrayList<String>();
        startIniNames.addAll(this.startArgs.getAddToStartIni());
        int count = 0;
        count += modules.selectNodes(startDNames, startDirSelection);
        count += modules.selectNodes(startIniNames, startIniSelection);
        HowSetPredicate ambiguousPredicate = new HowSetPredicate(dirSource, iniSource);
        List ambiguous = modules.getMatching(ambiguousPredicate);
        if (ambiguous.size() > 0) {
            StringBuilder err = new StringBuilder();
            err.append("Unable to add ");
            err.append(ambiguous.size());
            err.append(" module");
            if (ambiguous.size() > 1) {
                err.append('s');
            }
            err.append(" (found declared via both --add-to-start and --add-to-startd): [");
            for (int i = 0; i < ambiguous.size(); ++i) {
                if (i > 0) {
                    err.append(", ");
                }
                err.append(((Module)ambiguous.get(i)).getName());
            }
            err.append(']');
            throw new RuntimeException(err.toString());
        }
        StartLog.debug("Adding %s new module(s)", count);
        this.ackLicenses();
        HowUniquePredicate startDMatcher = new HowUniquePredicate(dirSource);
        HowUniquePredicate startIniMatcher = new HowUniquePredicate(iniSource);
        List startDModules = modules.getMatching(startDMatcher);
        List startIniModules = modules.getMatching(startIniMatcher);
        ArrayList<FileArg> files = new ArrayList<FileArg>();
        if (!startDModules.isEmpty()) {
            builder = new StartDirBuilder(this);
            for (Module mod : startDModules) {
                dirty |= ((StartDirBuilder)builder).addModule(mod);
                for (String file : mod.getFiles()) {
                    files.add(new FileArg(mod, file));
                }
            }
        }
        if (!startIniModules.isEmpty()) {
            builder = new StartIniBuilder(this);
            for (Module mod : startIniModules) {
                dirty |= ((StartIniBuilder)builder).addModule(mod);
                for (String file : mod.getFiles()) {
                    files.add(new FileArg(mod, file));
                }
            }
        }
        files.addAll(this.startArgs.getFiles());
        return dirty |= this.processFileResources(files);
    }

    public BaseHome getBaseHome() {
        return this.baseHome;
    }

    public StartArgs getStartArgs() {
        return this.startArgs;
    }

    private boolean processFileResource(FileArg arg, Path file) throws IOException {
        if (this.startArgs.isDownload() && arg.uri != null) {
            URI uri = URI.create(arg.uri);
            for (FileInitializer finit : this.fileInitializers) {
                if (!finit.init(uri, file)) continue;
                return true;
            }
            return false;
        }
        boolean isDir = arg.location.endsWith("/");
        if (FS.exists(file)) {
            if (isDir) {
                if (!Files.isDirectory(file, new LinkOption[0])) {
                    throw new IOException("Invalid: path should be a directory (but isn't): " + file);
                }
                if (!FS.canReadDirectory(file)) {
                    throw new IOException("Unable to read directory: " + file);
                }
            } else if (!FS.canReadFile(file)) {
                throw new IOException("Unable to read file: " + file);
            }
            return false;
        }
        if (isDir) {
            StartLog.log("MKDIR", this.baseHome.toShortForm(file));
            return FS.ensureDirectoryExists(file);
        }
        String shortRef = this.baseHome.toShortForm(file);
        if (this.startArgs.isTestingModeEnabled()) {
            StartLog.log("TESTING MODE", "Skipping required file check on: %s", shortRef);
            return true;
        }
        StartLog.warn("Missing Required File: %s", this.baseHome.toShortForm(file));
        this.startArgs.setRun(false);
        if (arg.uri != null) {
            StartLog.warn("  Can be downloaded From: %s", arg.uri);
            StartLog.warn("  Run start.jar --create-files to download", new Object[0]);
        }
        return true;
    }

    private boolean processFileResources(List<FileArg> files) throws IOException {
        if (files == null || files.isEmpty()) {
            return false;
        }
        boolean dirty = false;
        ArrayList<String> failures = new ArrayList<String>();
        for (FileArg arg : files) {
            Path file = this.baseHome.getBasePath(arg.location);
            try {
                dirty |= this.processFileResource(arg, file);
            }
            catch (Throwable t) {
                StartLog.warn(t);
                failures.add(String.format("[%s] %s - %s", t.getClass().getSimpleName(), t.getMessage(), file.toAbsolutePath().toString()));
            }
        }
        if (!failures.isEmpty()) {
            StringBuilder err = new StringBuilder();
            err.append("Failed to process all file resources.");
            for (String failure : failures) {
                err.append(System.lineSeparator()).append(" - ").append(failure);
            }
            StartLog.warn(err.toString(), new Object[0]);
            throw new RuntimeException(err.toString());
        }
        return dirty;
    }

    public static interface Config {
        public boolean addModule(Module var1) throws IOException;
    }
}

