/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.eclipse.jetty.start.BaseBuilder;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.CommandLineBuilder;
import org.eclipse.jetty.start.JarVersion;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.ModuleGraphWriter;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.UsageException;
import org.eclipse.jetty.start.config.CommandLineConfigSource;
import org.eclipse.jetty.start.graph.GraphException;
import org.eclipse.jetty.start.graph.Selection;

public class Main {
    private static final int EXIT_USAGE = 1;
    private BaseHome baseHome;
    private StartArgs startupArgs;

    public static void main(String[] args) {
        try {
            Main main = new Main();
            StartArgs startArgs = main.processCommandLine(args);
            main.start(startArgs);
        }
        catch (UsageException e) {
            System.err.println(e.getMessage());
            Main.usageExit(e.getCause(), e.getExitCode());
        }
        catch (Throwable e) {
            Main.usageExit(e, -9);
        }
    }

    static void usageExit(int exit) {
        Main.usageExit(null, exit);
    }

    static void usageExit(Throwable t, int exit) {
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.err.println();
        System.err.println("Usage: java -jar start.jar [options] [properties] [configs]");
        System.err.println("       java -jar start.jar --help  # for more information");
        System.exit(exit);
    }

    private void copyInThread(final InputStream in, final OutputStream out) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    int len = in.read(buf);
                    while (len > 0) {
                        out.write(buf, 0, len);
                        len = in.read(buf);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
    }

    private void dumpClasspathWithVersions(Classpath classpath) {
        StartLog.endStartLog();
        System.out.println();
        System.out.println("Jetty Server Classpath:");
        System.out.println("-----------------------");
        if (classpath.count() == 0) {
            System.out.println("No classpath entries and/or version information available show.");
            return;
        }
        System.out.println("Version Information on " + classpath.count() + " entr" + (classpath.count() > 1 ? "ies" : "y") + " in the classpath.");
        System.out.println("Note: order presented here is how they would appear on the classpath.");
        System.out.println("      changes to the --module=name command line options will be reflected here.");
        int i = 0;
        for (File element : classpath.getElements()) {
            System.out.printf("%2d: %24s | %s\n", i++, this.getVersion(element), this.baseHome.toShortForm(element));
        }
    }

    public BaseHome getBaseHome() {
        return this.baseHome;
    }

    private String getVersion(File element) {
        String name;
        if (element.isDirectory()) {
            return "(dir)";
        }
        if (element.isFile() && (name = element.getName().toLowerCase(Locale.ENGLISH)).endsWith(".jar")) {
            return JarVersion.getVersion(element);
        }
        return "";
    }

    public void invokeMain(ClassLoader classloader, StartArgs args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, IOException {
        Class<?> invoked_class = null;
        String mainclass = args.getMainClassname();
        try {
            invoked_class = classloader.loadClass(mainclass);
        }
        catch (ClassNotFoundException e) {
            System.out.println("WARNING: Nothing to start, exiting ...");
            StartLog.debug(e);
            Main.usageExit(-2);
            return;
        }
        StartLog.debug("%s - %s", invoked_class, invoked_class.getPackage().getImplementationVersion());
        CommandLineBuilder cmd = args.getMainArgs(this.baseHome, false);
        String[] argArray = cmd.getArgs().toArray(new String[0]);
        StartLog.debug("Command Line Args: %s", cmd.toString());
        Class[] method_param_types = new Class[]{argArray.getClass()};
        Method main = invoked_class.getDeclaredMethod("main", method_param_types);
        Object[] method_params = new Object[]{argArray};
        StartLog.endStartLog();
        main.invoke(null, method_params);
    }

    public void listConfig(StartArgs args) {
        StartLog.endStartLog();
        args.dumpEnvironment(this.baseHome);
        args.dumpJvmArgs();
        args.dumpSystemProperties();
        args.dumpProperties();
        this.dumpClasspathWithVersions(args.getClasspath());
        args.dumpActiveXmls(this.baseHome);
    }

    private void listModules(StartArgs args) {
        StartLog.endStartLog();
        System.out.println();
        System.out.println("Jetty All Available Modules:");
        System.out.println("----------------------------");
        args.getAllModules().dump();
        System.out.println();
        System.out.println("Jetty Selected Module Ordering:");
        System.out.println("-------------------------------");
        Modules modules = args.getAllModules();
        modules.dumpSelected();
    }

    public StartArgs processCommandLine(List<String> cmdLine) throws Exception {
        return this.processCommandLine(cmdLine.toArray(new String[cmdLine.size()]));
    }

    public StartArgs processCommandLine(String[] cmdLine) throws Exception {
        CommandLineConfigSource cmdLineSource = new CommandLineConfigSource(cmdLine);
        this.baseHome = new BaseHome(cmdLineSource);
        StartLog.debug("jetty.home=%s", this.baseHome.getHome());
        StartLog.debug("jetty.base=%s", this.baseHome.getBase());
        StartLog.debug("Parsing collected arguments", new Object[0]);
        StartArgs args = new StartArgs();
        args.parse(this.baseHome.getConfigSources());
        try {
            Modules modules = new Modules(this.baseHome, args);
            StartLog.debug("Registering all modules", new Object[0]);
            modules.registerAll();
            for (String enabledModule : args.getEnabledModules()) {
                for (String source : args.getSources(enabledModule)) {
                    String shortForm = this.baseHome.toShortForm(source);
                    modules.selectNode(enabledModule, new Selection(shortForm));
                }
            }
            StartLog.debug("Building Module Graph", new Object[0]);
            modules.buildGraph();
            args.setAllModules(modules);
            List<Module> activeModules = modules.getSelected();
            args.expandLibs(this.baseHome);
            args.expandModules(this.baseHome, activeModules);
        }
        catch (GraphException e) {
            throw new UsageException(-6, (Throwable)e);
        }
        args.resolveExtraXmls(this.baseHome);
        args.resolvePropertyFiles(this.baseHome);
        return args;
    }

    public void start(StartArgs args) throws IOException, InterruptedException {
        BaseBuilder baseBuilder;
        StartLog.debug("StartArgs: %s", args);
        Classpath classpath = args.getClasspath();
        System.setProperty("java.class.path", classpath.toString());
        if (args.isHelp()) {
            this.usage(true);
        }
        if (args.isListClasspath()) {
            this.dumpClasspathWithVersions(classpath);
        }
        if (args.isListConfig()) {
            this.listConfig(args);
        }
        if (args.isListModules()) {
            this.listModules(args);
        }
        if (args.getModuleGraphFilename() != null) {
            Path outputFile = this.baseHome.getBasePath(args.getModuleGraphFilename());
            System.out.printf("Generating GraphViz Graph of Jetty Modules at %s%n", this.baseHome.toShortForm(outputFile));
            ModuleGraphWriter writer = new ModuleGraphWriter();
            writer.config(args.getProperties());
            writer.write(args.getAllModules(), outputFile);
        }
        if (args.isDryRun()) {
            CommandLineBuilder cmd = args.getMainArgs(this.baseHome, true);
            System.out.println(cmd.toString(File.separatorChar == '/' ? " \\\n" : " "));
        }
        if (args.isStopCommand()) {
            this.doStop(args);
        }
        if ((baseBuilder = new BaseBuilder(this.baseHome, args)).build()) {
            StartLog.info("Base directory was modified", new Object[0]);
            return;
        }
        if (!args.isRun()) {
            return;
        }
        if (args.isExec()) {
            CommandLineBuilder cmd = args.getMainArgs(this.baseHome, true);
            cmd.debug();
            ProcessBuilder pbuilder = new ProcessBuilder(cmd.getArgs());
            StartLog.endStartLog();
            final Process process = pbuilder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    StartLog.debug("Destroying " + process, new Object[0]);
                    process.destroy();
                }
            });
            this.copyInThread(process.getErrorStream(), System.err);
            this.copyInThread(process.getInputStream(), System.out);
            this.copyInThread(System.in, process.getOutputStream());
            process.waitFor();
            System.exit(0);
            return;
        }
        if (args.hasJvmArgs() || args.hasSystemProperties()) {
            System.err.println("WARNING: System properties and/or JVM args set.  Consider using --dry-run or --exec");
        }
        ClassLoader cl = classpath.getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            this.invokeMain(cl, args);
        }
        catch (Exception e) {
            Main.usageExit(e, -2);
        }
    }

    private void doStop(StartArgs args) {
        int stopPort = Integer.parseInt(args.getProperties().getString("STOP.PORT"));
        String stopKey = args.getProperties().getString("STOP.KEY");
        if (args.getProperties().getString("STOP.WAIT") != null) {
            int stopWait = Integer.parseInt(args.getProperties().getString("STOP.WAIT"));
            this.stop(stopPort, stopKey, stopWait);
        } else {
            this.stop(stopPort, stopKey);
        }
    }

    public void stop(int port, String key) {
        this.stop(port, key, 0);
    }

    public void stop(int port, String key, int timeout) {
        int _port = port;
        String _key = key;
        try {
            if (_port <= 0) {
                System.err.println("STOP.PORT system property must be specified");
            }
            if (_key == null) {
                _key = "";
                System.err.println("STOP.KEY system property must be specified");
                System.err.println("Using empty key");
            }
            try (Socket s = new Socket(InetAddress.getByName("127.0.0.1"), _port);){
                if (timeout > 0) {
                    s.setSoTimeout(timeout * 1000);
                }
                try (OutputStream out = s.getOutputStream();){
                    out.write((_key + "\r\nstop\r\n").getBytes());
                    out.flush();
                    if (timeout > 0) {
                        String response;
                        System.err.printf("Waiting %,d seconds for jetty to stop%n", timeout);
                        LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                        while ((response = lin.readLine()) != null) {
                            StartLog.debug("Received \"%s\"", response);
                            if (!"Stopped".equals(response)) continue;
                            StartLog.warn("Server reports itself as Stopped", new Object[0]);
                        }
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            System.err.println("Timed out waiting for stop confirmation");
            System.exit(-9);
        }
        catch (ConnectException e) {
            Main.usageExit(e, -4);
        }
        catch (Exception e) {
            Main.usageExit(e, -9);
        }
    }

    public void usage(boolean exit) {
        StartLog.endStartLog();
        if (!Main.printTextResource("org/eclipse/jetty/start/usage.txt")) {
            System.err.println("ERROR: detailed usage resource unavailable");
        }
        if (exit) {
            System.exit(1);
        }
    }

    public static boolean printTextResource(String resourceName) {
        boolean resourcePrinted;
        block40: {
            resourcePrinted = false;
            try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);){
                if (stream != null) {
                    try (InputStreamReader reader = new InputStreamReader(stream);
                         BufferedReader buf = new BufferedReader(reader);){
                        String line;
                        resourcePrinted = true;
                        while ((line = buf.readLine()) != null) {
                            System.out.println(line);
                        }
                        break block40;
                    }
                }
                System.out.println("Unable to find resource: " + resourceName);
            }
            catch (IOException e) {
                StartLog.warn(e);
            }
        }
        return resourcePrinted;
    }

    public void init(String[] args) throws Exception {
        try {
            this.startupArgs = this.processCommandLine(args);
        }
        catch (UsageException e) {
            System.err.println(e.getMessage());
            Main.usageExit(e.getCause(), e.getExitCode());
        }
        catch (Throwable e) {
            Main.usageExit(e, -9);
        }
    }

    public void start() throws Exception {
        this.start(this.startupArgs);
    }

    public void stop() throws Exception {
        this.doStop(this.startupArgs);
    }

    public void destroy() {
    }
}

