/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.graph.Node;

public class Module
extends Node<Module> {
    private Path file;
    private String fileRef;
    private List<String> xmls;
    private List<String> defaultConfig;
    private boolean hasDefaultConfig = false;
    private List<String> libs;
    private List<String> files;
    private List<String> jvmArgs;
    private List<String> license;

    public Module(BaseHome basehome, Path file) throws FileNotFoundException, IOException {
        this.file = file;
        this.fileRef = Pattern.compile(".mod$", 2).matcher(file.getFileName().toString()).replaceFirst("");
        this.setName(this.fileRef);
        this.init(basehome);
        this.process(basehome);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Module other = (Module)obj;
        return !(this.fileRef == null ? other.fileRef != null : !this.fileRef.equals(other.fileRef));
    }

    public void expandProperties(Props props) {
        ArrayList<String> parents = new ArrayList<String>();
        for (String parent : this.getParentNames()) {
            parents.add(props.expand(parent));
        }
        this.setParentNames(parents);
    }

    public List<String> getDefaultConfig() {
        return this.defaultConfig;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public String getFilesystemRef() {
        return this.fileRef;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public List<String> getLibs() {
        return this.libs;
    }

    public List<String> getLicense() {
        return this.license;
    }

    public List<String> getXmls() {
        return this.xmls;
    }

    public boolean hasDefaultConfig() {
        return this.hasDefaultConfig;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileRef == null ? 0 : this.fileRef.hashCode());
        return result;
    }

    public boolean hasLicense() {
        return this.license != null && this.license.size() > 0;
    }

    private void init(BaseHome basehome) {
        this.xmls = new ArrayList<String>();
        this.defaultConfig = new ArrayList<String>();
        this.libs = new ArrayList<String>();
        this.files = new ArrayList<String>();
        this.jvmArgs = new ArrayList<String>();
        this.license = new ArrayList<String>();
        String name = basehome.toShortForm(this.file);
        Pattern pat = Pattern.compile("^.*[/\\\\]{1}modules[/\\\\]{1}(.*).mod$", 2);
        Matcher mat = pat.matcher(name);
        if (!mat.find()) {
            throw new RuntimeException("Invalid Module location (must be located under /modules/ directory): " + name);
        }
        this.fileRef = mat.group(1).replace('\\', '/');
        this.setName(this.fileRef);
    }

    public boolean isVirtual() {
        return !this.getName().equals(this.fileRef);
    }

    public boolean hasFiles(BaseHome baseHome) {
        for (String ref : this.getFiles()) {
            FileArg farg = new FileArg(this, ref);
            Path refPath = baseHome.getBasePath(farg.location);
            if (Files.exists(refPath, new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    public void process(BaseHome basehome) throws FileNotFoundException, IOException {
        Pattern section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
        if (!FS.canReadFile(this.file)) {
            StartLog.debug("Skipping read of missing file: %s", basehome.toShortForm(this.file));
            return;
        }
        try (BufferedReader buf = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);){
            String line;
            String sectionType = "";
            block35: while ((line = buf.readLine()) != null) {
                Matcher sectionMatcher = section.matcher(line = line.trim());
                if (sectionMatcher.matches()) {
                    sectionType = sectionMatcher.group(1).trim().toUpperCase(Locale.ENGLISH);
                    continue;
                }
                if (line.length() == 0 || line.startsWith("#")) {
                    if (!"INI-TEMPLATE".equals(sectionType)) continue;
                    this.defaultConfig.add(line);
                    continue;
                }
                switch (sectionType) {
                    case "": {
                        continue block35;
                    }
                    case "DEPEND": {
                        this.addParentName(line);
                        continue block35;
                    }
                    case "FILES": {
                        this.files.add(line);
                        continue block35;
                    }
                    case "DEFAULTS": 
                    case "INI-TEMPLATE": {
                        this.defaultConfig.add(line);
                        this.hasDefaultConfig = true;
                        continue block35;
                    }
                    case "LIB": {
                        this.libs.add(line);
                        continue block35;
                    }
                    case "LICENSE": 
                    case "LICENCE": {
                        this.license.add(line);
                        continue block35;
                    }
                    case "NAME": {
                        this.setName(line);
                        continue block35;
                    }
                    case "OPTIONAL": {
                        this.addOptionalParentName(line);
                        continue block35;
                    }
                    case "EXEC": {
                        this.jvmArgs.add(line);
                        continue block35;
                    }
                    case "XML": {
                        this.xmls.add(line);
                        continue block35;
                    }
                }
                throw new IOException("Unrecognized Module section: [" + sectionType + "]");
            }
        }
    }

    public void setEnabled(boolean enabled) {
        throw new RuntimeException("Don't enable directly");
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Module[").append(this.getName());
        if (this.isVirtual()) {
            str.append(",file=").append(this.fileRef);
        }
        if (this.isSelected()) {
            str.append(",selected");
        }
        str.append(']');
        return str.toString();
    }

    public static class NameComparator
    implements Comparator<Module> {
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(Module o1, Module o2) {
            CollationKey k1 = this.collator.getCollationKey(o1.fileRef);
            CollationKey k2 = this.collator.getCollationKey(o2.fileRef);
            return k1.compareTo(k2);
        }
    }
}

