/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.CommandLineBuilder;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.RawArgs;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.UsageException;
import org.eclipse.jetty.start.Utils;
import org.eclipse.jetty.start.config.ConfigSource;
import org.eclipse.jetty.start.config.ConfigSources;
import org.eclipse.jetty.start.config.DirConfigSource;

public class StartArgs {
    public static final String VERSION;
    private static final String SERVER_MAIN = "org.eclipse.jetty.xml.XmlConfiguration";
    private Set<String> modules = new HashSet<String>();
    private Map<String, List<String>> sources = new HashMap<String, List<String>>();
    private Map<String, String> propertySource = new HashMap<String, String>();
    private List<FileArg> files = new ArrayList<FileArg>();
    private Classpath classpath;
    private List<Path> xmls = new ArrayList<Path>();
    private List<String> jvmArgs = new ArrayList<String>();
    private List<String> xmlRefs = new ArrayList<String>();
    private List<String> propertyFileRefs = new ArrayList<String>();
    private List<Path> propertyFiles = new ArrayList<Path>();
    private Props properties = new Props();
    private Set<String> systemPropertyKeys = new HashSet<String>();
    private List<String> rawLibs = new ArrayList<String>();
    private List<String> addToStartdIni = new ArrayList<String>();
    private List<String> addToStartIni = new ArrayList<String>();
    private String moduleGraphFilename;
    private Modules allModules;
    private boolean run = true;
    private boolean download = false;
    private boolean licenseCheckRequired = false;
    private boolean testingMode = false;
    private boolean help = false;
    private boolean stopCommand = false;
    private boolean listModules = false;
    private boolean listClasspath = false;
    private boolean listConfig = false;
    private boolean version = false;
    private boolean dryRun = false;
    private boolean exec = false;
    private boolean approveAllLicenses = false;

    public StartArgs() {
        this.classpath = new Classpath();
    }

    private void addFile(Module module, String uriLocation) {
        FileArg arg = new FileArg(module, uriLocation);
        if (!this.files.contains(arg)) {
            this.files.add(arg);
        }
    }

    public void addSystemProperty(String key, String value) {
        this.systemPropertyKeys.add(key);
        System.setProperty(key, value);
    }

    private void addUniqueXmlFile(String xmlRef, Path xmlfile) throws IOException {
        if (!FS.canReadFile(xmlfile)) {
            throw new IOException("Cannot read file: " + xmlRef);
        }
        if (!this.xmls.contains(xmlfile = FS.toRealPath(xmlfile))) {
            this.xmls.add(xmlfile);
        }
    }

    private void addUniquePropertyFile(String propertyFileRef, Path propertyFile) throws IOException {
        if (!FS.canReadFile(propertyFile)) {
            throw new IOException("Cannot read file: " + propertyFileRef);
        }
        if (!this.propertyFiles.contains(propertyFile = FS.toRealPath(propertyFile))) {
            this.propertyFiles.add(propertyFile);
        }
    }

    public void dumpActiveXmls(BaseHome baseHome) {
        System.out.println();
        System.out.println("Jetty Active XMLs:");
        System.out.println("------------------");
        if (this.xmls.isEmpty()) {
            System.out.println(" (no xml files specified)");
            return;
        }
        for (Path xml : this.xmls) {
            System.out.printf(" %s%n", baseHome.toShortForm(xml.toAbsolutePath()));
        }
    }

    public void dumpEnvironment(BaseHome baseHome) {
        System.out.println();
        System.out.println("Java Environment:");
        System.out.println("-----------------");
        this.dumpSystemProperty("java.home");
        this.dumpSystemProperty("java.vm.vendor");
        this.dumpSystemProperty("java.vm.version");
        this.dumpSystemProperty("java.vm.name");
        this.dumpSystemProperty("java.vm.info");
        this.dumpSystemProperty("java.runtime.name");
        this.dumpSystemProperty("java.runtime.version");
        this.dumpSystemProperty("java.io.tmpdir");
        this.dumpSystemProperty("user.dir");
        this.dumpSystemProperty("user.language");
        this.dumpSystemProperty("user.country");
        System.out.println();
        System.out.println("Jetty Environment:");
        System.out.println("-----------------");
        this.dumpProperty("jetty.version");
        this.dumpProperty("jetty.home");
        this.dumpProperty("jetty.base");
        System.out.println();
        System.out.println("Config Search Order:");
        System.out.println("--------------------");
        for (ConfigSource config : baseHome.getConfigSources()) {
            DirConfigSource dirsource;
            System.out.printf(" %s", config.getId());
            if (config instanceof DirConfigSource && (dirsource = (DirConfigSource)config).isPropertyBased()) {
                System.out.printf(" -> %s", dirsource.getDir());
            }
            System.out.println();
        }
        System.out.println();
    }

    public void dumpJvmArgs() {
        System.out.println();
        System.out.println("JVM Arguments:");
        System.out.println("--------------");
        if (this.jvmArgs.isEmpty()) {
            System.out.println(" (no jvm args specified)");
            return;
        }
        for (String jvmArgKey : this.jvmArgs) {
            String value = System.getProperty(jvmArgKey);
            if (value != null) {
                System.out.printf(" %s = %s%n", jvmArgKey, value);
                continue;
            }
            System.out.printf(" %s%n", jvmArgKey);
        }
    }

    public void dumpProperties() {
        System.out.println();
        System.out.println("Properties:");
        System.out.println("-----------");
        ArrayList<String> sortedKeys = new ArrayList<String>();
        for (Props.Prop prop : this.properties) {
            if (prop.origin.equals("<system-property>")) continue;
            sortedKeys.add(prop.key);
        }
        if (sortedKeys.isEmpty()) {
            System.out.println(" (no properties specified)");
            return;
        }
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            this.dumpProperty(key);
        }
    }

    private void dumpProperty(String key) {
        Props.Prop prop = this.properties.getProp(key);
        if (prop == null) {
            System.out.printf(" %s (not defined)%n", key);
        } else {
            System.out.printf(" %s = %s%n", key, this.properties.expand(prop.value));
            if (StartLog.isDebugEnabled()) {
                System.out.printf("   origin: %s%n", prop.origin);
                while (prop.overrides != null) {
                    prop = prop.overrides;
                    System.out.printf("   (overrides)%n", new Object[0]);
                    System.out.printf("     %s = %s%n", key, this.properties.expand(prop.value));
                    System.out.printf("     origin: %s%n", prop.origin);
                }
            }
        }
    }

    public void dumpSystemProperties() {
        System.out.println();
        System.out.println("System Properties:");
        System.out.println("------------------");
        if (this.systemPropertyKeys.isEmpty()) {
            System.out.println(" (no system properties specified)");
            return;
        }
        ArrayList<String> sortedKeys = new ArrayList<String>();
        sortedKeys.addAll(this.systemPropertyKeys);
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            String value = System.getProperty(key);
            System.out.printf(" %s = %s%n", key, this.properties.expand(value));
        }
    }

    private void dumpSystemProperty(String key) {
        System.out.printf(" %s = %s%n", key, System.getProperty(key));
    }

    private void ensureSystemPropertySet(String key) {
        if (this.systemPropertyKeys.contains(key)) {
            return;
        }
        if (this.properties.containsKey(key)) {
            String val = this.properties.expand(this.properties.getString(key));
            if (val == null) {
                return;
            }
            this.systemPropertyKeys.add(key);
            System.setProperty(key, val);
        }
    }

    public void expandLibs(BaseHome baseHome) throws IOException {
        StartLog.debug("Expanding Libs", new Object[0]);
        for (String rawlibref : this.rawLibs) {
            StartLog.debug("rawlibref = " + rawlibref, new Object[0]);
            String libref = this.properties.expand(rawlibref);
            StartLog.debug("expanded = " + libref, new Object[0]);
            libref = libref.replaceAll("\\\\([^\\\\])", "\\\\\\\\$1");
            for (Path libpath : baseHome.getPaths(libref)) {
                this.classpath.addComponent(libpath.toFile());
            }
        }
    }

    public void expandModules(BaseHome baseHome, List<Module> activeModules) throws IOException {
        StartLog.debug("Expanding Modules", new Object[0]);
        for (Module module : activeModules) {
            for (String rawlibref : module.getLibs()) {
                StartLog.debug("rawlibref = " + rawlibref, new Object[0]);
                String libref = this.properties.expand(rawlibref);
                StartLog.debug("expanded = " + libref, new Object[0]);
                for (Path libpath : baseHome.getPaths(libref)) {
                    this.classpath.addComponent(libpath.toFile());
                }
            }
            for (String jvmArg : module.getJvmArgs()) {
                this.exec = true;
                this.jvmArgs.add(jvmArg);
            }
            for (String xmlRef : module.getXmls()) {
                xmlRef = this.properties.expand(xmlRef);
                Path xmlfile = baseHome.getPath(xmlRef);
                this.addUniqueXmlFile(xmlRef, xmlfile);
            }
            for (String file : module.getFiles()) {
                StartLog.debug("Adding module specified file: %s", file);
                this.addFile(module, file);
            }
        }
    }

    public List<String> getAddToStartdIni() {
        return this.addToStartdIni;
    }

    public List<String> getAddToStartIni() {
        return this.addToStartIni;
    }

    public Modules getAllModules() {
        return this.allModules;
    }

    public Classpath getClasspath() {
        return this.classpath;
    }

    public Set<String> getEnabledModules() {
        return this.modules;
    }

    public List<FileArg> getFiles() {
        return this.files;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public CommandLineBuilder getMainArgs(BaseHome baseHome, boolean addJavaInit) throws IOException {
        CommandLineBuilder cmd = new CommandLineBuilder();
        if (addJavaInit) {
            cmd.addRawArg(CommandLineBuilder.findJavaBin());
            for (String x : this.jvmArgs) {
                cmd.addRawArg(x);
            }
            cmd.addRawArg("-Djava.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
            cmd.addRawArg("-Djetty.home=" + baseHome.getHome());
            cmd.addRawArg("-Djetty.base=" + baseHome.getBase());
            for (String propKey : this.systemPropertyKeys) {
                String value = System.getProperty(propKey);
                cmd.addEqualsArg("-D" + propKey, value);
            }
            cmd.addRawArg("-cp");
            cmd.addRawArg(this.classpath.toString());
            cmd.addRawArg(this.getMainClassname());
        }
        this.ensureSystemPropertySet("STOP.PORT");
        this.ensureSystemPropertySet("STOP.KEY");
        this.ensureSystemPropertySet("STOP.WAIT");
        if (this.dryRun || this.isExec()) {
            for (Props.Prop p : this.properties) {
                cmd.addRawArg(CommandLineBuilder.quote(p.key) + "=" + CommandLineBuilder.quote(p.value));
            }
        } else if (this.properties.size() > 0) {
            File prop_file = File.createTempFile("start", ".properties");
            prop_file.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(prop_file);){
                this.properties.store(out, "start.jar properties");
            }
            cmd.addRawArg(prop_file.getAbsolutePath());
        }
        for (Path xml : this.xmls) {
            cmd.addRawArg(xml.toAbsolutePath().toString());
        }
        for (Path propertyFile : this.propertyFiles) {
            cmd.addRawArg(propertyFile.toAbsolutePath().toString());
        }
        return cmd;
    }

    public String getMainClassname() {
        String mainclass = System.getProperty("jetty.server", SERVER_MAIN);
        return System.getProperty("main.class", mainclass);
    }

    public Path getMavenLocalRepoDir() {
        String localRepo = this.getProperties().getString("maven.local.repo");
        if (Utils.isBlank(localRepo)) {
            localRepo = System.getenv("JETTY_MAVEN_LOCAL_REPO");
        }
        if (Utils.isBlank(localRepo)) {
            localRepo = System.getenv("MAVEN_LOCAL_REPO");
        }
        if (Utils.isBlank(localRepo)) {
            return null;
        }
        Path localRepoDir = new File(localRepo).toPath();
        if (Files.exists(localRepoDir = localRepoDir.normalize().toAbsolutePath(), new LinkOption[0]) && Files.isDirectory(localRepoDir, new LinkOption[0])) {
            return localRepoDir;
        }
        StartLog.warn("Not a valid maven local repository directory: %s", localRepoDir);
        return null;
    }

    public String getModuleGraphFilename() {
        return this.moduleGraphFilename;
    }

    public Props getProperties() {
        return this.properties;
    }

    public List<String> getSources(String module) {
        return this.sources.get(module);
    }

    public List<Path> getXmlFiles() {
        return this.xmls;
    }

    public boolean hasJvmArgs() {
        return this.jvmArgs.size() > 0;
    }

    public boolean hasSystemProperties() {
        for (String key : this.systemPropertyKeys) {
            if ("jetty.home".equals(key) || "jetty.base".equals(key) || "main.class".equals(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isApproveAllLicenses() {
        return this.approveAllLicenses;
    }

    public boolean isDownload() {
        return this.download;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isExec() {
        return this.exec;
    }

    public boolean isLicenseCheckRequired() {
        return this.licenseCheckRequired;
    }

    public boolean isNormalMainClass() {
        return SERVER_MAIN.equals(this.getMainClassname());
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isListClasspath() {
        return this.listClasspath;
    }

    public boolean isListConfig() {
        return this.listConfig;
    }

    public boolean isListModules() {
        return this.listModules;
    }

    public boolean isRun() {
        return this.run;
    }

    public boolean isStopCommand() {
        return this.stopCommand;
    }

    public boolean isTestingModeEnabled() {
        return this.testingMode;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void parse(ConfigSources sources) {
        ListIterator<ConfigSource> iter = sources.reverseListIterator();
        while (iter.hasPrevious()) {
            ConfigSource source = iter.previous();
            for (RawArgs.Entry arg : source.getArgs()) {
                this.parse(arg.getLine(), arg.getOrigin());
            }
        }
    }

    public void parse(String rawarg, String source) {
        this.parse(rawarg, source, true);
    }

    private void parse(String rawarg, String source, boolean replaceProps) {
        if (rawarg == null) {
            return;
        }
        StartLog.debug("parse(\"%s\", \"%s\", %b)", rawarg, source, replaceProps);
        String arg = rawarg.trim();
        if (arg.length() <= 0) {
            return;
        }
        if (arg.startsWith("#")) {
            return;
        }
        if ("--help".equals(arg) || "-?".equals(arg)) {
            this.help = true;
            this.run = false;
            return;
        }
        if ("--debug".equals(arg) || arg.startsWith("--start-log-file")) {
            return;
        }
        if ("--testing-mode".equals(arg)) {
            System.setProperty("org.eclipse.jetty.start.testing", "true");
            this.testingMode = true;
            return;
        }
        if (arg.startsWith("--include-jetty-dir=")) {
            return;
        }
        if ("--stop".equals(arg)) {
            this.stopCommand = true;
            this.run = false;
            return;
        }
        if (arg.startsWith("--download=")) {
            this.addFile(null, Props.getValue(arg));
            this.run = false;
            this.download = true;
            return;
        }
        if (arg.equals("--create-files")) {
            this.run = false;
            this.download = true;
            this.licenseCheckRequired = true;
            return;
        }
        if ("--list-classpath".equals(arg) || "--version".equals(arg) || "-v".equals(arg) || "--info".equals(arg)) {
            this.listClasspath = true;
            this.run = false;
            return;
        }
        if ("--list-config".equals(arg)) {
            this.listConfig = true;
            this.run = false;
            return;
        }
        if ("--dry-run".equals(arg) || "--exec-print".equals(arg)) {
            this.dryRun = true;
            this.run = false;
            return;
        }
        if ("--exec".equals(arg)) {
            this.exec = true;
            return;
        }
        if ("--approve-all-licenses".equals(arg)) {
            this.approveAllLicenses = true;
            return;
        }
        if (arg.startsWith("--lib=")) {
            String cp = Props.getValue(arg);
            if (cp != null) {
                StringTokenizer t = new StringTokenizer(cp, File.pathSeparator);
                while (t.hasMoreTokens()) {
                    this.rawLibs.add(t.nextToken());
                }
            }
            return;
        }
        if ("--list-modules".equals(arg)) {
            this.listModules = true;
            this.run = false;
            return;
        }
        if (arg.startsWith("--add-to-startd=")) {
            List<String> moduleNames = Props.getValues(arg);
            this.addToStartdIni.addAll(moduleNames);
            this.run = false;
            this.download = true;
            this.licenseCheckRequired = true;
            return;
        }
        if (arg.startsWith("--add-to-start=")) {
            List<String> moduleNames = Props.getValues(arg);
            this.addToStartIni.addAll(moduleNames);
            this.run = false;
            this.download = true;
            this.licenseCheckRequired = true;
            return;
        }
        if (arg.startsWith("--module=")) {
            List<String> moduleNames = Props.getValues(arg);
            this.enableModules(source, moduleNames);
            return;
        }
        if (arg.startsWith("--write-module-graph=")) {
            this.moduleGraphFilename = Props.getValue(arg);
            this.run = false;
            return;
        }
        if (arg.startsWith("-D")) {
            String[] assign = arg.substring(2).split("=", 2);
            this.systemPropertyKeys.add(assign[0]);
            switch (assign.length) {
                case 2: {
                    System.setProperty(assign[0], assign[1]);
                    this.setProperty(assign[0], assign[1], source, replaceProps);
                    break;
                }
                case 1: {
                    System.setProperty(assign[0], "");
                    this.setProperty(assign[0], "", source, replaceProps);
                    break;
                }
            }
            return;
        }
        if (arg.startsWith("-")) {
            if (!this.jvmArgs.contains(arg)) {
                this.jvmArgs.add(arg);
            }
            return;
        }
        int idx = arg.indexOf(61);
        if (idx >= 0) {
            String key = arg.substring(0, idx);
            String value = arg.substring(idx + 1);
            if (replaceProps) {
                if (this.propertySource.containsKey(key)) {
                    StartLog.warn("Property %s in %s already set in %s", key, source, this.propertySource.get(key));
                }
                this.propertySource.put(key, source);
            }
            if ("OPTION".equals(key) || "OPTIONS".equals(key)) {
                StringBuilder warn = new StringBuilder();
                warn.append("The behavior of the argument ");
                warn.append(arg).append(" (seen in ").append(source);
                warn.append(") has changed, and is now considered a normal property.  ");
                warn.append(key).append(" no longer controls what libraries are on your classpath,");
                warn.append(" use --module instead. See --help for details.");
                StartLog.warn(warn.toString(), new Object[0]);
            }
            this.setProperty(key, value, source, replaceProps);
            return;
        }
        if (FS.isXml(arg)) {
            if (!this.xmlRefs.contains(arg)) {
                this.xmlRefs.add(arg);
            }
            return;
        }
        if (FS.isPropertyFile(arg)) {
            if (!this.propertyFileRefs.contains(arg)) {
                this.propertyFileRefs.add(arg);
            }
            return;
        }
        throw new UsageException(-5, "Unrecognized argument: \"%s\" in %s", arg, source);
    }

    private void enableModules(String source, List<String> moduleNames) {
        for (String moduleName : moduleNames) {
            this.modules.add(moduleName);
            List<String> list = this.sources.get(moduleName);
            if (list == null) {
                list = new ArrayList<String>();
                this.sources.put(moduleName, list);
            }
            list.add(source);
        }
    }

    public void parseModule(Module module) {
        if (module.hasDefaultConfig()) {
            for (String line : module.getDefaultConfig()) {
                this.parse(line, module.getFilesystemRef(), false);
            }
        }
    }

    public void resolveExtraXmls(BaseHome baseHome) throws IOException {
        for (String xmlRef : this.xmlRefs) {
            Path xmlfile = baseHome.getPath(xmlRef);
            if (!FS.exists(xmlfile)) {
                xmlfile = baseHome.getPath("etc/" + xmlRef);
            }
            this.addUniqueXmlFile(xmlRef, xmlfile);
        }
    }

    public void resolvePropertyFiles(BaseHome baseHome) throws IOException {
        for (String propertyFileRef : this.propertyFileRefs) {
            Path propertyFile = baseHome.getPath(propertyFileRef);
            if (!FS.exists(propertyFile)) {
                propertyFile = baseHome.getPath("etc/" + propertyFileRef);
            }
            this.addUniquePropertyFile(propertyFileRef, propertyFile);
        }
    }

    public void setAllModules(Modules allModules) {
        this.allModules = allModules;
    }

    private void setProperty(String key, String value, String source, boolean replaceProp) {
        if (key.equals("jetty.home")) {
            this.properties.setProperty("jetty.home", System.getProperty("jetty.home"), source);
            return;
        }
        if (key.equals("jetty.base")) {
            this.properties.setProperty("jetty.base", System.getProperty("jetty.base"), source);
            return;
        }
        if (replaceProp) {
            this.properties.setProperty(key, value, source);
        } else if (!this.properties.containsKey(key)) {
            this.properties.setProperty(key, value, source);
        }
    }

    public void setRun(boolean run) {
        this.run = run;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StartArgs [enabledModules=");
        builder.append(this.modules);
        builder.append(", xmlRefs=");
        builder.append(this.xmlRefs);
        builder.append(", properties=");
        builder.append(this.properties);
        builder.append(", jvmArgs=");
        builder.append(this.jvmArgs);
        builder.append("]");
        return builder.toString();
    }

    static {
        Package pkg;
        String ver = System.getProperty("jetty.version", null);
        if (ver == null && (pkg = StartArgs.class.getPackage()) != null && "Eclipse.org - Jetty".equals(pkg.getImplementationVendor()) && pkg.getImplementationVersion() != null) {
            ver = pkg.getImplementationVersion();
        }
        if (ver == null) {
            ver = "TEST";
        }
        VERSION = ver;
        System.setProperty("jetty.version", VERSION);
    }
}

