/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.builders;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.jetty.start.BaseBuilder;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.graph.OnlyTransitivePredicate;

public class StartDirBuilder
implements BaseBuilder.Config {
    private final BaseHome baseHome;
    private final Path startDir;

    public StartDirBuilder(BaseBuilder baseBuilder) throws IOException {
        this.baseHome = baseBuilder.getBaseHome();
        this.startDir = this.baseHome.getBasePath("start.d");
        FS.ensureDirectoryExists(this.startDir);
    }

    @Override
    public boolean addModule(Module module) throws IOException {
        if (module.isVirtual()) {
            StartLog.info("%-15s skipping (virtual module)", module.getName());
            return false;
        }
        String mode = "";
        if (module.matches(OnlyTransitivePredicate.INSTANCE)) {
            mode = "(transitively) ";
        }
        Path ini = this.startDir.resolve(module.getName() + ".ini");
        StartLog.info("%-15s initialised %sin %s", module.getName(), mode, this.baseHome.toShortForm(ini));
        try (BufferedWriter writer = Files.newBufferedWriter(ini, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.writeModuleSection(writer, module);
        }
        return true;
    }

    protected void writeModuleSection(BufferedWriter writer, Module module) {
        PrintWriter out = new PrintWriter(writer);
        out.println("# --------------------------------------- ");
        out.println("# Module: " + module.getName());
        out.println("--module=" + module.getName());
        for (String line : module.getDefaultConfig()) {
            out.println(line);
        }
        out.println();
        out.flush();
    }
}

