/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.fileinits;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileInitializer;
import org.eclipse.jetty.start.StartLog;

public class UriFileInitializer
implements FileInitializer {
    private static final String[] SUPPORTED_SCHEMES = new String[]{"http", "https"};
    protected final BaseHome baseHome;

    public UriFileInitializer(BaseHome baseHome) {
        this.baseHome = baseHome;
    }

    @Override
    public boolean init(URI uri, Path file) throws IOException {
        if (!this.isSupportedScheme(uri)) {
            return false;
        }
        if (this.isFilePresent(file)) {
            return true;
        }
        this.download(uri, file);
        return true;
    }

    protected void download(URI uri, Path file) throws IOException {
        StartLog.log("DOWNLOAD", "%s to %s", uri, this.baseHome.toShortForm(file));
        FS.ensureDirectoryExists(file.getParent());
        HttpURLConnection http = (HttpURLConnection)uri.toURL().openConnection();
        http.setInstanceFollowRedirects(true);
        http.setAllowUserInteraction(false);
        int status = http.getResponseCode();
        if (status != 200) {
            throw new IOException("URL GET Failure [" + status + "/" + http.getResponseMessage() + "] on " + uri);
        }
        byte[] buf = new byte[8192];
        try (InputStream in = http.getInputStream();
             OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            int len;
            do {
                if ((len = in.read(buf)) <= 0) continue;
                out.write(buf, 0, len);
            } while (len >= 0);
        }
    }

    protected boolean isFilePresent(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                throw new IOException("Directory in the way: " + file.toAbsolutePath());
            }
            if (!Files.isReadable(file)) {
                throw new IOException("File not readable: " + file.toAbsolutePath());
            }
            return true;
        }
        return false;
    }

    private boolean isSupportedScheme(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return false;
        }
        for (String supported : SUPPORTED_SCHEMES) {
            if (!supported.equalsIgnoreCase(scheme)) continue;
            return true;
        }
        return false;
    }
}

