/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.graph;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.start.graph.Node;
import org.eclipse.jetty.start.graph.Predicate;
import org.eclipse.jetty.start.graph.Selection;

public class HowSetPredicate
implements Predicate {
    private final Set<String> howSet = new HashSet<String>();

    public HowSetPredicate(String ... hows) {
        for (String name : hows) {
            this.howSet.add(name);
        }
    }

    @Override
    public boolean match(Node<?> node) {
        Set<Selection> selections = node.getSelections();
        if (selections == null) {
            return false;
        }
        Set<String> actualHows = node.getSelectedHowSet();
        if (actualHows.size() != this.howSet.size()) {
            return false;
        }
        for (String how : actualHows) {
            if (this.howSet.contains(how)) continue;
            return false;
        }
        return true;
    }
}

