/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.graph;

public class Selection {
    private final boolean explicit;
    private final String how;

    public Selection(String how) {
        this(how, true);
    }

    public Selection(String how, boolean explicit) {
        this.how = how;
        this.explicit = explicit;
    }

    public Selection asTransitive() {
        if (this.explicit) {
            return new Selection(this.how, false);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Selection other = (Selection)obj;
        if (this.explicit != other.explicit) {
            return false;
        }
        return !(this.how == null ? other.how != null : !this.how.equals(other.how));
    }

    public String getHow() {
        return this.how;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.explicit ? 1231 : 1237);
        result = 31 * result + (this.how == null ? 0 : this.how.hashCode());
        return result;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (!this.explicit) {
            str.append("<transitive from> ");
        }
        str.append(this.how);
        return str.toString();
    }
}

