/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.graph.Graph;
import org.eclipse.jetty.start.graph.GraphException;
import org.eclipse.jetty.start.graph.OnlyTransitivePredicate;
import org.eclipse.jetty.start.graph.Selection;

public class Modules
extends Graph<Module> {
    private final BaseHome baseHome;
    private final StartArgs args;

    public Modules(BaseHome basehome, StartArgs args) {
        this.baseHome = basehome;
        this.args = args;
        this.setSelectionTerm("enable");
        this.setNodeTerm("module");
        String java_version = System.getProperty("java.version");
        if (java_version != null) {
            String[] parts = java_version.split("\\.");
            if (parts != null && parts.length > 0) {
                System.setProperty("java.version.major", parts[0]);
            }
            if (parts != null && parts.length > 1) {
                System.setProperty("java.version.minor", parts[1]);
            }
        }
    }

    public void dump() {
        ArrayList ordered = new ArrayList();
        ordered.addAll(this.getNodes());
        Collections.sort(ordered, new Module.NameComparator());
        List active = this.getSelected();
        for (Module module : ordered) {
            boolean activated = active.contains(module);
            boolean selected = module.isSelected();
            boolean transitive = selected && module.matches(OnlyTransitivePredicate.INSTANCE);
            String status = "[ ]";
            if (transitive) {
                status = "[t]";
            } else if (selected) {
                status = "[x]";
            }
            System.out.printf("%n %s Module: %s%n", status, module.getName());
            if (!module.getName().equals(module.getFilesystemRef())) {
                System.out.printf("        Ref: %s%n", module.getFilesystemRef());
            }
            for (String parent : module.getParentNames()) {
                System.out.printf("     Depend: %s%n", parent);
            }
            for (String lib : module.getLibs()) {
                System.out.printf("        LIB: %s%n", lib);
            }
            for (String xml : module.getXmls()) {
                System.out.printf("        XML: %s%n", xml);
            }
            if (StartLog.isDebugEnabled()) {
                System.out.printf("      depth: %d%n", module.getDepth());
            }
            if (activated) {
                for (Selection selection : module.getSelections()) {
                    System.out.printf("    Enabled: <via> %s%n", selection);
                }
                continue;
            }
            System.out.printf("    Enabled: <not enabled in this configuration>%n", new Object[0]);
        }
    }

    @Override
    public Module resolveNode(String name) {
        String expandedName = this.args.getProperties().expand(name);
        if (Props.hasPropertyKey(expandedName)) {
            StartLog.debug("Not yet able to expand property in: %s", name);
            return null;
        }
        Path file = this.baseHome.getPath("modules/" + expandedName + ".mod");
        if (FS.canReadFile(file)) {
            Module parent = this.registerModule(file);
            parent.expandProperties(this.args.getProperties());
            this.updateParentReferencesTo(parent);
            return parent;
        }
        if (!Props.hasPropertyKey(name)) {
            StartLog.debug("Missing module definition: [ Mod: %s | File: %s ]", name, file);
        }
        return null;
    }

    @Override
    public void onNodeSelected(Module module) {
        StartLog.debug("on node selected: [%s] (%s.mod)", module.getName(), module.getFilesystemRef());
        this.args.parseModule(module);
        module.expandProperties(this.args.getProperties());
    }

    public List<String> normalizeLibs(List<Module> active) {
        ArrayList<String> libs = new ArrayList<String>();
        for (Module module : active) {
            for (String lib : module.getLibs()) {
                if (libs.contains(lib)) continue;
                libs.add(lib);
            }
        }
        return libs;
    }

    public List<String> normalizeXmls(List<Module> active) {
        ArrayList<String> xmls = new ArrayList<String>();
        for (Module module : active) {
            for (String xml : module.getXmls()) {
                if (xmls.contains(xml)) continue;
                xmls.add(xml);
            }
        }
        return xmls;
    }

    public void registerAll() throws IOException {
        for (Path path : this.baseHome.getPaths("modules/*.mod")) {
            this.registerModule(path);
        }
    }

    private Module registerModule(Path file) {
        if (!FS.canReadFile(file)) {
            throw new GraphException("Cannot read file: " + file);
        }
        String shortName = this.baseHome.toShortForm(file);
        try {
            StartLog.debug("Registering Module: %s", shortName);
            Module module = new Module(this.baseHome, file);
            return this.register(module);
        }
        catch (Throwable t) {
            throw new GraphException("Unable to register module: " + shortName, t);
        }
    }

    private void updateParentReferencesTo(Module module) {
        if (module.getName().equals(module.getFilesystemRef())) {
            return;
        }
        for (Module m : this.getNodes()) {
            ArrayList<String> resolvedParents = new ArrayList<String>();
            for (String parent : m.getParentNames()) {
                if (parent.equals(module.getFilesystemRef())) {
                    resolvedParents.add(module.getName());
                    continue;
                }
                resolvedParents.add(parent);
            }
            m.setParentNames(resolvedParents);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Modules[");
        str.append("count=").append(this.count());
        str.append(",<");
        boolean delim = false;
        for (String name : this.getNodeNames()) {
            if (delim) {
                str.append(',');
            }
            str.append(name);
            delim = true;
        }
        str.append(">");
        str.append("]");
        return str.toString();
    }
}

