/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.config;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.NaturalSort;
import org.eclipse.jetty.start.PathMatchers;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.RawArgs;
import org.eclipse.jetty.start.StartIni;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.UsageException;
import org.eclipse.jetty.start.config.ConfigSource;

public class DirConfigSource
implements ConfigSource {
    private static final List<String> BANNED_ARGS = new ArrayList<String>();
    private final String id;
    private final Path dir;
    private final int weight;
    private final RawArgs args;
    private final Props props;

    public DirConfigSource(String id, Path dir, int weight, boolean canHaveArgs) throws IOException {
        this.id = id;
        this.dir = dir.toAbsolutePath();
        this.weight = weight;
        this.props = new Props();
        this.args = new RawArgs();
        if (canHaveArgs) {
            Path iniFile = dir.resolve("start.ini").normalize().toAbsolutePath();
            try {
                iniFile = iniFile.toRealPath(new LinkOption[0]);
                if (FS.canReadFile(iniFile)) {
                    StartIni ini = new StartIni(iniFile);
                    this.args.addAll(ini.getLines(), iniFile);
                    this.parseAllArgs(ini.getLines(), iniFile.toString());
                }
            }
            catch (NoSuchFileException ignore) {
                // empty catch block
            }
            Path startDdir = dir.resolve("start.d");
            if (FS.canReadDirectory(startDdir)) {
                DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){
                    PathMatcher iniMatcher = PathMatchers.getMatcher("glob:**/start.d/*.ini");

                    @Override
                    public boolean accept(Path entry) throws IOException {
                        return this.iniMatcher.matches(entry);
                    }
                };
                ArrayList<Path> paths = new ArrayList<Path>();
                for (Path diniFile : Files.newDirectoryStream(startDdir, (DirectoryStream.Filter<? super Path>)filter)) {
                    if (!FS.canReadFile(diniFile)) continue;
                    paths.add(diniFile);
                }
                Collections.sort(paths, new NaturalSort.Paths());
                for (Path diniFile : paths) {
                    StartLog.debug("Reading %s/start.d/%s - %s", id, diniFile.getFileName(), diniFile);
                    StartIni ini = new StartIni(diniFile);
                    this.args.addAll(ini.getLines(), diniFile);
                    this.parseAllArgs(ini.getLines(), diniFile.toString());
                }
            }
        }
    }

    private void parseAllArgs(List<String> lines, String origin) {
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line;
            String arg = line = iterator.next();
            int idx = line.indexOf(61);
            if (idx > 0) {
                arg = line.substring(0, idx);
            }
            if (BANNED_ARGS.contains(arg)) {
                throw new UsageException(-5, "%s not allowed in %s", arg, origin);
            }
            this.props.addPossibleProperty(line, origin);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirConfigSource other = (DirConfigSource)obj;
        return !(this.dir == null ? other.dir != null : !this.dir.equals(other.dir));
    }

    @Override
    public RawArgs getArgs() {
        return this.args;
    }

    public Path getDir() {
        return this.dir;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getProperty(String key) {
        Props.Prop prop = this.props.getProp(key, false);
        if (prop == null) {
            return null;
        }
        return prop.value;
    }

    @Override
    public Props getProps() {
        return this.props;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dir == null ? 0 : this.dir.hashCode());
        return result;
    }

    public boolean isPropertyBased() {
        return this.id.contains("${");
    }

    public String toString() {
        return String.format("%s[%s,%s,args.length=%d]", this.getClass().getSimpleName(), this.id, this.dir, this.getArgs().size());
    }

    static {
        BANNED_ARGS.add("--help");
        BANNED_ARGS.add("-?");
        BANNED_ARGS.add("--stop");
        BANNED_ARGS.add("--dry-run");
        BANNED_ARGS.add("--exec-print");
        BANNED_ARGS.add("--list-config");
        BANNED_ARGS.add("--list-classpath");
        BANNED_ARGS.add("--list-modules");
        BANNED_ARGS.add("--write-module-graph");
        BANNED_ARGS.add("--version");
        BANNED_ARGS.add("-v");
        BANNED_ARGS.add("--download");
        BANNED_ARGS.add("--create-files");
        BANNED_ARGS.add("--add-to-startd");
        BANNED_ARGS.add("--add-to-start");
    }
}

