/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.HttpConstraintElement;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.ClasspathPattern;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.WebAppClassLoader;

@ManagedObject(value="Web Application ContextHandler")
public class WebAppContext
extends ServletContextHandler
implements WebAppClassLoader.Context {
    private static final Logger LOG = Log.getLogger(WebAppContext.class);
    public static final String TEMPDIR = "javax.servlet.context.tempdir";
    public static final String BASETEMPDIR = "org.eclipse.jetty.webapp.basetempdir";
    public static final String WEB_DEFAULTS_XML = "org/eclipse/jetty/webapp/webdefault.xml";
    public static final String ERROR_PAGE = "org.eclipse.jetty.server.error_page";
    public static final String SERVER_SYS_CLASSES = "org.eclipse.jetty.webapp.systemClasses";
    public static final String SERVER_SRV_CLASSES = "org.eclipse.jetty.webapp.serverClasses";
    private String[] __dftProtectedTargets = new String[]{"/web-inf", "/meta-inf"};
    public static final String[] DEFAULT_CONFIGURATION_CLASSES = new String[]{"org.eclipse.jetty.webapp.WebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.MetaInfConfiguration", "org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration"};
    public static final String[] __dftSystemClasses = new String[]{"java.", "javax.", "org.xml.", "org.w3c.", "org.eclipse.jetty.continuation.", "org.eclipse.jetty.jndi.", "org.eclipse.jetty.jaas.", "org.eclipse.jetty.websocket.", "org.eclipse.jetty.servlet.DefaultServlet"};
    public static final String[] __dftServerClasses = new String[]{"-org.eclipse.jetty.continuation.", "-org.eclipse.jetty.jndi.", "-org.eclipse.jetty.jaas.", "-org.eclipse.jetty.servlets.", "-org.eclipse.jetty.servlet.DefaultServlet", "-org.eclipse.jetty.servlet.listener.", "-org.eclipse.jetty.websocket.", "org.eclipse.jetty."};
    private final List<String> _configurationClasses = new ArrayList<String>();
    private ClasspathPattern _systemClasses = null;
    private ClasspathPattern _serverClasses = null;
    private final List<Configuration> _configurations = new ArrayList<Configuration>();
    private String _defaultsDescriptor = "org/eclipse/jetty/webapp/webdefault.xml";
    private String _descriptor = null;
    private final List<String> _overrideDescriptors = new ArrayList<String>();
    private boolean _distributable = false;
    private boolean _extractWAR = true;
    private boolean _copyDir = false;
    private boolean _copyWebInf = false;
    private boolean _logUrlOnStart = false;
    private boolean _parentLoaderPriority = Boolean.getBoolean("org.eclipse.jetty.server.webapp.parentLoaderPriority");
    private PermissionCollection _permissions;
    private String[] _contextWhiteList = null;
    private File _tmpDir;
    private String _war;
    private String _extraClasspath;
    private Throwable _unavailableException;
    private Map<String, String> _resourceAliases;
    private boolean _ownClassLoader = false;
    private boolean _configurationDiscovered = true;
    private boolean _allowDuplicateFragmentNames = false;
    private boolean _throwUnavailableOnStartupException = false;
    private MetaData _metadata = new MetaData();

    public static WebAppContext getCurrentWebAppContext() {
        ContextHandler handler;
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context != null && (handler = context.getContextHandler()) instanceof WebAppContext) {
            return (WebAppContext)handler;
        }
        return null;
    }

    public WebAppContext() {
        this(null, null, null, null, null, (ErrorHandler)new ErrorPageErrorHandler(), 3);
    }

    public WebAppContext(String webApp, String contextPath) {
        this(null, contextPath, null, null, null, (ErrorHandler)new ErrorPageErrorHandler(), 3);
        this.setWar(webApp);
    }

    public WebAppContext(HandlerContainer parent, String webApp, String contextPath) {
        this(parent, contextPath, null, null, null, (ErrorHandler)new ErrorPageErrorHandler(), 3);
        this.setWar(webApp);
    }

    public WebAppContext(SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this(null, null, sessionHandler, securityHandler, servletHandler, errorHandler, 0);
    }

    public WebAppContext(HandlerContainer parent, String contextPath, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler, int options) {
        super(parent, contextPath, sessionHandler, securityHandler, servletHandler, errorHandler, options);
        this._scontext = new Context();
        this.setErrorHandler((ErrorHandler)(errorHandler != null ? errorHandler : new ErrorPageErrorHandler()));
        this.setProtectedTargets(this.__dftProtectedTargets);
    }

    public void setDisplayName(String servletContextName) {
        super.setDisplayName(servletContextName);
        ClassLoader cl = this.getClassLoader();
        if (cl != null && cl instanceof WebAppClassLoader && servletContextName != null) {
            ((WebAppClassLoader)cl).setName(servletContextName);
        }
    }

    public Throwable getUnavailableException() {
        return this._unavailableException;
    }

    public void setResourceAlias(String alias, String uri) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap<String, String>(5);
        }
        this._resourceAliases.put(alias, uri);
    }

    public Map<String, String> getResourceAliases() {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases;
    }

    public void setResourceAliases(Map<String, String> map) {
        this._resourceAliases = map;
    }

    public String getResourceAlias(String path) {
        if (this._resourceAliases == null) {
            return null;
        }
        String alias = this._resourceAliases.get(path);
        int slash = path.length();
        while (alias == null && (slash = path.lastIndexOf("/", slash - 1)) >= 0) {
            String match = this._resourceAliases.get(path.substring(0, slash + 1));
            if (match == null) continue;
            alias = match + path.substring(slash + 1);
        }
        return alias;
    }

    public String removeResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases.remove(alias);
    }

    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        if (classLoader != null && classLoader instanceof WebAppClassLoader && this.getDisplayName() != null) {
            ((WebAppClassLoader)classLoader).setName(this.getDisplayName());
        }
    }

    public Resource getResource(String uriInContext) throws MalformedURLException {
        if (uriInContext == null || !uriInContext.startsWith("/")) {
            throw new MalformedURLException(uriInContext);
        }
        IOException ioe = null;
        Resource resource = null;
        int loop = 0;
        while (uriInContext != null && loop++ < 100) {
            try {
                resource = super.getResource(uriInContext);
                if (resource != null && resource.exists()) {
                    return resource;
                }
                uriInContext = this.getResourceAlias(uriInContext);
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null && ioe instanceof MalformedURLException) {
            throw (MalformedURLException)ioe;
        }
        return resource;
    }

    public boolean isConfigurationDiscovered() {
        return this._configurationDiscovered;
    }

    public void setConfigurationDiscovered(boolean discovered) {
        this._configurationDiscovered = discovered;
    }

    public void preConfigure() throws Exception {
        this.loadConfigurations();
        this.loadSystemClasses();
        this.loadServerClasses();
        this._ownClassLoader = false;
        if (this.getClassLoader() == null) {
            WebAppClassLoader classLoader = new WebAppClassLoader(this);
            this.setClassLoader(classLoader);
            this._ownClassLoader = true;
        }
        if (LOG.isDebugEnabled()) {
            ClassLoader loader = this.getClassLoader();
            LOG.debug("Thread Context classloader {}", new Object[]{loader});
            for (loader = loader.getParent(); loader != null; loader = loader.getParent()) {
                LOG.debug("Parent class loader: {} ", new Object[]{loader});
            }
        }
        for (Configuration configuration : this._configurations) {
            LOG.debug("preConfigure {} with {}", new Object[]{this, configuration});
            configuration.preConfigure(this);
        }
    }

    public void configure() throws Exception {
        for (Configuration configuration : this._configurations) {
            LOG.debug("configure {} with {}", new Object[]{this, configuration});
            configuration.configure(this);
        }
    }

    public void postConfigure() throws Exception {
        for (Configuration configuration : this._configurations) {
            LOG.debug("postConfigure {} with {}", new Object[]{this, configuration});
            configuration.postConfigure(this);
        }
    }

    protected void doStart() throws Exception {
        block3: {
            try {
                this._metadata.setAllowDuplicateFragmentNames(this.isAllowDuplicateFragmentNames());
                this.preConfigure();
                super.doStart();
                this.postConfigure();
                if (this.isLogUrlOnStart()) {
                    this.dumpUrl();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed startup of context " + this, (Throwable)e);
                this._unavailableException = e;
                this.setAvailable(false);
                if (!this.isThrowUnavailableOnStartupException()) break block3;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        try {
            int i = this._configurations.size();
            while (i-- > 0) {
                this._configurations.get(i).deconfigure(this);
            }
            if (this._metadata != null) {
                this._metadata.clear();
            }
            this._metadata = new MetaData();
        }
        finally {
            if (this._ownClassLoader) {
                this.setClassLoader(null);
            }
            this.setAvailable(true);
            this._unavailableException = null;
        }
    }

    public void destroy() {
        MultiException mx = new MultiException();
        if (this._configurations != null) {
            int i = this._configurations.size();
            while (i-- > 0) {
                try {
                    this._configurations.get(i).destroy(this);
                }
                catch (Exception e) {
                    mx.add((Throwable)e);
                }
            }
        }
        this._configurations.clear();
        super.destroy();
        mx.ifExceptionThrowRuntime();
    }

    private void dumpUrl() {
        Connector[] connectors = this.getServer().getConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            String displayName = this.getDisplayName();
            if (displayName == null) {
                displayName = "WebApp@" + connectors.hashCode();
            }
            LOG.info(displayName + " at http://" + connectors[i].toString() + this.getContextPath(), new Object[0]);
        }
    }

    @ManagedAttribute(value="configuration classes used to configure webapp", readonly=true)
    public String[] getConfigurationClasses() {
        return this._configurationClasses.toArray(new String[this._configurationClasses.size()]);
    }

    public Configuration[] getConfigurations() {
        return this._configurations.toArray(new Configuration[this._configurations.size()]);
    }

    @ManagedAttribute(value="default web.xml deascriptor applied before standard web.xml", readonly=true)
    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public String getOverrideDescriptor() {
        if (this._overrideDescriptors.size() != 1) {
            return null;
        }
        return this._overrideDescriptors.get(0);
    }

    @ManagedAttribute(value="web.xml deascriptors applied after standard web.xml", readonly=true)
    public List<String> getOverrideDescriptors() {
        return Collections.unmodifiableList(this._overrideDescriptors);
    }

    @Override
    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    @ManagedAttribute(value="classes and packages hidden by the context classloader", readonly=true)
    public String[] getServerClasses() {
        if (this._serverClasses == null) {
            this.loadServerClasses();
        }
        return this._serverClasses.getPatterns();
    }

    public void addServerClass(String classOrPackage) {
        if (this._serverClasses == null) {
            this.loadServerClasses();
        }
        this._serverClasses.addPattern(classOrPackage);
    }

    public void prependServerClass(String classOrPackage) {
        if (this._serverClasses == null) {
            this.loadServerClasses();
        }
        this._serverClasses.prependPattern(classOrPackage);
    }

    @ManagedAttribute(value="classes and packages given priority by context classloader", readonly=true)
    public String[] getSystemClasses() {
        if (this._systemClasses == null) {
            this.loadSystemClasses();
        }
        return this._systemClasses.getPatterns();
    }

    public void addSystemClass(String classOrPackage) {
        if (this._systemClasses == null) {
            this.loadSystemClasses();
        }
        this._systemClasses.addPattern(classOrPackage);
    }

    public void prependSystemClass(String classOrPackage) {
        if (this._systemClasses == null) {
            this.loadSystemClasses();
        }
        this._systemClasses.prependPattern(classOrPackage);
    }

    @Override
    public boolean isServerClass(String name) {
        if (this._serverClasses == null) {
            this.loadServerClasses();
        }
        return this._serverClasses.match(name);
    }

    @Override
    public boolean isSystemClass(String name) {
        if (this._systemClasses == null) {
            this.loadSystemClasses();
        }
        return this._systemClasses.match(name);
    }

    protected void loadSystemClasses() {
        Object systemClasses;
        if (this._systemClasses != null) {
            return;
        }
        Server server = this.getServer();
        if (server != null && (systemClasses = server.getAttribute(SERVER_SYS_CLASSES)) != null && systemClasses instanceof String[]) {
            this._systemClasses = new ClasspathPattern((String[])systemClasses);
        }
        if (this._systemClasses == null) {
            this._systemClasses = new ClasspathPattern(__dftSystemClasses);
        }
    }

    private void loadServerClasses() {
        Object serverClasses;
        if (this._serverClasses != null) {
            return;
        }
        Server server = this.getServer();
        if (server != null && (serverClasses = server.getAttribute(SERVER_SRV_CLASSES)) != null && serverClasses instanceof String[]) {
            this._serverClasses = new ClasspathPattern((String[])serverClasses);
        }
        if (this._serverClasses == null) {
            this._serverClasses = new ClasspathPattern(__dftServerClasses);
        }
    }

    @ManagedAttribute(value="war file location", readonly=true)
    public String getWar() {
        if (this._war == null) {
            this._war = this.getResourceBase();
        }
        return this._war;
    }

    public Resource getWebInf() throws IOException {
        if (super.getBaseResource() == null) {
            return null;
        }
        Resource web_inf = super.getBaseResource().addPath("WEB-INF/");
        if (!web_inf.exists() || !web_inf.isDirectory()) {
            return null;
        }
        return web_inf;
    }

    @ManagedAttribute(value="web application distributable")
    public boolean isDistributable() {
        return this._distributable;
    }

    @ManagedAttribute(value="extract war", readonly=true)
    public boolean isExtractWAR() {
        return this._extractWAR;
    }

    @ManagedAttribute(value="webdir copied on deploy (allows hot replacement on windows)", readonly=true)
    public boolean isCopyWebDir() {
        return this._copyDir;
    }

    public boolean isCopyWebInf() {
        return this._copyWebInf;
    }

    @Override
    @ManagedAttribute(value="parent classloader given priority", readonly=true)
    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public static String[] getDefaultConfigurationClasses() {
        return DEFAULT_CONFIGURATION_CLASSES;
    }

    public String[] getDefaultServerClasses() {
        return __dftServerClasses;
    }

    public String[] getDefaultSystemClasses() {
        return __dftSystemClasses;
    }

    protected void loadConfigurations() throws Exception {
        if (this._configurations.size() > 0) {
            return;
        }
        if (this._configurationClasses.size() == 0) {
            this._configurationClasses.addAll(Configuration.ClassList.serverDefault(this.getServer()));
        }
        for (String configClass : this._configurationClasses) {
            this._configurations.add((Configuration)Loader.loadClass(this.getClass(), (String)configClass).newInstance());
        }
    }

    public String toString() {
        if (this._war != null) {
            String war = this._war;
            if (war.indexOf("/webapps/") >= 0) {
                war = war.substring(war.indexOf("/webapps/") + 8);
            }
            return super.toString() + "{" + war + "}";
        }
        return super.toString();
    }

    public void setConfigurationClasses(String[] configurations) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._configurationClasses.clear();
        if (configurations != null) {
            this._configurationClasses.addAll(Arrays.asList(configurations));
        }
        this._configurations.clear();
    }

    public void setConfigurationClasses(List<String> configurations) {
        this.setConfigurationClasses(configurations.toArray(new String[configurations.size()]));
    }

    public void setConfigurations(Configuration[] configurations) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._configurations.clear();
        if (configurations != null) {
            this._configurations.addAll(Arrays.asList(configurations));
        }
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public void setOverrideDescriptor(String overrideDescriptor) {
        this._overrideDescriptors.clear();
        this._overrideDescriptors.add(overrideDescriptor);
    }

    public void setOverrideDescriptors(List<String> overrideDescriptors) {
        this._overrideDescriptors.clear();
        this._overrideDescriptors.addAll(overrideDescriptors);
    }

    public void addOverrideDescriptor(String overrideDescriptor) {
        this._overrideDescriptors.add(overrideDescriptor);
    }

    @ManagedAttribute(value="standard web.xml descriptor", readonly=true)
    public String getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(String descriptor) {
        this._descriptor = descriptor;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public void setEventListeners(EventListener[] eventListeners) {
        if (this._sessionHandler != null) {
            this._sessionHandler.clearEventListeners();
        }
        super.setEventListeners(eventListeners);
    }

    public void addEventListener(EventListener listener) {
        super.addEventListener(listener);
        if ((listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener) && this._sessionHandler != null) {
            this._sessionHandler.addEventListener(listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        super.removeEventListener(listener);
        if ((listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener) && this._sessionHandler != null) {
            this._sessionHandler.removeEventListener(listener);
        }
    }

    public void setExtractWAR(boolean extractWAR) {
        this._extractWAR = extractWAR;
    }

    public void setCopyWebDir(boolean copy) {
        this._copyDir = copy;
    }

    public void setCopyWebInf(boolean copyWebInf) {
        this._copyWebInf = copyWebInf;
    }

    public void setParentLoaderPriority(boolean java2compliant) {
        this._parentLoaderPriority = java2compliant;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public void setContextWhiteList(String[] contextWhiteList) {
        this._contextWhiteList = contextWhiteList;
    }

    public void setServerClasses(String[] serverClasses) {
        this._serverClasses = new ClasspathPattern(serverClasses);
    }

    public void setSystemClasses(String[] systemClasses) {
        this._systemClasses = new ClasspathPattern(systemClasses);
    }

    public void setTempDirectory(File dir) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (dir != null) {
            try {
                dir = new File(dir.getCanonicalPath());
            }
            catch (IOException e) {
                LOG.warn("EXCEPTION ", (Throwable)e);
            }
        }
        if (dir != null && !dir.exists()) {
            dir.mkdir();
            dir.deleteOnExit();
        }
        if (!(dir == null || dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IllegalArgumentException("Bad temp directory: " + dir);
        }
        try {
            if (dir != null) {
                dir = dir.getCanonicalFile();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        this._tmpDir = dir;
        this.setAttribute(TEMPDIR, this._tmpDir);
    }

    @ManagedAttribute(value="temporary directory location", readonly=true)
    public File getTempDirectory() {
        return this._tmpDir;
    }

    public void setWar(String war) {
        this._war = war;
    }

    @Override
    @ManagedAttribute(value="extra classpath for context classloader", readonly=true)
    public String getExtraClasspath() {
        return this._extraClasspath;
    }

    public void setExtraClasspath(String extraClasspath) {
        this._extraClasspath = extraClasspath;
    }

    public boolean isLogUrlOnStart() {
        return this._logUrlOnStart;
    }

    public void setLogUrlOnStart(boolean logOnStart) {
        this._logUrlOnStart = logOnStart;
    }

    public void setServer(Server server) {
        super.setServer(server);
    }

    public boolean isAllowDuplicateFragmentNames() {
        return this._allowDuplicateFragmentNames;
    }

    public void setAllowDuplicateFragmentNames(boolean allowDuplicateFragmentNames) {
        this._allowDuplicateFragmentNames = allowDuplicateFragmentNames;
    }

    public void setThrowUnavailableOnStartupException(boolean throwIfStartupException) {
        this._throwUnavailableOnStartupException = throwIfStartupException;
    }

    public boolean isThrowUnavailableOnStartupException() {
        return this._throwUnavailableOnStartupException;
    }

    protected void startContext() throws Exception {
        this.configure();
        this._metadata.resolve(this);
        super.startContext();
    }

    public Set<String> setServletSecurity(ServletRegistration.Dynamic registration, ServletSecurityElement servletSecurityElement) {
        HashSet<String> unchangedURLMappings = new HashSet<String>();
        Collection pathMappings = registration.getMappings();
        if (pathMappings != null) {
            ConstraintSecurityHandler.createConstraint((String)registration.getName(), (HttpConstraintElement)servletSecurityElement);
            for (String pathSpec : pathMappings) {
                Origin origin = this.getMetaData().getOrigin("constraint.url." + pathSpec);
                switch (origin) {
                    case NotSet: {
                        List mappings = ConstraintSecurityHandler.createConstraintsWithMappingsForPath((String)registration.getName(), (String)pathSpec, (ServletSecurityElement)servletSecurityElement);
                        for (ConstraintMapping m : mappings) {
                            ((ConstraintAware)this.getSecurityHandler()).addConstraintMapping(m);
                        }
                        this.getMetaData().setOrigin("constraint.url." + pathSpec, Origin.API);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: 
                    case WebFragment: {
                        unchangedURLMappings.add(pathSpec);
                        break;
                    }
                    case Annotation: 
                    case API: {
                        List constraintMappings = ConstraintSecurityHandler.removeConstraintMappingsForPath((String)pathSpec, (List)((ConstraintAware)this.getSecurityHandler()).getConstraintMappings());
                        List freshMappings = ConstraintSecurityHandler.createConstraintsWithMappingsForPath((String)registration.getName(), (String)pathSpec, (ServletSecurityElement)servletSecurityElement);
                        constraintMappings.addAll(freshMappings);
                        ((ConstraintSecurityHandler)this.getSecurityHandler()).setConstraintMappings(constraintMappings);
                        break;
                    }
                }
            }
        }
        return unchangedURLMappings;
    }

    public MetaData getMetaData() {
        return this._metadata;
    }

    public class Context
    extends ServletContextHandler.Context {
        public Context() {
            super((ServletContextHandler)WebAppContext.this);
        }

        public URL getResource(String path) throws MalformedURLException {
            Resource resource = WebAppContext.this.getResource(path);
            if (resource == null || !resource.exists()) {
                return null;
            }
            if (resource.isDirectory() && resource instanceof ResourceCollection && !WebAppContext.this.isExtractWAR()) {
                Resource[] resources = ((ResourceCollection)resource).getResources();
                int i = resources.length;
                while (i-- > 0) {
                    if (!resources[i].getName().startsWith("jar:file")) continue;
                    return resources[i].getURL();
                }
            }
            return resource.getURL();
        }

        public ServletContext getContext(String uripath) {
            ServletContext servletContext = super.getContext(uripath);
            if (servletContext != null && WebAppContext.this._contextWhiteList != null) {
                for (String context : WebAppContext.this._contextWhiteList) {
                    if (!context.equals(uripath)) continue;
                    return servletContext;
                }
                return null;
            }
            return servletContext;
        }
    }
}

