/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.build;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.packager.rpm.build.DigestAlgorithm;
import org.eclipse.packager.rpm.build.LongMode;
import org.eclipse.packager.rpm.build.PayloadProcessor;
import org.eclipse.packager.rpm.build.PayloadProcessors;
import org.eclipse.packager.rpm.build.RpmFileNameProvider;
import org.eclipse.packager.rpm.coding.PayloadCoding;

public class BuilderOptions {
    private LongMode longMode = LongMode.DEFAULT;
    private OpenOption[] openOptions;
    private RpmFileNameProvider fileNameProvider = RpmFileNameProvider.LEGACY_FILENAME_PROVIDER;
    private PayloadCoding payloadCoding;
    private String payloadFlags;
    private DigestAlgorithm fileDigestAlgorithm = DigestAlgorithm.MD5;
    private Charset headerCharset = StandardCharsets.UTF_8;
    private List<PayloadProcessor> payloadProcessors = new LinkedList<PayloadProcessor>();

    public BuilderOptions() {
        try {
            this.payloadProcessors.add(PayloadProcessors.payloadDigest(DigestAlgorithm.SHA256));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BuilderOptions(BuilderOptions other) {
        this.setLongMode(other.longMode);
        this.setOpenOptions(other.openOptions);
        this.setFileNameProvider(other.fileNameProvider);
        this.setPayloadCoding(other.payloadCoding);
        this.setPayloadFlags(other.payloadFlags);
        this.setFileDigestAlgorithm(other.fileDigestAlgorithm);
        this.setHeaderCharset(other.headerCharset);
        this.setPayloadProcessors(other.payloadProcessors);
    }

    public LongMode getLongMode() {
        return this.longMode;
    }

    public void setLongMode(LongMode longMode) {
        this.longMode = longMode == null ? LongMode.DEFAULT : longMode;
    }

    public OpenOption[] getOpenOptions() {
        return this.openOptions;
    }

    public void setOpenOptions(OpenOption[] openOptions) {
        this.openOptions = openOptions == null ? new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING} : Arrays.copyOf(openOptions, openOptions.length);
    }

    public RpmFileNameProvider getFileNameProvider() {
        return this.fileNameProvider;
    }

    public void setFileNameProvider(RpmFileNameProvider fileNameProvider) {
        this.fileNameProvider = fileNameProvider != null ? fileNameProvider : RpmFileNameProvider.LEGACY_FILENAME_PROVIDER;
    }

    public PayloadCoding getPayloadCoding() {
        return this.payloadCoding != null ? this.payloadCoding : PayloadCoding.GZIP;
    }

    public void setPayloadCoding(PayloadCoding payloadCoding) {
        this.payloadCoding = payloadCoding;
    }

    public String getPayloadFlags() {
        return this.payloadFlags;
    }

    public void setPayloadFlags(String payloadFlags) {
        this.payloadFlags = payloadFlags;
    }

    public DigestAlgorithm getFileDigestAlgorithm() {
        return this.fileDigestAlgorithm;
    }

    public void setFileDigestAlgorithm(DigestAlgorithm fileDigestAlgorithm) {
        this.fileDigestAlgorithm = fileDigestAlgorithm == null ? DigestAlgorithm.MD5 : fileDigestAlgorithm;
    }

    public Charset getHeaderCharset() {
        return this.headerCharset;
    }

    public void setHeaderCharset(Charset headerCharset) {
        this.headerCharset = headerCharset == null ? StandardCharsets.UTF_8 : headerCharset;
    }

    public List<PayloadProcessor> getPayloadProcessors() {
        return Collections.unmodifiableList(this.payloadProcessors);
    }

    public void setPayloadProcessors(List<PayloadProcessor> payloadProcessors) {
        this.payloadProcessors = new ArrayList<PayloadProcessor>(payloadProcessors);
    }

    public void addPayloadProcessor(PayloadProcessor processor) {
        this.payloadProcessors.add(processor);
    }

    public void clearPayloadProcessors() {
        this.payloadProcessors.clear();
    }
}

