/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.coding;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.packager.rpm.coding.BZip2PayloadCoding;
import org.eclipse.packager.rpm.coding.GzipPayloadCoding;
import org.eclipse.packager.rpm.coding.LZMAPayloadCoding;
import org.eclipse.packager.rpm.coding.NullPayloadCoding;
import org.eclipse.packager.rpm.coding.PayloadCodingProvider;
import org.eclipse.packager.rpm.coding.XZPayloadCoding;
import org.eclipse.packager.rpm.coding.ZstdPayloadCoding;

public enum PayloadCoding {
    NONE("none", NullPayloadCoding::new),
    GZIP("gzip", GzipPayloadCoding::new),
    LZMA("lzma", LZMAPayloadCoding::new),
    BZIP2("bzip2", BZip2PayloadCoding::new),
    ZSTD("zstd", ZstdPayloadCoding::new),
    XZ("xz", XZPayloadCoding::new);

    private final String value;
    private final Supplier<PayloadCodingProvider> newInstanceSupplier;

    private PayloadCoding(String value, Supplier<PayloadCodingProvider> newInstanceSupplier) {
        this.value = value;
        this.newInstanceSupplier = newInstanceSupplier;
    }

    public String getValue() {
        return this.value;
    }

    public PayloadCodingProvider createProvider() {
        return this.newInstanceSupplier.get();
    }

    public static Optional<PayloadCoding> fromValue(String payloadCoding) {
        if (payloadCoding == null) {
            return Optional.of(GZIP);
        }
        for (PayloadCoding coding : PayloadCoding.values()) {
            if (!coding.value.equals(payloadCoding)) continue;
            return Optional.of(coding);
        }
        return Optional.empty();
    }
}

