/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.common.P6LogQuery;
import com.p6spy.engine.spy.P6Core;
import com.p6spy.engine.spy.P6DataSourceFactory;
import com.p6spy.engine.spy.P6SpyLoadableOptions;
import com.p6spy.engine.spy.P6SpyOptions;
import com.p6spy.engine.spy.P6XAConnection;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class P6DataSource
implements DataSource,
ConnectionPoolDataSource,
XADataSource,
Referenceable,
Serializable {
    protected CommonDataSource realDataSource;
    protected String rdsName;

    public P6DataSource() {
    }

    public P6DataSource(DataSource delegate) {
        this.realDataSource = delegate;
    }

    public String getRealDataSource() {
        return this.rdsName;
    }

    public void setRealDataSource(String jndiName) {
        this.rdsName = jndiName;
    }

    protected synchronized void bindDataSource() throws SQLException {
        if (null != this.realDataSource) {
            return;
        }
        P6SpyLoadableOptions options = P6SpyOptions.getActiveInstance();
        if (this.rdsName == null) {
            this.rdsName = options.getRealDataSource();
        }
        if (this.rdsName == null) {
            throw new SQLException("P6DataSource: no value for Real Data Source Name, cannot perform jndi lookup");
        }
        Hashtable<String, String> env = null;
        String factory = options.getJNDIContextFactory();
        if (factory != null) {
            String custom;
            env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", factory);
            String url = options.getJNDIContextProviderURL();
            if (url != null) {
                env.put("java.naming.provider.url", url);
            }
            if ((custom = options.getJNDIContextCustom()) != null) {
                env.putAll(this.parseDelimitedString(custom));
            }
        }
        try {
            InitialContext ctx = env != null ? new InitialContext(env) : new InitialContext();
            this.realDataSource = (CommonDataSource)ctx.lookup(this.rdsName);
        }
        catch (NamingException e) {
            throw new SQLException("P6DataSource: naming exception during jndi lookup of Real Data Source Name of '" + this.rdsName + "'. " + e.getMessage(), e);
        }
        HashMap<String, String> props = this.parseDelimitedString(options.getRealDataSourceProperties());
        if (props != null) {
            this.setDataSourceProperties(props);
        }
        if (this.realDataSource == null) {
            throw new SQLException("P6DataSource: jndi lookup for Real Data Source Name of '" + this.rdsName + "' failed, cannot bind named data source.");
        }
    }

    private void setDataSourceProperties(HashMap<String, String> props) throws SQLException {
        HashMap<String, String> matchedProps = new HashMap<String, String>();
        Class<?> klass = this.realDataSource.getClass();
        for (Method method : klass.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("set")) continue;
            String propertyName = methodName.substring(3).toLowerCase();
            for (String key : props.keySet()) {
                if (!key.toLowerCase().equals(propertyName)) continue;
                try {
                    Object[] args;
                    String value = props.get(key);
                    Class<?>[] types = method.getParameterTypes();
                    if (types[0].getName().equals(value.getClass().getName())) {
                        args = new String[]{value};
                        P6LogQuery.debug("calling " + methodName + " on DataSource " + this.rdsName + " with " + value);
                        method.invoke((Object)this.realDataSource, args);
                        matchedProps.put(key, value);
                        continue;
                    }
                    if (types[0].isPrimitive() && "int".equals(types[0].getName())) {
                        args = new Integer[]{Integer.valueOf(value)};
                        P6LogQuery.debug("calling " + methodName + " on DataSource " + this.rdsName + " with " + value);
                        method.invoke((Object)this.realDataSource, args);
                        matchedProps.put(key, value);
                        continue;
                    }
                    P6LogQuery.debug("method " + methodName + " on DataSource " + this.rdsName + " matches property " + propertyName + " but expects unsupported type " + types[0].getName());
                    matchedProps.put(key, value);
                }
                catch (IllegalAccessException e) {
                    throw new SQLException("spy.properties file includes datasource property " + key + " for datasource " + this.rdsName + " but access is denied to method " + methodName, e);
                }
                catch (InvocationTargetException e) {
                    throw new SQLException("spy.properties file includes datasource property " + key + " for datasource " + this.rdsName + " but call method " + methodName + " fails", e);
                }
            }
        }
        for (String key : props.keySet()) {
            if (matchedProps.containsKey(key)) continue;
            P6LogQuery.debug("spy.properties file includes datasource property " + key + " for datasource " + this.rdsName + " but class " + klass.getName() + " has no method" + " by that name");
        }
    }

    private HashMap<String, String> parseDelimitedString(String delimitedString) {
        if (delimitedString == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(delimitedString, ",", false);
        while (st.hasMoreElements()) {
            String pair = st.nextToken();
            StringTokenizer pst = new StringTokenizer(pair, ";", false);
            if (!pst.hasMoreElements()) continue;
            String name = pst.nextToken();
            if (!pst.hasMoreElements()) continue;
            String value = pst.nextToken();
            result.put(name, value);
        }
        return result;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), P6DataSourceFactory.class.getName(), null);
        reference.add(new StringRefAddr("dataSourceName", this.getRealDataSource()));
        return reference;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        if (this.realDataSource == null) {
            this.bindDataSource();
        }
        return this.realDataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int inVar) throws SQLException {
        if (this.realDataSource == null) {
            this.bindDataSource();
        }
        this.realDataSource.setLoginTimeout(inVar);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        if (this.realDataSource == null) {
            this.bindDataSource();
        }
        return this.realDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter inVar) throws SQLException {
        this.realDataSource.setLogWriter(inVar);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.realDataSource == null) {
            this.bindDataSource();
        }
        long start = System.nanoTime();
        Connection connection = ((DataSource)this.realDataSource).getConnection();
        return P6Core.wrapConnection(connection, ConnectionInformation.fromDataSource(this.realDataSource, connection, System.nanoTime() - start));
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.realDataSource == null) {
            this.bindDataSource();
        }
        long start = System.nanoTime();
        Connection connection = ((DataSource)this.realDataSource).getConnection(username, password);
        return P6Core.wrapConnection(connection, ConnectionInformation.fromDataSource(this.realDataSource, connection, System.nanoTime() - start));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return ((Wrapper)((Object)this.realDataSource)).isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return ((DataSource)this.realDataSource).unwrap(iface);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.realDataSource.getParentLogger();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return new P6XAConnection(this.castRealDS(ConnectionPoolDataSource.class).getPooledConnection());
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new P6XAConnection(this.castRealDS(ConnectionPoolDataSource.class).getPooledConnection(user, password));
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return new P6XAConnection(this.castRealDS(XADataSource.class).getXAConnection());
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return new P6XAConnection(this.castRealDS(XADataSource.class).getXAConnection(user, password));
    }

    <T> T castRealDS(Class<T> iface) throws SQLException {
        if (this.realDataSource == null) {
            this.bindDataSource();
        }
        if (iface.isInstance(this.realDataSource)) {
            return (T)this.realDataSource;
        }
        if (this.isWrapperFor(iface)) {
            return this.unwrap(iface);
        }
        throw new IllegalStateException("realdatasource type not supported: " + this.realDataSource);
    }
}

