/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.internal.routing;

import java.lang.annotation.Annotation;
import shaded.javax.ws.rs.core.Configuration;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.jersey.message.MessageBodyWorkers;
import shaded.org.glassfish.jersey.process.internal.ChainableStage;
import shaded.org.glassfish.jersey.process.internal.Stage;
import shaded.org.glassfish.jersey.server.internal.JerseyResourceContext;
import shaded.org.glassfish.jersey.server.internal.ProcessingProviders;
import shaded.org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import shaded.org.glassfish.jersey.server.internal.routing.MatchedEndpointExtractorStage;
import shaded.org.glassfish.jersey.server.internal.routing.RoutingStage;
import shaded.org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import shaded.org.glassfish.jersey.server.model.ResourceMethodInvoker;
import shaded.org.glassfish.jersey.server.model.RuntimeResourceModel;

public final class Routing {
    private Routing() {
        throw new AssertionError((Object)"No instances allowed.");
    }

    public static Stage<RequestProcessingContext> matchedEndpointExtractor() {
        return new MatchedEndpointExtractorStage();
    }

    public static Builder forModel(RuntimeResourceModel resourceModel) {
        return new Builder(resourceModel);
    }

    public static final class Builder {
        private final RuntimeResourceModel resourceModel;
        private ServiceLocator locator;
        private JerseyResourceContext resourceContext;
        private Configuration config;
        private MessageBodyWorkers entityProviders;
        private ProcessingProviders processingProviders;

        private Builder(RuntimeResourceModel resourceModel) {
            if (resourceModel == null) {
                throw new NullPointerException("Resource model must not be null.");
            }
            this.resourceModel = resourceModel;
        }

        public Builder locator(ServiceLocator locator) {
            this.locator = locator;
            return this;
        }

        public Builder resourceContext(JerseyResourceContext resourceContext) {
            this.resourceContext = resourceContext;
            return this;
        }

        public Builder configuration(Configuration config) {
            this.config = config;
            return this;
        }

        public Builder entityProviders(MessageBodyWorkers workers) {
            this.entityProviders = workers;
            return this;
        }

        public Builder processingProviders(ProcessingProviders processingProviders) {
            this.processingProviders = processingProviders;
            return this;
        }

        public ChainableStage<RequestProcessingContext> buildStage() {
            if (this.locator == null) {
                throw new NullPointerException("HK2 locator is not set.");
            }
            if (this.resourceContext == null) {
                throw new NullPointerException("Resource context is not set.");
            }
            if (this.config == null) {
                throw new NullPointerException("Runtime configuration is not set.");
            }
            if (this.entityProviders == null) {
                throw new NullPointerException("Entity providers are not set.");
            }
            if (this.processingProviders == null) {
                throw new NullPointerException("Processing providers are not set.");
            }
            RuntimeModelBuilder runtimeModelBuilder = new RuntimeModelBuilder(this.locator, this.resourceContext, this.config, this.entityProviders, this.processingProviders, this.locator.getService(ResourceMethodInvoker.Builder.class, new Annotation[0]));
            return new RoutingStage(runtimeModelBuilder.buildModel(this.resourceModel, false));
        }
    }
}

