/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.glassfish.jersey.server.internal.routing;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import shaded.javax.ws.rs.ProcessingException;
import shaded.javax.ws.rs.core.Configuration;
import shaded.jersey.repackaged.com.google.common.cache.CacheBuilder;
import shaded.jersey.repackaged.com.google.common.cache.CacheLoader;
import shaded.jersey.repackaged.com.google.common.cache.LoadingCache;
import shaded.org.glassfish.hk2.api.ServiceLocator;
import shaded.org.glassfish.jersey.internal.Errors;
import shaded.org.glassfish.jersey.internal.inject.Providers;
import shaded.org.glassfish.jersey.model.internal.RankedComparator;
import shaded.org.glassfish.jersey.server.ServerProperties;
import shaded.org.glassfish.jersey.server.internal.JerseyResourceContext;
import shaded.org.glassfish.jersey.server.internal.LocalizationMessages;
import shaded.org.glassfish.jersey.server.internal.routing.LocatorRouting;
import shaded.org.glassfish.jersey.server.internal.routing.Router;
import shaded.org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import shaded.org.glassfish.jersey.server.internal.routing.SubResourceLocatorRouter;
import shaded.org.glassfish.jersey.server.model.ComponentModelValidator;
import shaded.org.glassfish.jersey.server.model.ModelProcessor;
import shaded.org.glassfish.jersey.server.model.ModelValidationException;
import shaded.org.glassfish.jersey.server.model.Resource;
import shaded.org.glassfish.jersey.server.model.ResourceMethod;
import shaded.org.glassfish.jersey.server.model.ResourceModel;
import shaded.org.glassfish.jersey.server.model.ResourceModelComponent;
import shaded.org.glassfish.jersey.server.model.internal.ModelErrors;

final class RuntimeLocatorModelBuilder {
    private static final Logger LOGGER = Logger.getLogger(RuntimeLocatorModelBuilder.class.getName());
    private final ServiceLocator locator;
    private final Configuration config;
    private final RuntimeModelBuilder runtimeModelBuilder;
    private final JerseyResourceContext resourceContext;
    private final LoadingCache<LocatorCacheKey, LocatorRouting> cache;
    private final boolean disableValidation;
    private final boolean ignoreValidationErrors;
    private final boolean enableJerseyResourceCaching;

    RuntimeLocatorModelBuilder(ServiceLocator locator, Configuration config, JerseyResourceContext resourceContext, RuntimeModelBuilder runtimeModelBuilder) {
        this.locator = locator;
        this.config = config;
        this.runtimeModelBuilder = runtimeModelBuilder;
        this.resourceContext = resourceContext;
        this.disableValidation = ServerProperties.getValue(config.getProperties(), "shaded.jersey.config.server.resource.validation.disable", Boolean.FALSE, Boolean.class);
        this.ignoreValidationErrors = ServerProperties.getValue(config.getProperties(), "shaded.jersey.config.server.resource.validation.ignoreErrors", Boolean.FALSE, Boolean.class);
        this.enableJerseyResourceCaching = ServerProperties.getValue(config.getProperties(), "shaded.jersey.config.server.subresource.cache.jersey.resource.enabled", Boolean.FALSE, Boolean.class);
        int size = ServerProperties.getValue(config.getProperties(), "shaded.jersey.config.server.subresource.cache.size", 64, Integer.class);
        int age = ServerProperties.getValue(config.getProperties(), "shaded.jersey.config.server.subresource.cache.age", -1, Integer.class);
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        if (size > 0) {
            cacheBuilder.maximumSize(size);
        } else {
            LOGGER.log(Level.CONFIG, LocalizationMessages.SUBRES_LOC_CACHE_INVALID_SIZE(size, 64));
            cacheBuilder.maximumSize(64L);
        }
        if (age > 0) {
            cacheBuilder.expireAfterAccess(age, TimeUnit.SECONDS);
        }
        this.cache = cacheBuilder.build(new CacheLoader<LocatorCacheKey, LocatorRouting>(){

            @Override
            public LocatorRouting load(LocatorCacheKey key) throws Exception {
                return key.clazz != null ? RuntimeLocatorModelBuilder.this.createRouting(key.clazz) : RuntimeLocatorModelBuilder.this.buildRouting(key.resource);
            }
        });
    }

    Router getRouter(ResourceMethod resourceMethod) {
        return new SubResourceLocatorRouter(this.locator, resourceMethod, this.resourceContext, this);
    }

    LocatorRouting getRouting(Class<?> locatorClass) {
        try {
            return this.cache.get(new LocatorCacheKey(locatorClass));
        }
        catch (ExecutionException ee) {
            LOGGER.log(Level.FINE, LocalizationMessages.SUBRES_LOC_CACHE_LOAD_FAILED(locatorClass), ee);
            return this.createRouting(locatorClass);
        }
    }

    LocatorRouting getRouting(Resource subresource) {
        if (this.enableJerseyResourceCaching) {
            try {
                return this.cache.get(new LocatorCacheKey(subresource));
            }
            catch (ExecutionException ee) {
                LOGGER.log(Level.FINE, LocalizationMessages.SUBRES_LOC_CACHE_LOAD_FAILED(subresource), ee);
                return this.buildRouting(subresource);
            }
        }
        return this.buildRouting(subresource);
    }

    boolean isCached(Class<?> srlClass) {
        return this.cache.getIfPresent(srlClass) != null;
    }

    private LocatorRouting createRouting(Class<?> locatorClass) {
        Resource.Builder builder = Resource.builder(locatorClass, this.disableValidation);
        if (builder == null) {
            builder = Resource.builder().name(locatorClass.getName());
        }
        return this.buildRouting(builder.build());
    }

    private LocatorRouting buildRouting(Resource subResource) {
        ResourceModel model = new ResourceModel.Builder(true).addResource(subResource).build();
        ResourceModel enhancedModel = this.enhance(model);
        if (!this.disableValidation) {
            this.validateResource(enhancedModel);
        }
        Resource enhancedLocator = enhancedModel.getResources().get(0);
        for (Class<?> handlerClass : enhancedLocator.getHandlerClasses()) {
            this.resourceContext.bindResource(handlerClass);
        }
        return new LocatorRouting(enhancedModel, this.runtimeModelBuilder.buildModel(enhancedModel.getRuntimeResourceModel(), true));
    }

    private void validateResource(final ResourceModelComponent component) {
        Errors.process(new Runnable(){

            @Override
            public void run() {
                ComponentModelValidator validator = new ComponentModelValidator(RuntimeLocatorModelBuilder.this.locator);
                validator.validate(component);
                if (Errors.fatalIssuesFound() && !RuntimeLocatorModelBuilder.this.ignoreValidationErrors) {
                    throw new ModelValidationException(LocalizationMessages.ERROR_VALIDATION_SUBRESOURCE(), ModelErrors.getErrorsAsResourceModelIssues());
                }
            }
        });
    }

    private ResourceModel enhance(ResourceModel subResourceModel) {
        Iterable allRankedProviders = Providers.getAllRankedProviders(this.locator, ModelProcessor.class);
        Iterable<ModelProcessor> modelProcessors = Providers.sortRankedProviders(new RankedComparator(), allRankedProviders);
        for (ModelProcessor modelProcessor : modelProcessors) {
            subResourceModel = modelProcessor.processSubResource(subResourceModel, this.config);
            this.validateSubResource(subResourceModel);
        }
        return subResourceModel;
    }

    private void validateSubResource(ResourceModel subResourceModel) {
        if (subResourceModel.getResources().size() != 1) {
            throw new ProcessingException(LocalizationMessages.ERROR_SUB_RESOURCE_LOCATOR_MORE_RESOURCES(subResourceModel.getResources().size()));
        }
    }

    private static class LocatorCacheKey {
        private final Class<?> clazz;
        private final Resource resource;

        public LocatorCacheKey(Class<?> clazz) {
            this(clazz, null);
        }

        public LocatorCacheKey(Resource resource) {
            this(null, resource);
        }

        private LocatorCacheKey(Class<?> clazz, Resource resource) {
            this.clazz = clazz;
            this.resource = resource;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocatorCacheKey that = (LocatorCacheKey)o;
            if (this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null) {
                return false;
            }
            return !(this.resource != null ? !this.resource.equals(that.resource) : that.resource != null);
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
            return result;
        }
    }
}

