/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jvnet.hk2.internal;

import javax.inject.Inject;
import javax.inject.Named;
import shaded.org.glassfish.hk2.api.ActiveDescriptor;
import shaded.org.glassfish.hk2.api.Injectee;
import shaded.org.glassfish.hk2.api.InjectionResolver;
import shaded.org.glassfish.hk2.api.MultiException;
import shaded.org.glassfish.hk2.api.ServiceHandle;
import shaded.org.glassfish.hk2.api.UnsatisfiedDependencyException;
import shaded.org.jvnet.hk2.internal.ServiceLocatorImpl;

@Named(value="SystemInjectResolver")
public class ThreeThirtyResolver
implements InjectionResolver<Inject> {
    private final ServiceLocatorImpl locator;

    ThreeThirtyResolver(ServiceLocatorImpl locator) {
        this.locator = locator;
    }

    @Override
    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        ActiveDescriptor<?> ad = this.locator.getInjecteeDescriptor(injectee);
        if (ad == null) {
            if (injectee.isOptional()) {
                return null;
            }
            throw new MultiException(new UnsatisfiedDependencyException(injectee));
        }
        return this.locator.getService(ad, root, injectee);
    }

    @Override
    public boolean isConstructorParameterIndicator() {
        return false;
    }

    @Override
    public boolean isMethodParameterIndicator() {
        return false;
    }

    public String toString() {
        return "ThreeThirtyResolver(" + this.locator + "," + System.identityHashCode(this) + ")";
    }
}

