/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.CharChunk;

public class DataChunk {
    Type type = Type.None;
    final BufferChunk bufferChunk;
    final CharChunk charChunk;
    String stringValue;

    public static DataChunk newInstance() {
        return DataChunk.newInstance(new BufferChunk(), new CharChunk(), null);
    }

    public static DataChunk newInstance(BufferChunk bufferChunk, CharChunk charChunk, String stringValue) {
        return new DataChunk(bufferChunk, charChunk, stringValue);
    }

    protected DataChunk() {
        this(new BufferChunk(), new CharChunk(), null);
    }

    protected DataChunk(BufferChunk bufferChunk, CharChunk charChunk, String stringValue) {
        this.bufferChunk = bufferChunk;
        this.charChunk = charChunk;
        this.stringValue = stringValue;
    }

    public DataChunk toImmutable() {
        return new Immutable(this);
    }

    public Type getType() {
        return this.type;
    }

    public void set(DataChunk value) {
        switch (value.getType()) {
            case Buffer: {
                BufferChunk anotherBufferChunk = value.bufferChunk;
                this.setBufferInternal(anotherBufferChunk.getBuffer(), anotherBufferChunk.getStart(), anotherBufferChunk.getEnd());
                break;
            }
            case String: {
                this.setStringInternal(value.stringValue);
                break;
            }
            case Chars: {
                CharChunk anotherCharChunk = value.charChunk;
                this.setCharsInternal(anotherCharChunk.getChars(), anotherCharChunk.getStart(), anotherCharChunk.getLimit());
                break;
            }
        }
        this.onContentChanged();
    }

    public void notifyDirectUpdate() {
        switch (this.type) {
            case Buffer: {
                this.bufferChunk.notifyDirectUpdate();
                return;
            }
            case Chars: {
                this.charChunk.notifyDirectUpdate();
            }
        }
    }

    public BufferChunk getBufferChunk() {
        return this.bufferChunk;
    }

    public void setBuffer(Buffer buffer, int position, int limit) {
        this.setBufferInternal(buffer, position, limit);
    }

    public void setBuffer(Buffer buffer) {
        this.setBufferInternal(buffer, buffer.position(), buffer.limit());
    }

    public void setBuffer(Buffer buffer, boolean disposeOnRecycle) {
        this.setBufferInternal(buffer, buffer.position(), buffer.limit(), disposeOnRecycle);
    }

    public CharChunk getCharChunk() {
        return this.charChunk;
    }

    public void setChars(char[] chars, int position, int limit) {
        this.setCharsInternal(chars, position, limit);
    }

    public void setString(String string) {
        this.setStringInternal(string);
    }

    public void duplicate(DataChunk src) {
        switch (src.getType()) {
            case Buffer: {
                BufferChunk bc = src.getBufferChunk();
                this.bufferChunk.allocate(2 * bc.getLength());
                this.bufferChunk.append(bc);
                this.switchToBufferChunk();
                break;
            }
            case Chars: {
                CharChunk cc = src.getCharChunk();
                this.charChunk.allocate(2 * cc.getLength(), -1);
                try {
                    this.charChunk.append(cc);
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                this.switchToCharChunk();
                break;
            }
            case String: {
                this.setString(src.toString());
                break;
            }
            default: {
                this.recycle();
            }
        }
    }

    public void toChars(Charset charset) throws CharConversionException {
        switch (this.type) {
            case Buffer: {
                this.bufferChunk.toChars(this.charChunk, charset);
                this.setChars(this.charChunk.getChars(), this.charChunk.getStart(), this.charChunk.getEnd());
                return;
            }
            case String: {
                this.setChars(this.stringValue.toCharArray(), 0, this.stringValue.length());
                return;
            }
            case Chars: {
                return;
            }
        }
        this.charChunk.recycle();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Charset charset) {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.toString(charset);
            }
            case String: {
                return this.stringValue;
            }
            case Chars: {
                return this.charChunk.toString();
            }
        }
        return null;
    }

    protected void onContentChanged() {
    }

    public int getLength() {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.getLength();
            }
            case String: {
                return this.stringValue.length();
            }
            case Chars: {
                return this.charChunk.getLength();
            }
        }
        return 0;
    }

    public int getStart() {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.getStart();
            }
            case Chars: {
                return this.charChunk.getStart();
            }
        }
        return 0;
    }

    public int getEnd() {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.getEnd();
            }
            case Chars: {
                return this.charChunk.getEnd();
            }
        }
        return this.stringValue.length();
    }

    public final int indexOf(char c, int fromIndex) {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.indexOf(c, fromIndex);
            }
            case String: {
                return this.stringValue.indexOf(c, fromIndex);
            }
            case Chars: {
                return this.charChunk.indexOf(c, fromIndex);
            }
        }
        return -1;
    }

    public final int indexOf(String s, int fromIndex) {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.indexOf(s, fromIndex);
            }
            case String: {
                return this.stringValue.indexOf(s, fromIndex);
            }
            case Chars: {
                return this.charChunk.indexOf(s, fromIndex);
            }
        }
        return -1;
    }

    public final void delete(int from, int to) {
        switch (this.type) {
            case Buffer: {
                this.bufferChunk.delete(from, to);
                return;
            }
            case String: {
                this.stringValue = this.stringValue.substring(0, from) + this.stringValue.substring(to, this.stringValue.length());
                return;
            }
            case Chars: {
                this.charChunk.delete(from, to);
            }
        }
    }

    public boolean equals(String s) {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.equals(s);
            }
            case String: {
                return this.stringValue.equals(s);
            }
            case Chars: {
                return this.charChunk.equals(s);
            }
        }
        return false;
    }

    public int hashCode() {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.hash();
            }
            case String: {
                return this.stringValue.hashCode();
            }
            case Chars: {
                return this.charChunk.hash();
            }
        }
        return 0;
    }

    public boolean equalsIgnoreCase(String s) {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.equalsIgnoreCase(s);
            }
            case String: {
                return this.stringValue.equalsIgnoreCase(s);
            }
            case Chars: {
                return this.charChunk.equalsIgnoreCase(s);
            }
        }
        return false;
    }

    public final boolean equalsIgnoreCase(byte[] b) {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.equalsIgnoreCase(b);
            }
            case String: {
                return DataChunk.equalsIgnoreCase(this.stringValue, b);
            }
            case Chars: {
                return this.charChunk.equalsIgnoreCase(b);
            }
        }
        return false;
    }

    public final boolean equalsIgnoreCaseLowerCase(byte[] b) {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.equalsIgnoreCaseLowerCase(b);
            }
            case String: {
                return DataChunk.equalsIgnoreCaseLowerCase(this.stringValue, b);
            }
            case Chars: {
                return this.charChunk.equalsIgnoreCaseLowerCase(b);
            }
        }
        return false;
    }

    public final boolean startsWith(String s, int pos) {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.startsWith(s, pos);
            }
            case String: {
                if (this.stringValue.length() < pos + s.length()) {
                    return false;
                }
                for (int i = 0; i < s.length(); ++i) {
                    if (s.charAt(i) == this.stringValue.charAt(pos + i)) continue;
                    return false;
                }
                return true;
            }
            case Chars: {
                return this.charChunk.startsWith(s, pos);
            }
        }
        return false;
    }

    public final boolean startsWithIgnoreCase(String s, int pos) {
        switch (this.type) {
            case Buffer: {
                return this.bufferChunk.startsWithIgnoreCase(s, pos);
            }
            case String: {
                if (this.stringValue.length() < pos + s.length()) {
                    return false;
                }
                for (int i = 0; i < s.length(); ++i) {
                    if (Ascii.toLower(s.charAt(i)) == Ascii.toLower(this.stringValue.charAt(pos + i))) continue;
                    return false;
                }
                return true;
            }
            case Chars: {
                return this.charChunk.startsWithIgnoreCase(s, pos);
            }
        }
        return false;
    }

    public final boolean isNull() {
        return this.type == Type.None || this.bufferChunk.isNull() && this.stringValue == null && this.charChunk.isNull();
    }

    protected void resetBuffer() {
        this.bufferChunk.recycle();
    }

    protected void resetCharChunk() {
        this.charChunk.recycle();
    }

    protected void resetString() {
        this.stringValue = null;
    }

    protected void reset() {
        this.stringValue = null;
        if (this.type == Type.Chars) {
            this.charChunk.recycle();
        } else if (this.type == Type.Buffer) {
            this.bufferChunk.recycle();
        }
        this.type = Type.None;
    }

    public void recycle() {
        this.reset();
    }

    private static boolean equalsIgnoreCase(String s, byte[] b) {
        int len = b.length;
        if (s.length() != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Ascii.toLower(s.charAt(i)) == Ascii.toLower(b[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsIgnoreCaseLowerCase(String s, byte[] b) {
        int len = b.length;
        if (s.length() != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Ascii.toLower(s.charAt(i)) == b[i]) continue;
            return false;
        }
        return true;
    }

    private void setBufferInternal(Buffer buffer, int position, int limit) {
        this.setBufferInternal(buffer, position, limit, false);
    }

    private void setBufferInternal(Buffer buffer, int position, int limit, boolean disposeOnRecycle) {
        this.bufferChunk.setBufferChunk(buffer, position, limit, disposeOnRecycle);
        this.switchToBufferChunk();
    }

    private void setCharsInternal(char[] chars, int position, int limit) {
        this.charChunk.setChars(chars, position, limit - position);
        this.switchToCharChunk();
    }

    private void setStringInternal(String string) {
        this.stringValue = string;
        this.switchToString();
    }

    private void switchToBufferChunk() {
        if (this.type == Type.Chars) {
            this.resetCharChunk();
        }
        this.resetString();
        this.type = Type.Buffer;
        this.onContentChanged();
    }

    private void switchToCharChunk() {
        if (this.type == Type.Buffer) {
            this.resetBuffer();
        }
        this.resetString();
        this.type = Type.Chars;
        this.onContentChanged();
    }

    private void switchToString() {
        if (this.type == Type.Chars) {
            this.resetCharChunk();
        } else if (this.type == Type.Buffer) {
            this.resetBuffer();
        }
        this.type = Type.String;
        this.onContentChanged();
    }

    static final class Immutable
    extends DataChunk {
        public Immutable(DataChunk original) {
            super.set(original);
        }

        @Override
        public DataChunk toImmutable() {
            return this;
        }

        @Override
        public void set(DataChunk value) {
        }

        @Override
        public void setBuffer(Buffer buffer, int start, int end) {
        }

        @Override
        public void setString(String string) {
        }

        @Override
        public void setChars(char[] chars, int position, int limit) {
        }

        @Override
        protected final void resetBuffer() {
        }

        @Override
        protected final void resetString() {
        }

        @Override
        protected void resetCharChunk() {
        }

        @Override
        protected void reset() {
        }

        @Override
        public void recycle() {
        }
    }

    public static enum Type {
        None,
        Buffer,
        Chars,
        String;

    }
}

