/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memcached;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.utils.DataStructures;

public class ConsistentHashStore<T> {
    private static final Logger logger = Grizzly.logger(ConsistentHashStore.class);
    private static final ThreadLocal<MessageDigest> md5ThreadLocal = new ThreadLocal();
    private static volatile boolean md5NotSupported;
    private static final int REPLICA_NUMBER = 160;
    private final ConcurrentSkipListMap<Long, T> buckets = new ConcurrentSkipListMap();
    private final Set<T> values = Collections.newSetFromMap(DataStructures.getConcurrentMap());

    public void add(T value) {
        this.addOrRemove(value, true);
        this.values.add(value);
    }

    public void remove(T value) {
        this.addOrRemove(value, false);
        this.values.remove(value);
    }

    public boolean hasValue(T value) {
        return value != null && this.values.contains(value);
    }

    public void clear() {
        this.buckets.clear();
        this.values.clear();
    }

    private void addOrRemove(T value, boolean add) {
        if (value == null) {
            return;
        }
        MessageDigest md5 = ConsistentHashStore.getMessageDigest();
        if (md5 == null) {
            for (int i = 0; i < 160; ++i) {
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append(value).append('-').append(i);
                CRC32 crc32 = new CRC32();
                crc32.update(stringBuilder.toString().getBytes());
                long hashKey = crc32.getValue() >> 16 & 0x7FFFL;
                if (add) {
                    this.buckets.putIfAbsent(hashKey, value);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "added {0} to the bucket successfully. key={1}", new Object[]{value, hashKey});
                    continue;
                }
                this.buckets.remove(hashKey);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "removed {0} to the bucket successfully. key={1}", new Object[]{value, hashKey});
            }
        } else {
            for (int i = 0; i < 40; ++i) {
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append(value).append('-').append(i);
                byte[] digest = md5.digest(stringBuilder.toString().getBytes());
                for (int j = 0; j < 4; ++j) {
                    long hashKey = (long)(digest[3 + j * 4] & 0xFF) << 24 | (long)(digest[2 + j * 4] & 0xFF) << 16 | (long)(digest[1 + j * 4] & 0xFF) << 8 | (long)(digest[j * 4] & 0xFF);
                    if (add) {
                        this.buckets.putIfAbsent(hashKey, value);
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "added {0} to the bucket successfully. key={1}", new Object[]{value, hashKey});
                        continue;
                    }
                    this.buckets.remove(hashKey);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "removed {0} to the bucket successfully. key={1}", new Object[]{value, hashKey});
                }
            }
        }
    }

    public T get(String key) {
        if (key == null) {
            return null;
        }
        return this.get(key.getBytes());
    }

    public T get(byte[] key) {
        if (key == null) {
            return null;
        }
        if (this.buckets.size() == 0) {
            return null;
        }
        if (this.buckets.size() == 1) {
            return this.buckets.firstEntry().getValue();
        }
        Long hashKey = this.buckets.ceilingKey(this.calculateHash(key));
        if (hashKey == null) {
            hashKey = this.buckets.firstKey();
        }
        return this.buckets.get(hashKey);
    }

    public T get(ByteBuffer key) {
        if (key == null) {
            return null;
        }
        if (this.buckets.size() == 0) {
            return null;
        }
        if (this.buckets.size() == 1) {
            return this.buckets.firstEntry().getValue();
        }
        Long hashKey = this.buckets.ceilingKey(this.calculateHash(key));
        if (hashKey == null) {
            hashKey = this.buckets.firstKey();
        }
        return this.buckets.get(hashKey);
    }

    private long calculateHash(byte[] key) {
        long hash;
        if (key == null) {
            return 0L;
        }
        MessageDigest md5 = ConsistentHashStore.getMessageDigest();
        if (md5 == null) {
            CRC32 crc32 = new CRC32();
            crc32.update(key);
            hash = crc32.getValue() >> 16 & 0x7FFFL;
        } else {
            md5.reset();
            byte[] digest = md5.digest(key);
            hash = (long)(digest[3] & 0xFF) << 24 | (long)(digest[2] & 0xFF) << 16 | (long)(digest[1] & 0xFF) << 8 | (long)(digest[0] & 0xFF);
        }
        return hash;
    }

    private long calculateHash(ByteBuffer key) {
        long hash;
        if (key == null) {
            return 0L;
        }
        MessageDigest md5 = ConsistentHashStore.getMessageDigest();
        if (md5 == null) {
            if (key.hasArray()) {
                CRC32 crc32 = new CRC32();
                byte[] b = key.array();
                int ofs = key.arrayOffset();
                int pos = key.position();
                int lim = key.limit();
                crc32.update(b, ofs + pos, lim - pos);
                key.position(lim);
                hash = crc32.getValue() >> 16 & 0x7FFFL;
            } else {
                hash = key.hashCode();
            }
        } else {
            md5.reset();
            md5.update(key);
            byte[] digest = md5.digest();
            hash = (long)(digest[3] & 0xFF) << 24 | (long)(digest[2] & 0xFF) << 16 | (long)(digest[1] & 0xFF) << 8 | (long)(digest[0] & 0xFF);
        }
        return hash;
    }

    private static MessageDigest getMessageDigest() {
        MessageDigest md5;
        block4: {
            if (md5NotSupported) {
                return null;
            }
            md5 = md5ThreadLocal.get();
            if (md5 == null) {
                try {
                    md5 = MessageDigest.getInstance("MD5");
                    md5ThreadLocal.set(md5);
                }
                catch (NoSuchAlgorithmException nsae) {
                    md5NotSupported = true;
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.log(Level.WARNING, "failed to get the md5", nsae);
                }
            }
        }
        return md5;
    }
}

