/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.AsyncioModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyDictDelItem;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_asyncio")
public final class AsyncioModuleBuiltins
extends PythonBuiltins {
    public static final TruffleString T_ASYNCIO_EVENTS = PythonUtils.tsLiteral("asyncio");
    public static final TruffleString T_GET_EVENT_LOOP_POLICY = PythonUtils.tsLiteral("get_event_loop_policy");
    public static final TruffleString T_GET_EVENT_LOOP = PythonUtils.tsLiteral("get_event_loop");
    public static final TruffleString CURRENT_TASKS_ATTR = PythonUtils.tsLiteral("_current_tasks");
    public static final TruffleString ALL_TASKS_ATTR = PythonUtils.tsLiteral("_all_tasks");
    private static final TruffleString WEAKREF = PythonUtils.tsLiteral("weakref");
    private static final TruffleString WEAKSET = PythonUtils.tsLiteral("WeakSet");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AsyncioModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        PythonObjectSlowPathFactory factory = core.factory();
        PythonModule self = core.lookupBuiltinModule(BuiltinNames.T__ASYNCIO);
        self.setAttribute(CURRENT_TASKS_ATTR, factory.createDict());
        PythonModule weakref = AbstractImportNode.importModule(WEAKREF);
        Object weakSetCls = PyObjectGetAttr.executeUncached(weakref, WEAKSET);
        Object weakSet = CallNode.executeUncached(weakSetCls, new Object[0]);
        self.setAttribute(ALL_TASKS_ATTR, weakSet);
    }

    @Builtin(name="_unregister_task", declaresExplicitSelf=true, minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class UnregisterTask
    extends PythonBuiltinNode {
        @Specialization
        public Object unregisterTask(VirtualFrame frame, PythonModule self, Object task, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            Object weakset = self.getAttribute(ALL_TASKS_ATTR);
            callMethod.execute((Frame)frame, inliningTarget, weakset, BuiltinNames.T_DISCARD, task);
            return PNone.NONE;
        }
    }

    @Builtin(name="_register_task", declaresExplicitSelf=true, minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RegisterTask
    extends PythonBuiltinNode {
        private static final TruffleString ADD = PythonUtils.tsLiteral("add");

        @Specialization
        public Object registerTask(VirtualFrame frame, PythonModule self, Object task, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callmethod) {
            Object weakset = self.getAttribute(ALL_TASKS_ATTR);
            callmethod.execute((Frame)frame, inliningTarget, weakset, BuiltinNames.T_ADD, task);
            return PNone.NONE;
        }
    }

    @Builtin(name="_leave_task", declaresExplicitSelf=true, minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class LeaveTask
    extends PythonBuiltinNode {
        @Specialization
        public Object leaveTask(VirtualFrame frame, PythonModule self, Object loop, Object task, @Bind(value="this") Node inliningTarget, @Cached PyDictDelItem del, @Cached PyDictGetItem get, @Cached PRaiseNode raise) {
            PDict dict = (PDict)self.getAttribute(CURRENT_TASKS_ATTR);
            Object item = get.execute((Frame)frame, inliningTarget, dict, loop);
            if (item == null) {
                item = PNone.NONE;
            }
            if (item != task) {
                throw raise.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.TASK_NOT_ENTERED, task, item);
            }
            del.execute((Frame)frame, inliningTarget, dict, loop);
            return PNone.NONE;
        }
    }

    @Builtin(name="_enter_task", declaresExplicitSelf=true, minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class EnterTask
    extends PythonBuiltinNode {
        @Specialization
        public Object enterTask(VirtualFrame frame, PythonModule self, Object loop, Object task, @Bind(value="this") Node inliningTarget, @Cached PyDictSetItem set, @Cached PyDictGetItem get, @Cached PRaiseNode raise) {
            PDict dict = (PDict)self.getAttribute(CURRENT_TASKS_ATTR);
            Object item = get.execute((Frame)frame, inliningTarget, dict, loop);
            if (item != null) {
                throw raise.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.CANT_ENTER_TASK_ALREADY_RUNNING, task, item);
            }
            set.execute((Frame)frame, inliningTarget, dict, loop, task);
            return PNone.NONE;
        }
    }

    @Builtin(name="_get_event_loop", parameterNames={"stacklevel"})
    @GenerateNodeFactory
    public static abstract class DeprGetEventLoop
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getCurrentLoop(VirtualFrame frame, Object stacklevel, @Cached GetEventLoop getLoop) {
            return getLoop.execute(frame, null);
        }
    }

    @Builtin(name="get_event_loop", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @ImportStatic(value={AsyncioModuleBuiltins.class})
    public static abstract class GetEventLoop
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getCurrentLoop(VirtualFrame frame, Object ignored, @Cached CallNode callGetPolicy, @Cached CallNode callGetLoop, @Cached AbstractImportNode.ImportName importName, @Cached(parameters={"T_GET_EVENT_LOOP"}) GetAttributeNode.GetFixedAttributeNode getGetLoop, @Cached(parameters={"T_GET_EVENT_LOOP_POLICY"}) GetAttributeNode.GetFixedAttributeNode getGetLoopPolicy) {
            Object eventLoop = this.getContext().getThreadState(this.getLanguage()).getRunningEventLoop();
            if (eventLoop == null) {
                Object asyncio = importName.execute((Frame)frame, this.getContext(), this.getContext().getBuiltins(), T_ASYNCIO_EVENTS, PNone.NONE, PythonUtils.EMPTY_TRUFFLESTRING_ARRAY, 0);
                Object asyncioGetPolicy = getGetLoopPolicy.execute(frame, asyncio);
                Object policy = callGetPolicy.execute((Frame)frame, asyncioGetPolicy, new Object[0]);
                Object getLoop = getGetLoop.execute(frame, policy);
                return callGetLoop.execute((Frame)frame, getLoop, new Object[0]);
            }
            return eventLoop;
        }
    }

    @Builtin(name="_set_running_loop", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class InternalSetRunningLoop
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object setCurrentLoop(Object loop) {
            this.getContext().getThreadState(this.getLanguage()).setRunningEventLoop(loop == PNone.NONE ? null : loop);
            return PNone.NONE;
        }
    }

    @Builtin(name="_get_running_loop")
    @GenerateNodeFactory
    public static abstract class InternalGetRunningLoop
    extends PythonBuiltinNode {
        @Specialization
        public Object getCurrentLoop() {
            Object eventLoop = this.getContext().getThreadState(this.getLanguage()).getRunningEventLoop();
            return eventLoop == null ? PNone.NONE : eventLoop;
        }
    }

    @Builtin(name="get_running_loop")
    @GenerateNodeFactory
    public static abstract class GetRunningLoop
    extends PythonBuiltinNode {
        @Specialization
        public Object getCurrentLoop(@Cached PRaiseNode raise) {
            Object eventLoop = this.getContext().getThreadState(this.getLanguage()).getRunningEventLoop();
            if (eventLoop == null) {
                throw raise.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.NO_RUNNING_EVENT_LOOP);
            }
            return eventLoop;
        }
    }
}

