/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ast;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.ast.AstModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.TruffleString;

final class AstTypeFactory {
    private final PythonLanguage language;
    private final PythonObjectFactory factory;
    private final PythonModule astModule;

    AstTypeFactory(PythonLanguage language, PythonObjectFactory factory, PythonModule astModule) {
        this.language = language;
        this.factory = factory;
        this.astModule = astModule;
    }

    PythonClass makeType(TruffleString name, PythonAbstractClass base, TruffleString[] fields, TruffleString[] attributes, TruffleString[] optional, TruffleString docString) {
        PythonClass newType = this.factory.createPythonClassAndFixupSlots(this.language, (Object)PythonBuiltinClassType.PythonClass, name, base, new PythonAbstractClass[]{base});
        newType.setAttribute(SpecialAttributeNames.T___MODULE__, AstModuleBuiltins.T_AST);
        newType.setAttribute(SpecialAttributeNames.T___DOC__, docString);
        newType.setAttribute(AstModuleBuiltins.T__FIELDS, this.factory.createTuple(PythonUtils.convertToObjectArray(fields)));
        newType.setAttribute(SpecialAttributeNames.T___MATCH_ARGS__, this.factory.createTuple(PythonUtils.convertToObjectArray(fields)));
        if (attributes != null) {
            newType.setAttribute(AstModuleBuiltins.T__ATTRIBUTES, this.factory.createTuple(PythonUtils.convertToObjectArray(attributes)));
        }
        for (TruffleString n : optional) {
            newType.setAttribute(n, PNone.NONE);
        }
        this.astModule.setAttribute(name, newType);
        return newType;
    }

    PythonObject createSingleton(PythonClass cls) {
        return this.factory.createPythonObject(cls);
    }
}

