/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.json;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.json.JSONModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.json.JSONModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.json.JSONScannerBuiltins;
import com.oracle.graal.python.builtins.modules.json.JSONUtils;
import com.oracle.graal.python.builtins.modules.json.PJSONEncoder;
import com.oracle.graal.python.builtins.modules.json.PJSONScanner;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.expression.CoerceToBooleanNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.List;

@CoreFunctions(defineModule="_json")
public final class JSONModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return JSONModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)"json speedups\n");
        this.addBuiltinConstant("make_scanner", (Object)core.lookupType(PythonBuiltinClassType.JSONScanner));
        this.addBuiltinConstant("make_encoder", (Object)core.lookupType(PythonBuiltinClassType.JSONEncoder));
        super.initialize(core);
    }

    static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    @Builtin(name="make_encoder", minNumOfPositionalArgs=10, parameterNames={"$cls", "markers", "default", "encoder", "indent", "key_separator", "item_separator", "sort_keys", "skipkeys", "allow_nan"}, constructsClass=PythonBuiltinClassType.JSONEncoder, doc="JSON scanner object")
    @ArgumentsClinic(value={@ArgumentClinic(name="key_separator", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="item_separator", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="sort_keys", conversion=ArgumentClinic.ClinicConversion.Boolean), @ArgumentClinic(name="skipkeys", conversion=ArgumentClinic.ClinicConversion.Boolean), @ArgumentClinic(name="allow_nan", conversion=ArgumentClinic.ClinicConversion.Boolean)})
    @GenerateNodeFactory
    public static abstract class MakeEncoder
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return JSONModuleBuiltinsClinicProviders.MakeEncoderClinicProviderGen.INSTANCE;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PJSONEncoder doNew(Object cls, Object markers, Object defaultFn, Object encoder, Object indent, TruffleString keySeparator, TruffleString itemSeparator, boolean sortKeys, boolean skipKeys, boolean allowNan) {
            PBuiltinFunction function;
            Class<? extends PythonBuiltinBaseNode> nodeClass;
            if (markers != PNone.NONE && !(markers instanceof PDict)) {
                throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.TypeError, ErrorMessages.MAKE_ENCODER_ARG_1_MUST_BE_DICT, markers);
            }
            PJSONEncoder.FastEncode fastEncode = PJSONEncoder.FastEncode.None;
            Object encoderAsFun = encoder;
            if (encoder instanceof PBuiltinMethod) {
                PBuiltinMethod encoderMethod = (PBuiltinMethod)encoder;
                encoderAsFun = encoderMethod.getFunction();
            }
            if (encoderAsFun instanceof PBuiltinFunction && (nodeClass = (function = (PBuiltinFunction)encoderAsFun).getNodeClass()) != null) {
                if (EncodeBaseString.class.isAssignableFrom(nodeClass)) {
                    fastEncode = PJSONEncoder.FastEncode.FastEncode;
                } else if (EncodeBaseStringAscii.class.isAssignableFrom(nodeClass)) {
                    fastEncode = PJSONEncoder.FastEncode.FastEncodeAscii;
                }
            }
            return this.getContext().factory().createJSONEncoder(cls, markers, defaultFn, encoder, indent, keySeparator, itemSeparator, sortKeys, skipKeys, allowNan, fastEncode);
        }
    }

    @Builtin(name="make_scanner", parameterNames={"$cls", "context"}, constructsClass=PythonBuiltinClassType.JSONScanner, doc="_iterencode(obj, _current_indent_level) -> iterable")
    @GenerateNodeFactory
    public static abstract class MakeScanner
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getStrict = GetAttributeNode.GetFixedAttributeNode.create(StringLiterals.T_STRICT);
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getObjectHook = GetAttributeNode.GetFixedAttributeNode.create(PythonUtils.tsLiteral("object_hook"));
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getObjectPairsHook = GetAttributeNode.GetFixedAttributeNode.create(PythonUtils.tsLiteral("object_pairs_hook"));
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getParseFloat = GetAttributeNode.GetFixedAttributeNode.create(PythonUtils.tsLiteral("parse_float"));
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getParseInt = GetAttributeNode.GetFixedAttributeNode.create(PythonUtils.tsLiteral("parse_int"));
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getParseConstant = GetAttributeNode.GetFixedAttributeNode.create(PythonUtils.tsLiteral("parse_constant"));

        @Specialization
        public PJSONScanner doNew(VirtualFrame frame, Object cls, Object context, @Bind(value="this") Node inliningTarget, @Cached CoerceToBooleanNode.YesNode castStrict, @Cached PythonObjectFactory factory) {
            boolean strict = castStrict.executeBoolean(frame, inliningTarget, this.getStrict.execute(frame, context));
            Object objectHook = this.getObjectHook.execute(frame, context);
            Object objectPairsHook = this.getObjectPairsHook.execute(frame, context);
            Object parseFloat = this.getParseFloat.execute(frame, context);
            Object parseInt = this.getParseInt.execute(frame, context);
            Object parseConstant = this.getParseConstant.execute(frame, context);
            return factory.createJSONScanner(cls, strict, objectHook, objectPairsHook, parseFloat, parseInt, parseConstant);
        }
    }

    @Builtin(name="encode_basestring_ascii", parameterNames={"string"}, doc="encode_basestring_ascii(string) -> string\n\nReturn an ASCII-only JSON representation of a Python string")
    @GenerateNodeFactory
    @ArgumentClinic(name="string", conversion=ArgumentClinic.ClinicConversion.TString)
    static abstract class EncodeBaseStringAscii
    extends PythonUnaryClinicBuiltinNode {
        EncodeBaseStringAscii() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return JSONModuleBuiltinsClinicProviders.EncodeBaseStringAsciiClinicProviderGen.INSTANCE;
        }

        @Specialization
        static TruffleString call(TruffleString string, @Bind(value="this") Node inliningTarget, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int len = string.byteLength(PythonUtils.TS_ENCODING);
                TruffleStringBuilder builder = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)(len + (len >> 3) + 2));
                JSONUtils.appendString(string, createCodePointIteratorNode.execute((AbstractTruffleString)string, PythonUtils.TS_ENCODING), builder, true, nextNode, appendCodePointNode, appendStringNode, substringNode);
                return toStringNode.execute(builder);
            }
            catch (NegativeArraySizeException | OutOfMemoryError e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.STR_TOO_LONG_TO_ESCAPE);
            }
        }
    }

    @Builtin(name="encode_basestring", parameterNames={"string"}, doc="encode_basestring(string) -> string\n\nReturn a JSON representation of a Python string")
    @GenerateNodeFactory
    @ArgumentClinic(name="string", conversion=ArgumentClinic.ClinicConversion.TString)
    static abstract class EncodeBaseString
    extends PythonUnaryClinicBuiltinNode {
        EncodeBaseString() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return JSONModuleBuiltinsClinicProviders.EncodeBaseStringClinicProviderGen.INSTANCE;
        }

        @Specialization
        static TruffleString call(TruffleString string, @Bind(value="this") Node inliningTarget, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int len = string.byteLength(PythonUtils.TS_ENCODING);
                TruffleStringBuilder builder = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)(len + (len >> 3) + 2));
                JSONUtils.appendString(string, createCodePointIteratorNode.execute((AbstractTruffleString)string, PythonUtils.TS_ENCODING), builder, false, nextNode, appendCodePointNode, appendStringNode, substringNode);
                return toStringNode.execute(builder);
            }
            catch (NegativeArraySizeException | OutOfMemoryError e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.STR_TOO_LONG_TO_ESCAPE);
            }
        }
    }

    @Builtin(name="scanstring", minNumOfPositionalArgs=2, parameterNames={"string", "end", "strict"}, doc="scanstring(string, end, strict=True) -> (string, end)\n\nScan the string s for a JSON string. End is the index of the\ncharacter in s after the quote that started the JSON string.\nUnescapes all valid JSON string escape sequences and raises ValueError\non attempt to decode an invalid string. If strict is False then literal\ncontrol characters are allowed in the string.\n\nReturns a tuple of the decoded string and the index of the character in s\nafter the end quote.")
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="strict", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="true", useDefaultForNone=true)})
    static abstract class ScanString
    extends PythonTernaryClinicBuiltinNode {
        ScanString() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return JSONModuleBuiltinsClinicProviders.ScanStringClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object call(Object string, int end, boolean strict, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToJavaStringCheckedNode castString, @Cached PythonObjectFactory factory) {
            JSONScannerBuiltins.IntRef nextIdx = new JSONScannerBuiltins.IntRef();
            TruffleString result = JSONScannerBuiltins.scanStringUnicode(castString.cast(inliningTarget, string, ErrorMessages.FIRST_ARG_MUST_BE_STRING_NOT_P, string), end, strict, nextIdx, this);
            return factory.createTuple(new Object[]{result, nextIdx.value});
        }
    }
}

