/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;

@ExportLibrary(value=PythonBufferAcquireLibrary.class)
public final class PPickleBuffer
extends PythonBuiltinObject {
    private Object view;

    public PPickleBuffer(Object cls, Shape instanceShape, Object view) {
        super(cls, instanceShape);
        PythonBufferAccessLibrary.assertIsBuffer(view);
        this.view = view;
    }

    public Object getView() {
        return this.view;
    }

    public void release() {
        this.view = null;
    }

    @ExportMessage
    boolean hasBuffer() {
        return true;
    }

    @ExportMessage
    Object acquire(int flags, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib, @Cached PRaiseNode raise) {
        Object owner = null;
        if (this.view != null) {
            owner = bufferLib.getOwner(this.view);
        }
        if (owner == null) {
            throw raise.raise(PythonBuiltinClassType.ValueError, ErrorMessages.OP_FORBIDDEN_ON_OBJECT, "PickleBuffer");
        }
        return acquireLib.acquire(owner, flags);
    }
}

