/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCAccess;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCField;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextSignatureType;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.memoryview.CExtPyBuffer;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary(value=InteropLibrary.class)
public final class GraalHPyBuffer
implements TruffleObject {
    private static final String J_MEMBER_BUF = "buf";
    private static final String J_MEMBER_OBJ = "obj";
    private static final String J_MEMBER_LEN = "len";
    private static final String J_MEMBER_ITEMSIZE = "itemsize";
    private static final String J_MEMBER_READONLY = "readonly";
    private static final String J_MEMBER_NDIM = "ndim";
    private static final String J_MEMBER_FORMAT = "format";
    private static final String J_MEMBER_SHAPE = "shape";
    private static final String J_MEMBER_STRIDES = "strides";
    private static final String J_MEMBER_SUBOFFSETS = "suboffsets";
    private static final String J_MEMBER_INTERNAL = "internal";
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final String[] MEMBERS = new String[]{"buf", "obj", "len", "itemsize", "readonly", "ndim", "format", "shape", "strides", "suboffsets", "internal"};
    final GraalHPyContext context;
    private final CExtPyBuffer buffer;
    private GraalHPyHandle ownerHandle;
    Object nativePointer;

    public GraalHPyBuffer(GraalHPyContext context, CExtPyBuffer buffer) {
        this.context = context;
        this.buffer = buffer;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return new PythonAbstractObject.Keys(new Object[]{J_MEMBER_BUF, J_MEMBER_OBJ, J_MEMBER_LEN, J_MEMBER_ITEMSIZE, J_MEMBER_READONLY, J_MEMBER_NDIM, J_MEMBER_FORMAT, J_MEMBER_SHAPE, J_MEMBER_STRIDES, J_MEMBER_SUBOFFSETS, J_MEMBER_INTERNAL});
    }

    @ExportMessage
    boolean isMemberReadable(String key) {
        for (int i = 0; i < MEMBERS.length; ++i) {
            if (!MEMBERS[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    @ExportMessage
    Object readMember(String member, @Cached GraalHPyNodes.HPyAsHandleNode toNativeNode) throws UnknownIdentifierException {
        switch (member) {
            case "buf": {
                return this.buffer.getBuf();
            }
            case "obj": {
                if (this.ownerHandle == null) {
                    Object obj = this.buffer.getObj();
                    this.ownerHandle = toNativeNode.execute(obj != null ? obj : PNone.NO_VALUE);
                }
                return this.ownerHandle;
            }
            case "len": {
                return this.buffer.getLen();
            }
            case "itemsize": {
                return this.buffer.getItemSize();
            }
            case "readonly": {
                return PInt.intValue(this.buffer.isReadOnly());
            }
            case "ndim": {
                return this.buffer.getDims();
            }
            case "format": {
                return this.buffer.getFormat() != null ? new CArrayWrappers.CStringWrapper(this.buffer.getFormat().switchEncodingUncached(TruffleString.Encoding.UTF_8), TruffleString.Encoding.UTF_8) : toNativeNode.execute(PNone.NO_VALUE);
            }
            case "shape": {
                return GraalHPyBuffer.toCArray(toNativeNode, this.buffer.getShape());
            }
            case "strides": {
                return GraalHPyBuffer.toCArray(toNativeNode, this.buffer.getStrides());
            }
            case "suboffsets": {
                return GraalHPyBuffer.toCArray(toNativeNode, this.buffer.getSuboffsets());
            }
            case "internal": {
                return this.buffer.getInternal();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create((String)member);
    }

    private static Object toCArray(GraalHPyNodes.HPyAsHandleNode toNativeNode, int[] arr) {
        if (arr != null) {
            return new CArrayWrappers.CIntArrayWrapper(arr);
        }
        return toNativeNode.execute(PNone.NO_VALUE);
    }

    @ExportMessage
    boolean isPointer() {
        return this.nativePointer != null;
    }

    @ExportMessage
    long asPointer(@CachedLibrary(limit="1") InteropLibrary lib) throws UnsupportedMessageException {
        return PythonUtils.coerceToLong(this.nativePointer, lib);
    }

    @ExportMessage
    void toNative(@Cached(parameters={"this.context"}) GraalHPyCAccess.AllocateNode allocateNode, @Cached(parameters={"this.context"}) GraalHPyCAccess.WritePointerNode writePointerNode, @Cached(parameters={"this.context"}) GraalHPyCAccess.WriteHPyNode writeHPyNode, @Cached(parameters={"this.context"}) GraalHPyCAccess.WriteSizeTNode writeSizeTNode, @Cached(parameters={"this.context"}) GraalHPyCAccess.WriteI32Node writeI32Node, @Cached TruffleString.AsNativeNode asNativeNode, @Cached TruffleString.GetInternalNativePointerNode getInternalNativePointerNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
        if (this.nativePointer == null) {
            Object nativePointer = allocateNode.malloc(this.context, HPyContextSignatureType.HPy_buffer);
            TruffleString formatUtf8 = switchEncodingNode.execute((AbstractTruffleString)this.buffer.getFormat(), TruffleString.Encoding.UTF_8);
            TruffleString formatNative = asNativeNode.execute(formatUtf8, byteSize -> this.context.nativeToInteropPointer(allocateNode.malloc(this.context, byteSize)), TruffleString.Encoding.UTF_8, true, true);
            Object formatPtr = getInternalNativePointerNode.execute((AbstractTruffleString)formatNative, TruffleString.Encoding.UTF_8);
            writePointerNode.write(this.context, nativePointer, GraalHPyCField.HPy_buffer__buf, this.buffer.getBuf());
            writeHPyNode.write(this.context, nativePointer, GraalHPyCField.HPy_buffer__obj, this.buffer.getObj());
            writeSizeTNode.write(this.context, nativePointer, GraalHPyCField.HPy_buffer__len, this.buffer.getLen());
            writeSizeTNode.write(this.context, nativePointer, GraalHPyCField.HPy_buffer__itemsize, this.buffer.getItemSize());
            writeI32Node.write(this.context, nativePointer, GraalHPyCField.HPy_buffer__readonly, PInt.intValue(this.buffer.isReadOnly()));
            writeI32Node.write(this.context, nativePointer, GraalHPyCField.HPy_buffer__ndim, this.buffer.getDims());
            writePointerNode.write(this.context, nativePointer, GraalHPyCField.HPy_buffer__format, formatPtr);
            writePointerNode.write(this.context, nativePointer, GraalHPyCField.HPy_buffer__shape, GraalHPyBuffer.intArrayToNativeInt64(this.context, this.buffer.getShape(), allocateNode, writeSizeTNode));
            writePointerNode.write(this.context, nativePointer, GraalHPyCField.HPy_buffer__strides, GraalHPyBuffer.intArrayToNativeInt64(this.context, this.buffer.getStrides(), allocateNode, writeSizeTNode));
            writePointerNode.write(this.context, nativePointer, GraalHPyCField.HPy_buffer__suboffsets, GraalHPyBuffer.intArrayToNativeInt64(this.context, this.buffer.getSuboffsets(), allocateNode, writeSizeTNode));
            writePointerNode.write(this.context, nativePointer, GraalHPyCField.HPy_buffer__internal, this.buffer.getInternal());
            this.nativePointer = nativePointer;
        }
    }

    private static Object intArrayToNativeInt64(GraalHPyContext ctx, int[] data, GraalHPyCAccess.AllocateNode allocateNode, GraalHPyCAccess.WriteSizeTNode writeSizeTNode) {
        if (data != null) {
            long elemSize = ctx.getCTypeSize(HPyContextSignatureType.HPy_ssize_t);
            Object ptr = allocateNode.calloc(ctx, data.length, elemSize);
            for (int i = 0; i < data.length; ++i) {
                writeSizeTNode.execute(ctx, ptr, (long)i * elemSize, data[i]);
            }
            return ptr;
        }
        return ctx.getNativeNull();
    }

    void free(GraalHPyContext ctx, GraalHPyCAccess.FreeNode freeNode, GraalHPyCAccess.ReadPointerNode readPointerNode, GraalHPyCAccess.ReadHPyNode readHPyNode) {
        if (this.ownerHandle != null) {
            this.ownerHandle.closeAndInvalidate(this.context);
        }
        if (this.nativePointer != null) {
            Object owner = readHPyNode.readAndClose(ctx, this.nativePointer, GraalHPyCField.HPy_buffer__obj);
            assert (owner == this.buffer.getObj());
            Object format = readPointerNode.read(ctx, this.nativePointer, GraalHPyCField.HPy_buffer__format);
            Object shape = readPointerNode.read(ctx, this.nativePointer, GraalHPyCField.HPy_buffer__shape);
            Object suboffsets = readPointerNode.read(ctx, this.nativePointer, GraalHPyCField.HPy_buffer__suboffsets);
            freeNode.free(ctx, format);
            freeNode.free(ctx, shape);
            freeNode.free(ctx, suboffsets);
            freeNode.free(ctx, this.nativePointer);
        }
    }
}

