/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.llvm;

import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
final class NativeSpaceArrayWrapper
implements TruffleObject {
    final GraalHPyContext.GraalHPyHandleReference[] data;

    public NativeSpaceArrayWrapper(GraalHPyContext.GraalHPyHandleReference[] data) {
        this.data = data;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    long getArraySize() {
        return (long)this.data.length * 2L;
    }

    @ExportMessage
    boolean isArrayElementReadable(long i) {
        return i < (long)this.data.length * 2L;
    }

    @ExportMessage
    Object readArrayElement(long i) {
        GraalHPyContext.GraalHPyHandleReference ref = this.data[(int)i / 2];
        if (ref != null) {
            if (i % 2L == 0L) {
                return ref.getNativeSpace();
            }
            Object destroyFunc = ref.getDestroyFunc();
            return destroyFunc != null ? destroyFunc : GraalHPyHandle.NULL_HANDLE;
        }
        return GraalHPyHandle.NULL_HANDLE;
    }
}

