/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodesFactory;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.traceback.MaterializeLazyTracebackNode;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyExceptionInstanceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.formatting.ErrorMessageFormatter;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.IllegalFormatException;

public final class ExceptionNodes {
    private static Object nullToNone(Object obj) {
        return obj != null ? obj : PNone.NONE;
    }

    private static Object noValueToNone(Object obj) {
        return obj != PNone.NO_VALUE ? obj : PNone.NONE;
    }

    private static Object noneToNativeNull(Node node, Object obj) {
        return obj != PNone.NONE ? obj : PythonContext.get(node).getNativeNull();
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetArgsNode
    extends Node {
        public abstract void execute(Node var1, Object var2, PTuple var3);

        public static void executeUncached(Object e, PTuple argsTuple) {
            ExceptionNodesFactory.SetArgsNodeGen.getUncached().execute(null, e, argsTuple);
        }

        @Specialization
        static void doManaged(PBaseException exception, PTuple argsTuple) {
            exception.setArgs(argsTuple);
        }

        @Specialization(guards={"check.execute(inliningTarget, exception)"}, limit="1")
        static void doNative(Node inliningTarget, PythonAbstractNativeObject exception, PTuple argsTuple, @Cached PyExceptionInstanceCheckNode check, @Cached(inline=false) CStructAccess.WriteObjectNewRefNode writeObject) {
            writeObject.writeToObject(exception, CFields.PyBaseExceptionObject__args, argsTuple);
        }

        @Specialization
        static void doInterop(Node inliningTarget, AbstractTruffleException exception, PTuple argsTuple) {
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SET_PROPERTY_ON_INTEROP_EXCEPTION);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetArgsNode
    extends PNodeWithContext {
        public abstract PTuple execute(Node var1, Object var2);

        public static PTuple executeUncached(Object e) {
            return ExceptionNodesFactory.GetArgsNodeGen.getUncached().execute(null, e);
        }

        @CompilerDirectives.TruffleBoundary
        private static String getFormattedMessage(TruffleString format, Object ... args) {
            String jFormat = format.toJavaStringUncached();
            try {
                if (ErrorMessageFormatter.containsCustomSpecifier(jFormat)) {
                    return ErrorMessageFormatter.format(jFormat, args);
                }
                return String.format(jFormat, args);
            }
            catch (IllegalFormatException e) {
                return jFormat;
            }
        }

        @Specialization
        static PTuple doManaged(Node inliningTarget, PBaseException self, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @Cached InlinedConditionProfile nullArgsProfile, @Cached InlinedConditionProfile hasMessageFormat, @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode) {
            PTuple args = self.getArgs();
            if (nullArgsProfile.profile(inliningTarget, args == null)) {
                args = hasMessageFormat.profile(inliningTarget, !self.hasMessageFormat()) ? factory.createEmptyTuple() : factory.createTuple(new Object[]{fromJavaStringNode.execute(GetArgsNode.getFormattedMessage(self.getMessageFormat(), self.getMessageArgs()), PythonUtils.TS_ENCODING)});
                self.setArgs(args);
            }
            return args;
        }

        @Specialization(guards={"check.execute(inliningTarget, exception)"}, limit="1")
        static PTuple doNative(Node inliningTarget, PythonAbstractNativeObject exception, @Cached PyExceptionInstanceCheckNode check, @Cached(inline=false) CStructAccess.ReadObjectNode readObject) {
            return (PTuple)ExceptionNodes.noValueToNone(readObject.readFromObj(exception, CFields.PyBaseExceptionObject__args));
        }

        @Specialization
        static PTuple doInterop(AbstractTruffleException exception, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode) {
            assert (IsForeignObjectNode.executeUncached((Object)exception));
            try {
                TruffleString message;
                if (interop.hasExceptionMessage((Object)exception)) {
                    Object messageObject = interop.getExceptionMessage((Object)exception);
                    message = switchEncodingNode.execute((AbstractTruffleString)interop.asTruffleString(messageObject), PythonUtils.TS_ENCODING);
                } else {
                    message = StringLiterals.T_NO_MESSAGE;
                }
                if (interop.hasMetaObject((Object)exception)) {
                    return factory.createTuple(new Object[]{GetArgsNode.concat(GetArgsNode.getMetaObjectName((Object)exception), message)});
                }
                return factory.createTuple(new Object[]{message});
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public static TruffleString getMetaObjectName(Object self) {
            InteropLibrary interop = InteropLibrary.getUncached();
            try {
                Object metaObject = interop.getMetaObject(self);
                Object className = interop.getMetaQualifiedName(metaObject);
                return interop.asTruffleString(className);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString concat(TruffleString a, TruffleString b) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            sb.appendStringUncached(a);
            sb.appendStringUncached(StringLiterals.T_COLON_SPACE);
            sb.appendStringUncached(b);
            return sb.toStringUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetTracebackNode
    extends Node {
        public abstract void execute(Node var1, Object var2, Object var3);

        public static void executeUncached(Object e, Object value) {
            ExceptionNodesFactory.SetTracebackNodeGen.getUncached().execute(null, e, value);
        }

        @Specialization
        static void doManaged(PBaseException exception, PNone value) {
            exception.clearTraceback();
        }

        @Specialization
        static void doManaged(PBaseException exception, PTraceback value) {
            exception.setTraceback(value);
        }

        @Specialization(guards={"check.execute(inliningTarget, exception)"}, limit="1")
        static void doNative(Node inliningTarget, PythonAbstractNativeObject exception, Object value, @Cached PyExceptionInstanceCheckNode check, @Cached(inline=false) CStructAccess.WriteObjectNewRefNode writeObject) {
            writeObject.writeToObject(exception, CFields.PyBaseExceptionObject__traceback, ExceptionNodes.noneToNativeNull(inliningTarget, value));
        }

        @Specialization
        static void doInterop(Node inliningTarget, AbstractTruffleException exception, Object value) {
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SET_PROPERTY_ON_INTEROP_EXCEPTION);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class GetTracebackNode
    extends Node {
        public abstract Object execute(Node var1, Object var2);

        public static Object executeUncached(Object e) {
            return ExceptionNodesFactory.GetTracebackNodeGen.getUncached().execute(null, e);
        }

        @Specialization
        static Object doManaged(Node inliningTarget, PBaseException e, @Cached MaterializeLazyTracebackNode materializeLazyTracebackNode) {
            PTraceback result = null;
            if (e.getTraceback() != null) {
                result = materializeLazyTracebackNode.execute(inliningTarget, e.getTraceback());
            }
            return ExceptionNodes.nullToNone(result);
        }

        @Specialization(guards={"check.execute(inliningTarget, exception)"}, limit="1")
        static Object doNative(Node inliningTarget, PythonAbstractNativeObject exception, @Cached PyExceptionInstanceCheckNode check, @Cached(inline=false) CStructAccess.ReadObjectNode readObject) {
            return ExceptionNodes.noValueToNone(readObject.readFromObj(exception, CFields.PyBaseExceptionObject__traceback));
        }

        @Specialization
        static Object doForeign(AbstractTruffleException e) {
            return PNone.NONE;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetSuppressContextNode
    extends Node {
        public abstract void execute(Node var1, Object var2, boolean var3);

        public static void executeUncached(Object e, boolean value) {
            ExceptionNodesFactory.SetSuppressContextNodeGen.getUncached().execute(null, e, value);
        }

        @Specialization
        static void doManaged(PBaseException exception, boolean value) {
            exception.setSuppressContext(value);
        }

        @Specialization(guards={"check.execute(inliningTarget, exception)"}, limit="1")
        static void doNative(Node inliningTarget, PythonAbstractNativeObject exception, boolean value, @Cached PyExceptionInstanceCheckNode check, @Cached(inline=false) CStructAccess.WriteByteNode write) {
            write.writeToObject(exception, CFields.PyBaseExceptionObject__suppress_context, value ? (byte)1 : 0);
        }

        @Specialization
        static void doInterop(Node inliningTarget, AbstractTruffleException exception, boolean value) {
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SET_PROPERTY_ON_INTEROP_EXCEPTION);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetSuppressContextNode
    extends Node {
        public abstract boolean execute(Node var1, Object var2);

        public static boolean executeUncached(Object e) {
            return ExceptionNodesFactory.GetSuppressContextNodeGen.getUncached().execute(null, e);
        }

        @Specialization
        static boolean doManaged(PBaseException exception) {
            return exception.getSuppressContext();
        }

        @Specialization(guards={"check.execute(inliningTarget, exception)"}, limit="1")
        static boolean doNative(Node inliningTarget, PythonAbstractNativeObject exception, @Cached PyExceptionInstanceCheckNode check, @Cached(inline=false) CStructAccess.ReadByteNode read) {
            return read.readFromObj(exception, CFields.PyBaseExceptionObject__suppress_context) != 0;
        }

        @Specialization
        static boolean doInterop(Node inliningTarget, AbstractTruffleException exception) {
            return false;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class SetContextNode
    extends Node {
        public abstract void execute(Node var1, Object var2, Object var3);

        public static void executeUncached(Object e, Object value) {
            ExceptionNodesFactory.SetContextNodeGen.getUncached().execute(null, e, value);
        }

        @Specialization(guards={"isNone(value)"})
        static void doManaged(PBaseException exception, PNone value) {
            exception.setContext(null);
        }

        @Specialization(guards={"!isNone(value)"})
        static void doManaged(PBaseException exception, Object value) {
            exception.setContext(value);
        }

        @Specialization(guards={"check.execute(inliningTarget, exception)"}, limit="1")
        static void doNative(Node inliningTarget, PythonAbstractNativeObject exception, Object value, @Cached PyExceptionInstanceCheckNode check, @Cached(inline=false) CStructAccess.WriteObjectNewRefNode writeObject) {
            writeObject.writeToObject(exception, CFields.PyBaseExceptionObject__context, ExceptionNodes.noneToNativeNull(inliningTarget, value));
        }

        @Specialization
        static void doInterop(Node inliningTarget, AbstractTruffleException exception, Object value) {
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SET_PROPERTY_ON_INTEROP_EXCEPTION);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetContextNode
    extends Node {
        public abstract Object execute(Node var1, Object var2);

        public static Object executeUncached(Object e) {
            return ExceptionNodesFactory.GetContextNodeGen.getUncached().execute(null, e);
        }

        @Specialization
        static Object doManaged(PBaseException exception) {
            return ExceptionNodes.nullToNone(exception.getContext());
        }

        @Specialization(guards={"check.execute(inliningTarget, exception)"}, limit="1")
        static Object doNative(Node inliningTarget, PythonAbstractNativeObject exception, @Cached PyExceptionInstanceCheckNode check, @Cached(inline=false) CStructAccess.ReadObjectNode readObject) {
            return ExceptionNodes.noValueToNone(readObject.readFromObj(exception, CFields.PyBaseExceptionObject__context));
        }

        @Specialization
        static Object doInterop(Node inliningTarget, AbstractTruffleException exception) {
            return PNone.NONE;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class SetCauseNode
    extends Node {
        public abstract void execute(Node var1, Object var2, Object var3);

        public static void executeUncached(Object e, Object value) {
            ExceptionNodesFactory.SetCauseNodeGen.getUncached().execute(null, e, value);
        }

        @Specialization(guards={"isNone(value)"})
        static void doManaged(PBaseException exception, PNone value) {
            exception.setCause(null);
        }

        @Specialization(guards={"!isNone(value)"})
        static void doManaged(PBaseException exception, Object value) {
            exception.setCause(value);
        }

        @Specialization(guards={"check.execute(inliningTarget, exception)"}, limit="1")
        static void doNative(Node inliningTarget, PythonAbstractNativeObject exception, Object value, @Cached PyExceptionInstanceCheckNode check, @Cached(inline=false) CStructAccess.WriteObjectNewRefNode writeObject, @Cached(inline=false) CStructAccess.WriteByteNode writeByte) {
            writeObject.writeToObject(exception, CFields.PyBaseExceptionObject__cause, ExceptionNodes.noneToNativeNull(inliningTarget, value));
            writeByte.writeToObject(exception, CFields.PyBaseExceptionObject__suppress_context, (byte)1);
        }

        @Specialization
        static void doInterop(Node inliningTarget, AbstractTruffleException exception, Object value) {
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SET_PROPERTY_ON_INTEROP_EXCEPTION);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetCauseNode
    extends Node {
        public abstract Object execute(Node var1, Object var2);

        public static Object executeUncached(Object e) {
            return ExceptionNodesFactory.GetCauseNodeGen.getUncached().execute(null, e);
        }

        @Specialization
        static Object doManaged(PBaseException exception) {
            return ExceptionNodes.nullToNone(exception.getCause());
        }

        @Specialization(guards={"check.execute(inliningTarget, exception)"}, limit="1")
        static Object doNative(Node inliningTarget, PythonAbstractNativeObject exception, @Cached PyExceptionInstanceCheckNode check, @Cached(inline=false) CStructAccess.ReadObjectNode readObject) {
            return ExceptionNodes.noValueToNone(readObject.readFromObj(exception, CFields.PyBaseExceptionObject__cause));
        }

        @Specialization
        static Object doInterop(Node inliningTarget, AbstractTruffleException exception) {
            return PNone.NONE;
        }
    }
}

