/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.function;

import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;

public final class PArguments {
    private static final int INDEX_VARIABLE_ARGUMENTS = 0;
    private static final int INDEX_KEYWORD_ARGUMENTS = 1;
    private static final int INDEX_GENERATOR_FRAME = 2;
    private static final int INDEX_SPECIAL_ARGUMENT = 3;
    private static final int INDEX_GLOBALS_ARGUMENT = 4;
    private static final int INDEX_CLOSURE = 5;
    private static final int INDEX_CALLER_FRAME_INFO = 6;
    private static final int INDEX_CURRENT_FRAME_INFO = 7;
    private static final int INDEX_CURRENT_EXCEPTION = 8;
    public static final int USER_ARGUMENTS_OFFSET = 9;

    public static boolean isPythonFrame(Frame frame) {
        return frame != null && PArguments.isPythonFrame(frame.getArguments());
    }

    public static boolean isPythonFrame(Object[] frameArgs) {
        return frameArgs.length >= 9 && frameArgs[1] instanceof PKeyword[];
    }

    public static Object[] withGlobals(PythonObject globals) {
        Object[] arguments = PArguments.create();
        PArguments.setGlobals(arguments, globals);
        return arguments;
    }

    public static Object[] create() {
        return PArguments.create(0);
    }

    public static Object[] create(int userArgumentLength) {
        Object[] initialArguments = new Object[9 + userArgumentLength];
        initialArguments[0] = PythonUtils.EMPTY_OBJECT_ARRAY;
        initialArguments[1] = PKeyword.EMPTY_KEYWORDS;
        return initialArguments;
    }

    public static void setVariableArguments(Object[] arguments, Object ... variableArguments) {
        arguments[0] = variableArguments;
    }

    public static Object[] getVariableArguments(Frame frame) {
        return PArguments.getVariableArguments(frame.getArguments());
    }

    public static Object[] getVariableArguments(Object[] frame) {
        return (Object[])frame[0];
    }

    public static void setKeywordArguments(Object[] arguments, PKeyword[] keywordArguments) {
        arguments[1] = keywordArguments;
    }

    public static PKeyword[] getKeywordArguments(Frame frame) {
        return PArguments.getKeywordArguments(frame.getArguments());
    }

    public static PKeyword[] getKeywordArguments(Object[] frame) {
        return (PKeyword[])frame[1];
    }

    public static void setSpecialArgument(Object[] arguments, Object value) {
        arguments[3] = value;
    }

    public static Object getSpecialArgument(Frame frame) {
        return PArguments.getSpecialArgument(frame.getArguments());
    }

    public static Object getSpecialArgument(Object[] arguments) {
        return arguments[3];
    }

    public static void setGlobals(Object[] arguments, PythonObject globals) {
        arguments[4] = globals;
    }

    public static PythonObject getGlobals(Object[] arguments) {
        return (PythonObject)arguments[4];
    }

    public static PythonObject getGlobals(Frame frame) {
        return PArguments.getGlobals(frame.getArguments());
    }

    public static PythonObject getGlobalsSafe(Frame frame) {
        if (frame.getArguments()[4] instanceof PythonObject) {
            return PArguments.getGlobals(frame);
        }
        return null;
    }

    public static PFrame.Reference getCallerFrameInfo(Frame frame) {
        return PArguments.getCallerFrameInfo(frame.getArguments());
    }

    public static PFrame.Reference getCallerFrameInfo(Object[] args) {
        return (PFrame.Reference)args[6];
    }

    public static void setCallerFrameInfo(Object[] arguments, PFrame.Reference info) {
        arguments[6] = info;
    }

    public static PFrame.Reference getCurrentFrameInfo(Frame frame) {
        return PArguments.getCurrentFrameInfo(frame.getArguments());
    }

    public static PFrame.Reference getCurrentFrameInfo(Object[] args) {
        return (PFrame.Reference)args[7];
    }

    public static void setCurrentFrameInfo(Frame frame, PFrame.Reference info) {
        PArguments.setCurrentFrameInfo(frame.getArguments(), info);
    }

    public static void setCurrentFrameInfo(Object[] arguments, PFrame.Reference info) {
        arguments[7] = info;
    }

    public static AbstractTruffleException getException(Object[] arguments) {
        return (AbstractTruffleException)((Object)PArguments.getExceptionUnchecked(arguments));
    }

    public static AbstractTruffleException getException(Frame frame) {
        return (AbstractTruffleException)((Object)PArguments.getExceptionUnchecked(frame.getArguments()));
    }

    public static Object getExceptionUnchecked(Object[] arguments) {
        return arguments[8];
    }

    public static void setException(Frame frame, AbstractTruffleException exc) {
        PArguments.setException(frame.getArguments(), exc);
    }

    public static void setException(Object[] arguments, AbstractTruffleException exc) {
        PArguments.setExceptionUnchecked(arguments, (Object)exc);
    }

    public static void setExceptionUnchecked(Object[] arguments, Object exc) {
        arguments[8] = exc;
    }

    public static void setClosure(Object[] arguments, PCell[] closure) {
        arguments[5] = closure;
    }

    public static PCell[] getClosure(Object[] arguments) {
        return (PCell[])arguments[5];
    }

    public static void setOSRFrame(Object[] arguments, VirtualFrame parentFrame) {
        CompilerAsserts.neverPartOfCompilation();
        arguments[0] = parentFrame;
    }

    public static Frame getOSRFrame(Object[] arguments) {
        return (Frame)arguments[0];
    }

    public static PCell[] getClosure(Frame frame) {
        return PArguments.getClosure(frame.getArguments());
    }

    public static void setArgument(Object[] arguments, int index, Object value) {
        arguments[9 + index] = value;
    }

    public static Object getArgument(Object[] arguments, int index) {
        int argIdx = 9 + index;
        if (argIdx < arguments.length) {
            return arguments[argIdx];
        }
        return null;
    }

    public static Object getArgument(Frame frame, int index) {
        return PArguments.getArgument(frame.getArguments(), index);
    }

    public static int getUserArgumentLength(VirtualFrame frame) {
        return frame.getArguments().length - 9;
    }

    public static int getUserArgumentLength(Object[] arguments) {
        return arguments.length - 9;
    }

    public static MaterializedFrame getGeneratorFrame(Object[] arguments) {
        return (MaterializedFrame)arguments[2];
    }

    public static MaterializedFrame getGeneratorFrame(Frame frame) {
        return PArguments.getGeneratorFrame(frame.getArguments());
    }

    public static MaterializedFrame getGeneratorFrameSafe(Frame frame) {
        return PArguments.getGeneratorFrameSafe(frame.getArguments());
    }

    public static MaterializedFrame getGeneratorFrameSafe(Object[] arguments) {
        if (arguments[2] instanceof MaterializedFrame) {
            return PArguments.getGeneratorFrame(arguments);
        }
        return null;
    }

    public static void setGeneratorFrame(Object[] arguments, MaterializedFrame generatorFrame) {
        arguments[2] = generatorFrame;
    }

    public static PFunction getGeneratorFunction(Object[] arguments) {
        return (PFunction)arguments[2];
    }

    public static void setGeneratorFunction(Object[] arguments, PFunction generatorFunction) {
        arguments[2] = generatorFunction;
    }

    public static void synchronizeArgs(Frame frameToMaterialize, PFrame escapedFrame) {
        Object[] arguments = frameToMaterialize.getArguments();
        Object[] copiedArgs = new Object[arguments.length];
        PArguments.setSpecialArgument(copiedArgs, PArguments.getSpecialArgument(arguments));
        PArguments.setGlobals(copiedArgs, PArguments.getGlobals(arguments));
        PArguments.setClosure(copiedArgs, PArguments.getClosure(arguments));
        PythonUtils.arraycopy(arguments, 9, copiedArgs, 9, PArguments.getUserArgumentLength(arguments));
        escapedFrame.setArguments(copiedArgs);
    }
}

