/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.PProduct;
import com.oracle.graal.python.builtins.objects.itertools.ProductBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PProduct})
public final class ProductBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ProductBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(VirtualFrame frame, PProduct self, Object state, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetItem getItemNode, @Cached InlinedLoopConditionProfile loopProfile, @Cached PyLongAsIntNode pyLongAsIntNode, @Cached InlinedBranchProfile stoppedProfile, @Cached InlinedConditionProfile indexProfile) {
            Object[][] gears = self.getGears();
            Object[] lst = new Object[gears.length];
            int[] indices = self.getIndices();
            loopProfile.profileCounted(inliningTarget, (long)gears.length);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < gears.length)) {
                Object o = getItemNode.execute((Frame)frame, inliningTarget, state, i);
                int index = pyLongAsIntNode.execute((Frame)frame, inliningTarget, o);
                int gearSize = gears[i].length;
                if (indices == null || gearSize == 0) {
                    stoppedProfile.enter(inliningTarget);
                    self.setStopped(true);
                    return PNone.NONE;
                }
                if (indexProfile.profile(inliningTarget, index < 0)) {
                    index = 0;
                } else if (index > gearSize - 1) {
                    index = gearSize - 1;
                }
                indices[i] = index;
                lst[i] = gears[i][index];
                ++i;
            }
            self.setLst(lst);
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PProduct self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile stoppedProfile, @Cached InlinedConditionProfile noLstProfile, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory) {
            Object type = getClassNode.execute(inliningTarget, self);
            if (stoppedProfile.profile(inliningTarget, self.isStopped())) {
                PTuple empty = factory.createEmptyTuple();
                return factory.createTuple(new Object[]{type, factory.createTuple(new Object[]{empty})});
            }
            PTuple gearTuples = ReduceNode.createGearTuple(self, factory);
            if (noLstProfile.profile(inliningTarget, self.getLst() == null)) {
                return factory.createTuple(new Object[]{type, gearTuples});
            }
            PTuple indicesTuple = factory.createTuple(PythonUtils.arrayCopyOf(self.getIndices(), self.getIndices().length));
            return factory.createTuple(new Object[]{type, gearTuples, indicesTuple});
        }

        private static PTuple createGearTuple(PProduct self, PythonObjectFactory factory) {
            Object[] lists = new PList[self.getGears().length];
            for (int i = 0; i < lists.length; ++i) {
                lists[i] = factory.createList(self.getGears()[i]);
            }
            return factory.createTuple(lists);
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"!self.isStopped()", "!hasLst(self)"})
        static Object next(PProduct self, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            Object[] lst = new Object[self.getGears().length];
            loopProfile.profileCounted(inliningTarget, (long)lst.length);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < lst.length)) {
                lst[i] = self.getGears()[i][0];
                ++i;
            }
            self.setLst(lst);
            return factory.createTuple(lst);
        }

        @Specialization(guards={"!self.isStopped()", "hasLst(self)"})
        static Object next(PProduct self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile gearsProfile, @Cached InlinedConditionProfile indexProfile, @Cached InlinedBranchProfile wasStoppedProfile, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile, @Cached InlinedBranchProfile doneProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object[][] gears = self.getGears();
            int x = gears.length - 1;
            if (gearsProfile.profile(inliningTarget, x >= 0)) {
                Object[] gear = gears[x];
                int[] indices = self.getIndices();
                int index = indices[x] + 1;
                if (indexProfile.profile(inliningTarget, index < gear.length)) {
                    self.getLst()[x] = gear[index];
                    indices[x] = index;
                } else {
                    NextNode.rotatePreviousGear(inliningTarget, self, loopProfile, doneProfile);
                }
            } else {
                self.setStopped(true);
            }
            if (self.isStopped()) {
                wasStoppedProfile.enter(inliningTarget);
                throw raiseNode.get(inliningTarget).raiseStopIteration();
            }
            Object[] ret = new Object[self.getLst().length];
            PythonUtils.arraycopy(self.getLst(), 0, ret, 0, ret.length);
            return factory.createTuple(ret);
        }

        @Specialization(guards={"self.isStopped()"})
        static Object nextStopped(PProduct self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raiseStopIteration();
        }

        private static void rotatePreviousGear(Node inliningTarget, PProduct self, InlinedLoopConditionProfile loopProfile, InlinedBranchProfile doneProfile) {
            Object[] lst = self.getLst();
            Object[][] gears = self.getGears();
            int x = gears.length - 1;
            lst[x] = gears[x][0];
            int[] indices = self.getIndices();
            indices[x] = 0;
            --x;
            while (loopProfile.profile(inliningTarget, x >= 0)) {
                int index = indices[x] + 1;
                Object[] gear = gears[x];
                if (index < gear.length) {
                    doneProfile.enter(inliningTarget);
                    lst[x] = gear[index];
                    indices[x] = index;
                    return;
                }
                lst[x] = gear[0];
                indices[x] = 0;
                --x;
            }
            self.setLst(null);
            self.setStopped(true);
        }

        protected static boolean hasLst(PProduct self) {
            return self.getLst() != null;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PProduct self) {
            return self;
        }
    }
}

