/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.namespace;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.namespace.PSimpleNamespace;
import com.oracle.graal.python.builtins.objects.namespace.SimpleNamespaceBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.graalvm.collections.Pair;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSimpleNamespace})
public final class SimpleNamespaceBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SimpleNamespaceBuiltinsFactory.getFactories();
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SimpleNamespaceReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString T_RECURSE = PythonUtils.tsLiteral("...)");
        private static final TruffleString T_NAMESPACE = PythonUtils.tsLiteral("namespace");

        SimpleNamespaceReprNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public static Object repr(PSimpleNamespace ns, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile clsProfile, @Cached TypeNodes.GetNameNode getNameNode, @Cached GetOrCreateDictNode getDict, @Cached(value="create(3)") ForEachNSRepr consumerNode, @Cached HashingStorageNodes.HashingStorageForEach forEachNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            Object klass = getClassNode.execute(inliningTarget, ns);
            TruffleString name = clsProfile.profileClass(inliningTarget, klass, PythonBuiltinClassType.PSimpleNamespace) ? T_NAMESPACE : getNameNode.execute(inliningTarget, klass);
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            appendStringNode.execute(sb, (AbstractTruffleString)name);
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LPAREN);
            PythonContext ctxt = PythonContext.get(forEachNode);
            if (!ctxt.reprEnter(ns)) {
                appendStringNode.execute(sb, (AbstractTruffleString)T_RECURSE);
                return toStringNode.execute(sb);
            }
            try {
                HashingStorage dictStorage = getDict.execute(inliningTarget, ns).getDictStorage();
                NSReprState state = new NSReprState(dictStorage);
                forEachNode.execute(null, inliningTarget, dictStorage, consumerNode, state);
                state.appendToTruffleStringBuilder(sb, appendStringNode);
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RPAREN);
                TruffleString truffleString = toStringNode.execute(sb);
                return truffleString;
            }
            finally {
                ctxt.reprLeave(ns);
            }
        }

        @CompilerDirectives.ValueType
        protected static final class NSReprState {
            private final HashingStorage dictStorage;
            private final List<Pair<TruffleString, TruffleString>> items;

            @CompilerDirectives.TruffleBoundary
            NSReprState(HashingStorage dictStorage) {
                this.dictStorage = dictStorage;
                this.items = new ArrayList<Pair<TruffleString, TruffleString>>();
            }

            @CompilerDirectives.TruffleBoundary
            private void sortItemsByKey() {
                this.items.sort(Comparator.comparing(Pair::getLeft, StringUtils::compareStringsUncached));
            }

            public void appendToTruffleStringBuilder(TruffleStringBuilder sb, TruffleStringBuilder.AppendStringNode appendStringNode) {
                this.sortItemsByKey();
                for (int i = 0; i < this.items.size(); ++i) {
                    Pair<TruffleString, TruffleString> item = this.items.get(i);
                    if (i > 0) {
                        appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                    }
                    appendStringNode.execute(sb, (AbstractTruffleString)item.getLeft());
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_EQ);
                    appendStringNode.execute(sb, (AbstractTruffleString)item.getRight());
                }
            }
        }

        @ImportStatic(value={PGuards.class})
        static abstract class ForEachNSRepr
        extends HashingStorageNodes.HashingStorageForEachCallback<NSReprState> {
            private final int limit;

            protected ForEachNSRepr(int limit) {
                this.limit = limit;
            }

            protected final int getLimit() {
                return this.limit;
            }

            protected static TruffleString getReprString(Node inliningTarget, Object obj, LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode reprNode, CastToTruffleStringNode castStr, PRaiseNode raiseNode) {
                Object reprObj = reprNode.executeObject(obj, SpecialMethodNames.T___REPR__);
                try {
                    return castStr.execute(inliningTarget, reprObj);
                }
                catch (CannotCastException e) {
                    throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.RETURNED_NON_STRING, "__repr__", reprObj);
                }
            }

            @Override
            public abstract NSReprState execute(Frame var1, Node var2, HashingStorage var3, HashingStorageNodes.HashingStorageIterator var4, NSReprState var5);

            @Specialization
            public static NSReprState doPStringKey(Node node, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, NSReprState state, @Bind(value="this") Node inliningTarget, @Cached LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode valueReprNode, @Cached CastToTruffleStringNode castStrKey, @Cached CastToTruffleStringNode castStrValue, @Cached PRaiseNode raiseNode, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
                Object keyObj = itKey.execute(inliningTarget, storage, it);
                if (PGuards.isString(keyObj)) {
                    TruffleString key = castStrKey.execute(inliningTarget, keyObj);
                    TruffleString valueReprString = ForEachNSRepr.getReprString(inliningTarget, getItem.execute(inliningTarget, state.dictStorage, key), valueReprNode, castStrValue, raiseNode);
                    ForEachNSRepr.appendItem(state, key, valueReprString);
                }
                return state;
            }

            @CompilerDirectives.TruffleBoundary
            private static void appendItem(NSReprState state, TruffleString key, TruffleString valueReprString) {
                state.items.add((Pair<TruffleString, TruffleString>)Pair.create((Object)key, (Object)valueReprString));
            }
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class SimpleNamespaceReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PSimpleNamespace self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached GetOrCreateDictNode getDict, @Cached PythonObjectFactory factory) {
            PTuple args = factory.createEmptyTuple();
            PDict dict = getDict.execute(inliningTarget, self);
            return factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, self), args, dict});
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SimpleNamespaceEqNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object eq(VirtualFrame frame, PSimpleNamespace self, PSimpleNamespace other, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateDictNode getDict, @Cached DictBuiltins.EqNode eqNode) {
            return eqNode.execute(frame, getDict.execute(inliningTarget, self), getDict.execute(inliningTarget, other));
        }

        @Fallback
        static PNotImplemented doGeneric(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class SimpleNamespaceDictNode
    extends PythonUnaryBuiltinNode {
        SimpleNamespaceDictNode() {
        }

        @Specialization
        Object getDict(PSimpleNamespace self, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateDictNode getDict) {
            return getDict.execute(inliningTarget, self);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class SimpleNamespaceInitNode
    extends PythonVarargsBuiltinNode {
        protected SimpleNamespaceInitNode() {
        }

        @Specialization
        Object init(PSimpleNamespace self, Object[] args, PKeyword[] kwargs, @Cached WriteAttributeToPythonObjectNode writeAttrNode) {
            if (args.length > 0) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.NO_POSITIONAL_ARGUMENTS_EXPECTED);
            }
            for (PKeyword keyword : kwargs) {
                writeAttrNode.execute(self, keyword.getName(), keyword.getValue());
            }
            return PNone.NONE;
        }
    }
}

