/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.annotations.GenerateEnumConstants;

@GenerateEnumConstants(type=GenerateEnumConstants.Type.BYTE)
public final class OpCodes
extends Enum<OpCodes> {
    public static final /* enum */ OpCodes POP_TOP = new OpCodes(0, 1, 0);
    public static final /* enum */ OpCodes ROT_TWO = new OpCodes(0, 2, 2);
    public static final /* enum */ OpCodes ROT_THREE = new OpCodes(0, 3, 3);
    public static final /* enum */ OpCodes ROT_N = new OpCodes(1, (oparg, followingArgs, withJump) -> oparg, (oparg, followingArgs, withJump) -> oparg);
    public static final /* enum */ OpCodes DUP_TOP = new OpCodes(0, 1, 2);
    public static final /* enum */ OpCodes NOP = new OpCodes(0, 0, 0);
    public static final /* enum */ OpCodes UNARY_OP = new OpCodes(1, 1, 1);
    public static final /* enum */ OpCodes BINARY_OP = new OpCodes(1, 2, 1);
    public static final /* enum */ OpCodes BINARY_SUBSCR = new OpCodes(0, 2, 1);
    public static final /* enum */ OpCodes STORE_SUBSCR = new OpCodes(0, 3, 0);
    public static final /* enum */ OpCodes DELETE_SUBSCR = new OpCodes(0, 2, 0);
    public static final /* enum */ OpCodes GET_ITER = new OpCodes(0, 1, 1);
    public static final /* enum */ OpCodes GET_YIELD_FROM_ITER = new OpCodes(0, 1, 1);
    public static final /* enum */ OpCodes GET_AWAITABLE = new OpCodes(0, 1, 1);
    public static final /* enum */ OpCodes GET_AITER = new OpCodes(0, 1, 1);
    public static final /* enum */ OpCodes GET_ANEXT = new OpCodes(0, 1, 1);
    public static final /* enum */ OpCodes LOAD_BUILD_CLASS = new OpCodes(0, 0, 1);
    public static final /* enum */ OpCodes LOAD_ASSERTION_ERROR = new OpCodes(0, 0, 1);
    public static final /* enum */ OpCodes RETURN_VALUE = new OpCodes(0, 1, 0);
    public static final /* enum */ OpCodes LOAD_NAME = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes STORE_NAME = new OpCodes(1, 1, 0);
    public static final /* enum */ OpCodes DELETE_NAME = new OpCodes(1, 0, 0);
    public static final /* enum */ OpCodes LOAD_ATTR = new OpCodes(1, 1, 1);
    public static final /* enum */ OpCodes LOAD_METHOD = new OpCodes(1, 1, 2);
    public static final /* enum */ OpCodes STORE_ATTR = new OpCodes(1, 2, 0);
    public static final /* enum */ OpCodes DELETE_ATTR = new OpCodes(1, 1, 0);
    public static final /* enum */ OpCodes LOAD_GLOBAL = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes STORE_GLOBAL = new OpCodes(1, 1, 0);
    public static final /* enum */ OpCodes DELETE_GLOBAL = new OpCodes(1, 0, 0);
    public static final /* enum */ OpCodes LOAD_CONST = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes LOAD_FAST = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes STORE_FAST = new OpCodes(1, 1, 0);
    public static final /* enum */ OpCodes DELETE_FAST = new OpCodes(1, 0, 0);
    public static final /* enum */ OpCodes LOAD_DEREF = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes STORE_DEREF = new OpCodes(1, 1, 0);
    public static final /* enum */ OpCodes DELETE_DEREF = new OpCodes(1, 0, 0);
    public static final /* enum */ OpCodes LOAD_CLASSDEREF = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes RAISE_VARARGS = new OpCodes(1, (oparg, followingArgs, withJump) -> oparg, 0);
    public static final /* enum */ OpCodes BUILD_SLICE = new OpCodes(1, (oparg, followingArgs, withJump) -> oparg, 1);
    public static final /* enum */ OpCodes FORMAT_VALUE = new OpCodes(1, (oparg, followingArgs, withJump) -> (oparg & 4) == 4 ? 2 : 1, 1);
    public static final /* enum */ OpCodes EXTENDED_ARG = new OpCodes(1, 0, 0);
    public static final /* enum */ OpCodes IMPORT_NAME = new OpCodes(1, 2, 1);
    public static final /* enum */ OpCodes IMPORT_FROM = new OpCodes(1, 1, 2);
    public static final /* enum */ OpCodes IMPORT_STAR = new OpCodes(1, 1, 0);
    public static final /* enum */ OpCodes PRINT_EXPR = new OpCodes(0, 1, 0);
    public static final /* enum */ OpCodes SETUP_ANNOTATIONS = new OpCodes(0, 0, 0);
    public static final /* enum */ OpCodes MATCH_SEQUENCE = new OpCodes(0, 0, 1);
    public static final /* enum */ OpCodes MATCH_MAPPING = new OpCodes(0, 0, 1);
    public static final /* enum */ OpCodes MATCH_CLASS = new OpCodes(1, 3, 2);
    public static final /* enum */ OpCodes MATCH_KEYS = new OpCodes(0, 2, 4);
    public static final /* enum */ OpCodes COPY_DICT_WITHOUT_KEYS = new OpCodes(0, 1, 1);
    public static final /* enum */ OpCodes GET_LEN = new OpCodes(0, 0, 1);
    public static final /* enum */ OpCodes LOAD_NONE = new OpCodes(0, 0, 1);
    public static final /* enum */ OpCodes LOAD_ELLIPSIS = new OpCodes(0, 0, 1);
    public static final /* enum */ OpCodes LOAD_TRUE = new OpCodes(0, 0, 1);
    public static final /* enum */ OpCodes LOAD_FALSE = new OpCodes(0, 0, 1);
    public static final /* enum */ OpCodes LOAD_BYTE = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes LOAD_INT = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes LOAD_LONG = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes LOAD_DOUBLE = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes LOAD_BIGINT = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes LOAD_STRING = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes LOAD_BYTES = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes LOAD_COMPLEX = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes LOAD_CONST_COLLECTION = new OpCodes(2, 0, 1);
    public static final /* enum */ OpCodes CALL_METHOD_VARARGS = new OpCodes(0, 2, 1);
    public static final /* enum */ OpCodes CALL_METHOD = new OpCodes(1, (oparg, followingArgs, withJump) -> oparg + 2, 1);
    public static final /* enum */ OpCodes CALL_FUNCTION = new OpCodes(1, (oparg, followingArgs, withJump) -> oparg + 1, 1);
    public static final /* enum */ OpCodes CALL_COMPREHENSION = new OpCodes(0, 2, 1);
    public static final /* enum */ OpCodes CALL_FUNCTION_KW = new OpCodes(0, 3, 1);
    public static final /* enum */ OpCodes CALL_FUNCTION_VARARGS = new OpCodes(0, 2, 1);
    public static final /* enum */ OpCodes UNPACK_SEQUENCE = new OpCodes(1, 1, (oparg, followingArgs, withJump) -> oparg);
    public static final /* enum */ OpCodes UNPACK_EX = new OpCodes(2, 1, (oparg, followingArgs, withJump) -> oparg + 1 + Byte.toUnsignedInt(followingArgs[0]));
    public static final /* enum */ OpCodes FOR_ITER = new OpCodes(1, 1, (oparg, followingArgs, withJump) -> withJump ? 0 : 2);
    public static final /* enum */ OpCodes JUMP_FORWARD = new OpCodes(1, 0, 0);
    public static final /* enum */ OpCodes JUMP_BACKWARD = new OpCodes(1, 0, 0);
    public static final /* enum */ OpCodes JUMP_IF_FALSE_OR_POP = new OpCodes(3, (oparg, followingArgs, withJump) -> withJump ? 0 : 1, 0);
    public static final /* enum */ OpCodes JUMP_IF_TRUE_OR_POP = new OpCodes(3, (oparg, followingArgs, withJump) -> withJump ? 0 : 1, 0);
    public static final /* enum */ OpCodes POP_AND_JUMP_IF_FALSE = new OpCodes(3, 1, 0);
    public static final /* enum */ OpCodes POP_AND_JUMP_IF_TRUE = new OpCodes(3, 1, 0);
    public static final /* enum */ OpCodes LOAD_CLOSURE = new OpCodes(1, 0, 1);
    public static final /* enum */ OpCodes CLOSURE_FROM_STACK = new OpCodes(1, (oparg, followingArgs, withJump) -> oparg, 1);
    public static final /* enum */ OpCodes MAKE_FUNCTION = new OpCodes(2, (oparg, followingArgs, withJump) -> Integer.bitCount(followingArgs[0]), 1);
    public static final /* enum */ OpCodes COLLECTION_FROM_STACK = new OpCodes(1, (oparg, followingArgs, withJump) -> CollectionBits.elementCount(oparg), 1);
    public static final /* enum */ OpCodes COLLECTION_ADD_STACK = new OpCodes(1, (oparg, followingArgs, withJump) -> CollectionBits.elementCount(oparg) + 1, 1);
    public static final /* enum */ OpCodes COLLECTION_ADD_COLLECTION = new OpCodes(1, 2, 1);
    public static final /* enum */ OpCodes COLLECTION_FROM_COLLECTION = new OpCodes(1, 1, 1);
    public static final /* enum */ OpCodes TUPLE_FROM_LIST = new OpCodes(0, 1, 1);
    public static final /* enum */ OpCodes FROZENSET_FROM_LIST = new OpCodes(0, 1, 1);
    public static final /* enum */ OpCodes ADD_TO_COLLECTION = new OpCodes(1, (oparg, followingArgs, withJump) -> CollectionBits.collectionKind(oparg) == 128 ? 2 : 1, 0);
    public static final /* enum */ OpCodes KWARGS_DICT_MERGE = new OpCodes(0, 2, 1);
    public static final /* enum */ OpCodes MAKE_KEYWORD = new OpCodes(1, 1, 1);
    public static final /* enum */ OpCodes MATCH_EXC_OR_JUMP = new OpCodes(3, 2, 1);
    public static final /* enum */ OpCodes PUSH_EXC_INFO = new OpCodes(0, 1, 2);
    public static final /* enum */ OpCodes POP_EXCEPT = new OpCodes(0, 1, 0);
    public static final /* enum */ OpCodes END_EXC_HANDLER = new OpCodes(0, 2, 0);
    public static final /* enum */ OpCodes UNWRAP_EXC = new OpCodes(0, 1, 1);
    public static final /* enum */ OpCodes YIELD_VALUE = new OpCodes(0, 1, 0);
    public static final /* enum */ OpCodes ASYNCGEN_WRAP = new OpCodes(0, 1, 1);
    public static final /* enum */ OpCodes RESUME_YIELD = new OpCodes(0, 0, 1);
    public static final /* enum */ OpCodes SEND = new OpCodes(1, 2, (oparg, followingArgs, withJump) -> withJump ? 1 : 2);
    public static final /* enum */ OpCodes THROW = new OpCodes(1, 2, (oparg, followingArgs, withJump) -> withJump ? 1 : 2);
    public static final /* enum */ OpCodes END_ASYNC_FOR = new OpCodes(0, 3, 0);
    public static final /* enum */ OpCodes SETUP_WITH = new OpCodes(0, 1, 3);
    public static final /* enum */ OpCodes EXIT_WITH = new OpCodes(0, 3, 0);
    public static final /* enum */ OpCodes SETUP_AWITH = new OpCodes(0, 1, 3);
    public static final /* enum */ OpCodes GET_AEXIT_CORO = new OpCodes(0, 3, 2);
    public static final /* enum */ OpCodes EXIT_AWITH = new OpCodes(0, 2, 0);
    public static final /* enum */ OpCodes LOAD_TRUE_O = new OpCodes(LOAD_TRUE, 0, 1);
    public static final /* enum */ OpCodes LOAD_TRUE_B = new OpCodes(LOAD_TRUE, 0, 16, LOAD_TRUE_O);
    public static final /* enum */ OpCodes LOAD_FALSE_O = new OpCodes(LOAD_FALSE, 0, 1);
    public static final /* enum */ OpCodes LOAD_FALSE_B = new OpCodes(LOAD_FALSE, 0, 16, LOAD_FALSE_O);
    public static final /* enum */ OpCodes LOAD_BYTE_O = new OpCodes(LOAD_BYTE, 0, 1);
    public static final /* enum */ OpCodes LOAD_BYTE_I = new OpCodes(LOAD_BYTE, 0, 2, LOAD_BYTE_O);
    public static final /* enum */ OpCodes LOAD_INT_O = new OpCodes(LOAD_INT, 0, 1);
    public static final /* enum */ OpCodes LOAD_INT_I = new OpCodes(LOAD_INT, 0, 2, LOAD_INT_O);
    public static final /* enum */ OpCodes LOAD_LONG_O = new OpCodes(LOAD_LONG, 0, 1);
    public static final /* enum */ OpCodes LOAD_LONG_L = new OpCodes(LOAD_LONG, 0, 4, LOAD_LONG_O);
    public static final /* enum */ OpCodes LOAD_DOUBLE_O = new OpCodes(LOAD_DOUBLE, 0, 1);
    public static final /* enum */ OpCodes LOAD_DOUBLE_D = new OpCodes(LOAD_DOUBLE, 0, 8, LOAD_DOUBLE_O);
    public static final /* enum */ OpCodes LOAD_FAST_O = new OpCodes(LOAD_FAST, 0, 1);
    public static final /* enum */ OpCodes LOAD_FAST_I_BOX = new OpCodes(LOAD_FAST, 0, 1);
    public static final /* enum */ OpCodes LOAD_FAST_I = new OpCodes(LOAD_FAST, 0, 2, LOAD_FAST_I_BOX);
    public static final /* enum */ OpCodes LOAD_FAST_L_BOX = new OpCodes(LOAD_FAST, 0, 1);
    public static final /* enum */ OpCodes LOAD_FAST_L = new OpCodes(LOAD_FAST, 0, 4, LOAD_FAST_L_BOX);
    public static final /* enum */ OpCodes LOAD_FAST_D_BOX = new OpCodes(LOAD_FAST, 0, 1);
    public static final /* enum */ OpCodes LOAD_FAST_D = new OpCodes(LOAD_FAST, 0, 8, LOAD_FAST_D_BOX);
    public static final /* enum */ OpCodes LOAD_FAST_B_BOX = new OpCodes(LOAD_FAST, 0, 1);
    public static final /* enum */ OpCodes LOAD_FAST_B = new OpCodes(LOAD_FAST, 0, 16, LOAD_FAST_B_BOX);
    public static final /* enum */ OpCodes STORE_FAST_O = new OpCodes(STORE_FAST, 1, 0);
    public static final /* enum */ OpCodes STORE_FAST_UNBOX_I = new OpCodes(STORE_FAST, 1, 0);
    public static final /* enum */ OpCodes STORE_FAST_BOXED_I = new OpCodes(STORE_FAST, 1, 0);
    public static final /* enum */ OpCodes STORE_FAST_I = new OpCodes(STORE_FAST, 2, 0);
    public static final /* enum */ OpCodes STORE_FAST_UNBOX_L = new OpCodes(STORE_FAST, 1, 0);
    public static final /* enum */ OpCodes STORE_FAST_BOXED_L = new OpCodes(STORE_FAST, 1, 0);
    public static final /* enum */ OpCodes STORE_FAST_L = new OpCodes(STORE_FAST, 4, 0);
    public static final /* enum */ OpCodes STORE_FAST_UNBOX_D = new OpCodes(STORE_FAST, 1, 0);
    public static final /* enum */ OpCodes STORE_FAST_BOXED_D = new OpCodes(STORE_FAST, 1, 0);
    public static final /* enum */ OpCodes STORE_FAST_D = new OpCodes(STORE_FAST, 8, 0);
    public static final /* enum */ OpCodes STORE_FAST_UNBOX_B = new OpCodes(STORE_FAST, 1, 0);
    public static final /* enum */ OpCodes STORE_FAST_BOXED_B = new OpCodes(STORE_FAST, 1, 0);
    public static final /* enum */ OpCodes STORE_FAST_B = new OpCodes(STORE_FAST, 16, 0);
    public static final /* enum */ OpCodes UNARY_OP_O_O = new OpCodes(UNARY_OP, 1, 1);
    public static final /* enum */ OpCodes UNARY_OP_I_O = new OpCodes(UNARY_OP, 2, 1);
    public static final /* enum */ OpCodes UNARY_OP_I_I = new OpCodes(UNARY_OP, 2, 2, UNARY_OP_I_O);
    public static final /* enum */ OpCodes UNARY_OP_D_O = new OpCodes(UNARY_OP, 8, 1);
    public static final /* enum */ OpCodes UNARY_OP_D_D = new OpCodes(UNARY_OP, 8, 8, UNARY_OP_D_O);
    public static final /* enum */ OpCodes UNARY_OP_B_O = new OpCodes(UNARY_OP, 16, 1);
    public static final /* enum */ OpCodes UNARY_OP_B_B = new OpCodes(UNARY_OP, 16, 16, UNARY_OP_I_O);
    public static final /* enum */ OpCodes BINARY_OP_OO_O = new OpCodes(BINARY_OP, 1, 1);
    public static final /* enum */ OpCodes BINARY_OP_II_O = new OpCodes(BINARY_OP, 2, 1);
    public static final /* enum */ OpCodes BINARY_OP_II_I = new OpCodes(BINARY_OP, 2, 2, BINARY_OP_II_O);
    public static final /* enum */ OpCodes BINARY_OP_II_B = new OpCodes(BINARY_OP, 2, 16, BINARY_OP_II_O);
    public static final /* enum */ OpCodes BINARY_OP_DD_O = new OpCodes(BINARY_OP, 8, 1);
    public static final /* enum */ OpCodes BINARY_OP_DD_D = new OpCodes(BINARY_OP, 8, 8, BINARY_OP_DD_O);
    public static final /* enum */ OpCodes BINARY_OP_DD_B = new OpCodes(BINARY_OP, 8, 16, BINARY_OP_DD_O);
    public static final /* enum */ OpCodes FOR_ITER_O = new OpCodes(FOR_ITER, 0, 1);
    public static final /* enum */ OpCodes FOR_ITER_I = new OpCodes(FOR_ITER, 0, 2, FOR_ITER_O);
    public static final /* enum */ OpCodes BINARY_SUBSCR_SEQ_O_O = new OpCodes(BINARY_SUBSCR, 1, 1);
    public static final /* enum */ OpCodes BINARY_SUBSCR_SEQ_I_O = new OpCodes(BINARY_SUBSCR, 2, 1);
    public static final /* enum */ OpCodes BINARY_SUBSCR_SEQ_I_I = new OpCodes(BINARY_SUBSCR, 2, 2, BINARY_SUBSCR_SEQ_I_O);
    public static final /* enum */ OpCodes BINARY_SUBSCR_SEQ_I_D = new OpCodes(BINARY_SUBSCR, 2, 8, BINARY_SUBSCR_SEQ_I_O);
    public static final /* enum */ OpCodes STORE_SUBSCR_OOO = new OpCodes(STORE_SUBSCR, 1, 0);
    public static final /* enum */ OpCodes STORE_SUBSCR_SEQ_IOO = new OpCodes(STORE_SUBSCR, 1, 0);
    public static final /* enum */ OpCodes STORE_SUBSCR_SEQ_IIO = new OpCodes(STORE_SUBSCR, 2, 0);
    public static final /* enum */ OpCodes STORE_SUBSCR_SEQ_IDO = new OpCodes(STORE_SUBSCR, 8, 0);
    public static final /* enum */ OpCodes POP_AND_JUMP_IF_FALSE_O = new OpCodes(POP_AND_JUMP_IF_FALSE, 1, 0);
    public static final /* enum */ OpCodes POP_AND_JUMP_IF_FALSE_B = new OpCodes(POP_AND_JUMP_IF_FALSE, 16, 0, POP_AND_JUMP_IF_FALSE_O);
    public static final /* enum */ OpCodes POP_AND_JUMP_IF_TRUE_O = new OpCodes(POP_AND_JUMP_IF_TRUE, 1, 0);
    public static final /* enum */ OpCodes POP_AND_JUMP_IF_TRUE_B = new OpCodes(POP_AND_JUMP_IF_TRUE, 16, 0, POP_AND_JUMP_IF_TRUE_O);
    private static final OpCodes[] VALUES;
    public final StackEffect consumesStackItems;
    public final StackEffect producesStackItems;
    public final int argLength;
    public final OpCodes quickens;
    public final OpCodes generalizesTo;
    private byte quickenInputTypes;
    private byte quickenOutputTypes;
    private static final /* synthetic */ OpCodes[] $VALUES;

    public static OpCodes[] values() {
        return (OpCodes[])$VALUES.clone();
    }

    public static OpCodes valueOf(String name) {
        return Enum.valueOf(OpCodes.class, name);
    }

    public static OpCodes fromOpCode(byte opcode) {
        return VALUES[Byte.toUnsignedInt(opcode)];
    }

    private OpCodes(int argLength, int consumesStackItems, int producesStackItems) {
        this(argLength, (int oparg, byte[] followingArgs, boolean withJump) -> consumesStackItems, (int oparg, byte[] followingArgs, boolean withJump) -> producesStackItems);
    }

    private OpCodes(int argLength, StackEffect consumesStackItems, int producesStackItems) {
        this(argLength, consumesStackItems, (int oparg, byte[] followingArgs, boolean withJump) -> producesStackItems);
    }

    private OpCodes(int argLength, int consumesStackItems, StackEffect producesStackItems) {
        this(argLength, (int oparg, byte[] followingArgs, boolean withJump) -> consumesStackItems, producesStackItems);
    }

    private OpCodes(int argLength, StackEffect consumesStackItems, StackEffect producesStackItems) {
        this.argLength = argLength;
        this.consumesStackItems = consumesStackItems;
        this.producesStackItems = producesStackItems;
        this.quickens = null;
        this.generalizesTo = null;
    }

    private OpCodes(OpCodes quickens, int inputType, int outputType) {
        this(quickens, inputType, outputType, null);
    }

    private OpCodes(OpCodes quickens, int inputType, int outputType, OpCodes generalizesTo) {
        this.argLength = quickens.argLength;
        this.consumesStackItems = quickens.consumesStackItems;
        this.producesStackItems = quickens.producesStackItems;
        this.generalizesTo = generalizesTo;
        this.quickens = quickens;
        quickens.quickenInputTypes = (byte)(quickens.quickenInputTypes | (byte)inputType);
        quickens.quickenOutputTypes = (byte)(quickens.quickenOutputTypes | (byte)outputType);
    }

    public byte canQuickenInputTypes() {
        return this.quickenInputTypes;
    }

    public byte canQuickenOutputTypes() {
        return this.quickenOutputTypes;
    }

    public boolean hasArg() {
        return this.argLength > 0;
    }

    public int length() {
        return this.argLength + 1;
    }

    public int getNumberOfConsumedStackItems(int oparg, byte[] followingArgs, boolean withJump) {
        return this.consumesStackItems.stackEffect(oparg, followingArgs, withJump);
    }

    public int getNumberOfProducedStackItems(int oparg, byte[] followingArgs, boolean withJump) {
        return this.producesStackItems.stackEffect(oparg, followingArgs, withJump);
    }

    public int getStackEffect(int oparg, byte[] followingArgs, boolean withJump) {
        return this.getNumberOfProducedStackItems(oparg, followingArgs, withJump) - this.getNumberOfConsumedStackItems(oparg, followingArgs, withJump);
    }

    public int getNextBci(int bci, int oparg, boolean withJump) {
        if (this.quickens != null) {
            return this.quickens.getNextBci(bci, oparg, withJump);
        }
        switch (this.ordinal()) {
            case 74: {
                return bci + oparg;
            }
            case 75: {
                return bci - oparg;
            }
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 92: 
            case 100: 
            case 101: {
                return withJump ? bci + oparg : bci + this.length();
            }
            case 18: 
            case 37: 
            case 95: {
                return -1;
            }
            case 40: {
                assert (false) : "EXTENDED_ARG passed to getNextBci.";
                return -1;
            }
        }
        return bci + this.length();
    }

    private static /* synthetic */ OpCodes[] $values() {
        return new OpCodes[]{POP_TOP, ROT_TWO, ROT_THREE, ROT_N, DUP_TOP, NOP, UNARY_OP, BINARY_OP, BINARY_SUBSCR, STORE_SUBSCR, DELETE_SUBSCR, GET_ITER, GET_YIELD_FROM_ITER, GET_AWAITABLE, GET_AITER, GET_ANEXT, LOAD_BUILD_CLASS, LOAD_ASSERTION_ERROR, RETURN_VALUE, LOAD_NAME, STORE_NAME, DELETE_NAME, LOAD_ATTR, LOAD_METHOD, STORE_ATTR, DELETE_ATTR, LOAD_GLOBAL, STORE_GLOBAL, DELETE_GLOBAL, LOAD_CONST, LOAD_FAST, STORE_FAST, DELETE_FAST, LOAD_DEREF, STORE_DEREF, DELETE_DEREF, LOAD_CLASSDEREF, RAISE_VARARGS, BUILD_SLICE, FORMAT_VALUE, EXTENDED_ARG, IMPORT_NAME, IMPORT_FROM, IMPORT_STAR, PRINT_EXPR, SETUP_ANNOTATIONS, MATCH_SEQUENCE, MATCH_MAPPING, MATCH_CLASS, MATCH_KEYS, COPY_DICT_WITHOUT_KEYS, GET_LEN, LOAD_NONE, LOAD_ELLIPSIS, LOAD_TRUE, LOAD_FALSE, LOAD_BYTE, LOAD_INT, LOAD_LONG, LOAD_DOUBLE, LOAD_BIGINT, LOAD_STRING, LOAD_BYTES, LOAD_COMPLEX, LOAD_CONST_COLLECTION, CALL_METHOD_VARARGS, CALL_METHOD, CALL_FUNCTION, CALL_COMPREHENSION, CALL_FUNCTION_KW, CALL_FUNCTION_VARARGS, UNPACK_SEQUENCE, UNPACK_EX, FOR_ITER, JUMP_FORWARD, JUMP_BACKWARD, JUMP_IF_FALSE_OR_POP, JUMP_IF_TRUE_OR_POP, POP_AND_JUMP_IF_FALSE, POP_AND_JUMP_IF_TRUE, LOAD_CLOSURE, CLOSURE_FROM_STACK, MAKE_FUNCTION, COLLECTION_FROM_STACK, COLLECTION_ADD_STACK, COLLECTION_ADD_COLLECTION, COLLECTION_FROM_COLLECTION, TUPLE_FROM_LIST, FROZENSET_FROM_LIST, ADD_TO_COLLECTION, KWARGS_DICT_MERGE, MAKE_KEYWORD, MATCH_EXC_OR_JUMP, PUSH_EXC_INFO, POP_EXCEPT, END_EXC_HANDLER, UNWRAP_EXC, YIELD_VALUE, ASYNCGEN_WRAP, RESUME_YIELD, SEND, THROW, END_ASYNC_FOR, SETUP_WITH, EXIT_WITH, SETUP_AWITH, GET_AEXIT_CORO, EXIT_AWITH, LOAD_TRUE_O, LOAD_TRUE_B, LOAD_FALSE_O, LOAD_FALSE_B, LOAD_BYTE_O, LOAD_BYTE_I, LOAD_INT_O, LOAD_INT_I, LOAD_LONG_O, LOAD_LONG_L, LOAD_DOUBLE_O, LOAD_DOUBLE_D, LOAD_FAST_O, LOAD_FAST_I_BOX, LOAD_FAST_I, LOAD_FAST_L_BOX, LOAD_FAST_L, LOAD_FAST_D_BOX, LOAD_FAST_D, LOAD_FAST_B_BOX, LOAD_FAST_B, STORE_FAST_O, STORE_FAST_UNBOX_I, STORE_FAST_BOXED_I, STORE_FAST_I, STORE_FAST_UNBOX_L, STORE_FAST_BOXED_L, STORE_FAST_L, STORE_FAST_UNBOX_D, STORE_FAST_BOXED_D, STORE_FAST_D, STORE_FAST_UNBOX_B, STORE_FAST_BOXED_B, STORE_FAST_B, UNARY_OP_O_O, UNARY_OP_I_O, UNARY_OP_I_I, UNARY_OP_D_O, UNARY_OP_D_D, UNARY_OP_B_O, UNARY_OP_B_B, BINARY_OP_OO_O, BINARY_OP_II_O, BINARY_OP_II_I, BINARY_OP_II_B, BINARY_OP_DD_O, BINARY_OP_DD_D, BINARY_OP_DD_B, FOR_ITER_O, FOR_ITER_I, BINARY_SUBSCR_SEQ_O_O, BINARY_SUBSCR_SEQ_I_O, BINARY_SUBSCR_SEQ_I_I, BINARY_SUBSCR_SEQ_I_D, STORE_SUBSCR_OOO, STORE_SUBSCR_SEQ_IOO, STORE_SUBSCR_SEQ_IIO, STORE_SUBSCR_SEQ_IDO, POP_AND_JUMP_IF_FALSE_O, POP_AND_JUMP_IF_FALSE_B, POP_AND_JUMP_IF_TRUE_O, POP_AND_JUMP_IF_TRUE_B};
    }

    static {
        $VALUES = OpCodes.$values();
        VALUES = new OpCodes[OpCodes.values().length];
        assert (OpCodes.values().length < 256);
        System.arraycopy(OpCodes.values(), 0, VALUES, 0, VALUES.length);
    }

    @FunctionalInterface
    private static interface StackEffect {
        public int stackEffect(int var1, byte[] var2, boolean var3);
    }

    public static final class CollectionBits {
        public static final int KIND_MASK = 31;
        public static final int KIND_LIST = 32;
        public static final int KIND_TUPLE = 64;
        public static final int KIND_SET = 96;
        public static final int KIND_DICT = 128;
        public static final int KIND_KWORDS = 160;
        public static final int KIND_OBJECT = 192;
        public static final byte ELEMENT_INT = 1;
        public static final byte ELEMENT_LONG = 2;
        public static final byte ELEMENT_BOOLEAN = 3;
        public static final byte ELEMENT_DOUBLE = 4;
        public static final byte ELEMENT_OBJECT = 5;

        public static int elementCount(int oparg) {
            return oparg & 0x1F;
        }

        public static int elementType(int oparg) {
            return oparg & 0x1F;
        }

        public static int collectionKind(int oparg) {
            return oparg & 0xFFFFFFE0;
        }
    }

    public static final class MakeFunctionFlags {
        public static final int HAS_DEFAULTS = 1;
        public static final int HAS_KWONLY_DEFAULTS = 2;
        public static final int HAS_ANNOTATIONS = 4;
        public static final int HAS_CLOSURE = 8;
    }
}

