/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.lib.CallBinaryOp1Node;
import com.oracle.graal.python.lib.PyNumberRshiftNodeGen;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.AbstractTruffleString;

@GenerateInline(inlineByDefault=true)
public abstract class PyNumberRshiftNode
extends BinaryOpNode {
    public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

    @Override
    public final Object executeObject(VirtualFrame frame, Object left, Object right) {
        return this.executeCached(frame, left, right);
    }

    public final Object executeCached(VirtualFrame frame, Object v, Object w) {
        return this.execute(frame, this, v, w);
    }

    public abstract int executeInt(VirtualFrame var1, Node var2, int var3, int var4) throws UnexpectedResultException;

    @Specialization(guards={"right < 32", "right >= 0"})
    static int doIISmall(int left, int right) {
        return left >> right;
    }

    @Specialization(guards={"right < 64", "right >= 0"})
    static long doIISmall(long left, long right) {
        return left >> (int)right;
    }

    @Fallback
    static Object doIt(VirtualFrame frame, Node inliningTarget, Object v, Object w, @Cached GetClassNode getVClass, @Cached TpSlots.GetCachedTpSlotsNode getVSlots, @Cached TpSlots.GetCachedTpSlotsNode getWSlots, @Cached GetClassNode getWClass, @Cached CallBinaryOp1Node callBinaryOp1Node, @Cached PRaiseNode.Lazy raiseNode) {
        Object result;
        Object classV = getVClass.execute(inliningTarget, v);
        Object classW = getWClass.execute(inliningTarget, w);
        TpSlot slotV = getVSlots.execute(inliningTarget, classV).nb_rshift();
        TpSlot slotW = getWSlots.execute(inliningTarget, classW).nb_rshift();
        if ((slotV != null || slotW != null) && (result = callBinaryOp1Node.execute(frame, inliningTarget, v, classV, slotV, w, classW, slotW, TpSlotBinaryOp.BinaryOpSlot.NB_RSHIFT)) != PNotImplemented.NOT_IMPLEMENTED) {
            return result;
        }
        return PyNumberRshiftNode.raiseNotSupported(inliningTarget, v, w, raiseNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseNotSupported(Node inliningTarget, Object v, Object w, PRaiseNode.Lazy raiseNode) {
        if (v instanceof PBuiltinMethod) {
            PyNumberRshiftNode.handlePossiblePrint(inliningTarget, v, w);
        }
        return raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P, ">>", v, w);
    }

    @CompilerDirectives.TruffleBoundary
    private static void handlePossiblePrint(Node inliningTarget, Object v, Object w) {
        PBuiltinMethod method;
        if (v instanceof PBuiltinMethod && (method = (PBuiltinMethod)v).getBuiltinFunction().getName().equalsUncached((AbstractTruffleString)BuiltinNames.T_PRINT, PythonUtils.TS_ENCODING)) {
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P_PRINT, ">>", v, w);
        }
    }

    @NeverDefault
    public static PyNumberRshiftNode create() {
        return PyNumberRshiftNodeGen.create();
    }
}

