/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.ModuleBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.GetAttributeNodeFactory;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class GetAttributeNode
extends PNodeWithContext {
    @Node.Child
    private GetFixedAttributeNode getFixedAttributeNode;

    public Object executeObject(VirtualFrame frame, Object object) {
        return this.getFixedAttributeNode.executeObject(frame, object);
    }

    protected GetAttributeNode(TruffleString key) {
        this.getFixedAttributeNode = GetFixedAttributeNode.create(key);
    }

    @NeverDefault
    public static GetAttributeNode create(TruffleString key) {
        return new GetAttributeNode(key);
    }

    public static abstract class GetFixedAttributeNode
    extends PNodeWithContext {
        private final TruffleString key;
        @Node.Child
        private TpSlots.GetObjectSlotsNode getSlotsNode = TpSlots.GetObjectSlotsNode.create();

        public GetFixedAttributeNode(TruffleString key) {
            this.key = key;
        }

        public final TruffleString getKey() {
            return this.key;
        }

        public final Object executeObject(VirtualFrame frame, Object object) {
            return this.execute(frame, object);
        }

        public final Object execute(VirtualFrame frame, Object object) {
            return this.executeImpl(frame, object, this.getSlotsNode.executeCached(object));
        }

        abstract Object executeImpl(VirtualFrame var1, Object var2, TpSlots var3);

        protected static boolean hasNoGetAttr(Object obj) {
            return LookupAttributeInMRONode.Dynamic.getUncached().execute(GetClassNode.executeUncached(obj), SpecialMethodNames.T___GETATTR__) == PNone.NO_VALUE;
        }

        protected static boolean isObjectGetAttribute(TpSlots slots) {
            return slots.tp_getattro() == ObjectBuiltins.SLOTS.tp_getattro();
        }

        protected static boolean isModuleGetAttribute(TpSlots slots) {
            return slots.tp_getattro() == ModuleBuiltins.SLOTS.tp_getattro();
        }

        protected static boolean isTypeGetAttribute(TpSlots slots) {
            return slots.tp_getattro() == TypeBuiltins.SLOTS.tp_getattro();
        }

        @Specialization(guards={"isObjectGetAttribute(slots)"})
        final Object doBuiltinObject(VirtualFrame frame, Object object, TpSlots slots, @Cached ObjectBuiltins.GetAttributeNode getAttributeNode) {
            assert (GetFixedAttributeNode.hasNoGetAttr(object));
            return getAttributeNode.execute(frame, object, this.key);
        }

        @Specialization(guards={"isTypeGetAttribute(slots)"})
        final Object doBuiltinType(VirtualFrame frame, Object object, TpSlots slots, @Cached TypeBuiltins.GetattributeNode getAttributeNode) {
            assert (GetFixedAttributeNode.hasNoGetAttr(object));
            return getAttributeNode.execute(frame, object, this.key);
        }

        @Specialization(guards={"isModuleGetAttribute(slots)"})
        final Object doBuiltinModule(VirtualFrame frame, Object object, TpSlots slots, @Cached ModuleBuiltins.ModuleGetattritbuteNode getAttributeNode) {
            assert (GetFixedAttributeNode.hasNoGetAttr(object));
            return getAttributeNode.execute(frame, object, this.key);
        }

        @Specialization(replaces={"doBuiltinObject", "doBuiltinType", "doBuiltinModule"})
        final Object doGeneric(VirtualFrame frame, Object object, TpSlots slots, @Bind(value="this") Node inliningTarget, @Cached TpSlotGetAttr.CallSlotGetAttrNode callGetAttrNode) {
            return callGetAttrNode.execute(frame, inliningTarget, slots, object, this.key);
        }

        @NeverDefault
        public static GetFixedAttributeNode create(TruffleString key) {
            return GetAttributeNodeFactory.GetFixedAttributeNodeGen.create(key);
        }
    }
}

