/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.tokenizer;

import com.oracle.graal.python.pegparser.tokenizer.SourceRange;

public class Token {
    public int type;
    public int level;
    public final SourceRange sourceRange;
    public final Object extraData;
    final int startOffset;
    final int endOffset;

    public Token(int type, int level, int startOffset, int endOffset, SourceRange sourceRange, Object extraData) {
        this.type = type;
        this.level = level;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.sourceRange = sourceRange;
        this.extraData = extraData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Token ");
        if (this.type < Kind.TOKEN_NAMES.length) {
            sb.append(Kind.TOKEN_NAMES[this.type]);
        } else {
            sb.append(this.type);
        }
        sb.append(" [").append(this.startOffset).append(", ").append(this.endOffset).append(']');
        return sb.toString();
    }

    static int oneChar(int c) {
        switch (c) {
            case 37: {
                return 24;
            }
            case 38: {
                return 19;
            }
            case 40: {
                return 7;
            }
            case 41: {
                return 8;
            }
            case 42: {
                return 16;
            }
            case 43: {
                return 14;
            }
            case 44: {
                return 12;
            }
            case 45: {
                return 15;
            }
            case 46: {
                return 23;
            }
            case 47: {
                return 17;
            }
            case 58: {
                return 11;
            }
            case 59: {
                return 13;
            }
            case 60: {
                return 20;
            }
            case 61: {
                return 22;
            }
            case 62: {
                return 21;
            }
            case 64: {
                return 49;
            }
            case 91: {
                return 9;
            }
            case 93: {
                return 10;
            }
            case 94: {
                return 32;
            }
            case 123: {
                return 25;
            }
            case 124: {
                return 18;
            }
            case 125: {
                return 26;
            }
            case 126: {
                return 31;
            }
        }
        return 54;
    }

    static int twoChars(int c1, int c2) {
        switch (c1) {
            case 33: {
                switch (c2) {
                    case 61: {
                        return 28;
                    }
                }
                break;
            }
            case 37: {
                switch (c2) {
                    case 61: {
                        return 40;
                    }
                }
                break;
            }
            case 38: {
                switch (c2) {
                    case 61: {
                        return 41;
                    }
                }
                break;
            }
            case 42: {
                switch (c2) {
                    case 42: {
                        return 35;
                    }
                    case 61: {
                        return 38;
                    }
                }
                break;
            }
            case 43: {
                switch (c2) {
                    case 61: {
                        return 36;
                    }
                }
                break;
            }
            case 45: {
                switch (c2) {
                    case 61: {
                        return 37;
                    }
                    case 62: {
                        return 51;
                    }
                }
                break;
            }
            case 47: {
                switch (c2) {
                    case 47: {
                        return 47;
                    }
                    case 61: {
                        return 39;
                    }
                }
                break;
            }
            case 58: {
                switch (c2) {
                    case 61: {
                        return 53;
                    }
                }
                break;
            }
            case 60: {
                switch (c2) {
                    case 60: {
                        return 33;
                    }
                    case 61: {
                        return 29;
                    }
                    case 62: {
                        return 28;
                    }
                }
                break;
            }
            case 61: {
                switch (c2) {
                    case 61: {
                        return 27;
                    }
                }
                break;
            }
            case 62: {
                switch (c2) {
                    case 61: {
                        return 30;
                    }
                    case 62: {
                        return 34;
                    }
                }
                break;
            }
            case 64: {
                switch (c2) {
                    case 61: {
                        return 50;
                    }
                }
                break;
            }
            case 94: {
                switch (c2) {
                    case 61: {
                        return 43;
                    }
                }
                break;
            }
            case 124: {
                switch (c2) {
                    case 61: {
                        return 42;
                    }
                }
            }
        }
        return 54;
    }

    static int threeChars(int c1, int c2, int c3) {
        switch (c1) {
            case 42: {
                switch (c2) {
                    case 42: {
                        switch (c3) {
                            case 61: {
                                return 46;
                            }
                        }
                    }
                }
                break;
            }
            case 46: {
                switch (c2) {
                    case 46: {
                        switch (c3) {
                            case 46: {
                                return 52;
                            }
                        }
                    }
                }
                break;
            }
            case 47: {
                switch (c2) {
                    case 47: {
                        switch (c3) {
                            case 61: {
                                return 48;
                            }
                        }
                    }
                }
                break;
            }
            case 60: {
                switch (c2) {
                    case 60: {
                        switch (c3) {
                            case 61: {
                                return 44;
                            }
                        }
                    }
                }
                break;
            }
            case 62: {
                switch (c2) {
                    case 62: {
                        switch (c3) {
                            case 61: {
                                return 45;
                            }
                        }
                    }
                }
            }
        }
        return 54;
    }

    public String typeName() {
        if (this.type < Kind.TOKEN_NAMES.length) {
            return Kind.TOKEN_NAMES[this.type];
        }
        return Integer.toString(this.type);
    }

    public SourceRange getSourceRange() {
        return this.sourceRange;
    }

    public static final class Kind {
        public static final int ENDMARKER = 0;
        public static final int NAME = 1;
        public static final int NUMBER = 2;
        public static final int STRING = 3;
        public static final int NEWLINE = 4;
        public static final int INDENT = 5;
        public static final int DEDENT = 6;
        public static final int LPAR = 7;
        public static final int RPAR = 8;
        public static final int LSQB = 9;
        public static final int RSQB = 10;
        public static final int COLON = 11;
        public static final int COMMA = 12;
        public static final int SEMI = 13;
        public static final int PLUS = 14;
        public static final int MINUS = 15;
        public static final int STAR = 16;
        public static final int SLASH = 17;
        public static final int VBAR = 18;
        public static final int AMPER = 19;
        public static final int LESS = 20;
        public static final int GREATER = 21;
        public static final int EQUAL = 22;
        public static final int DOT = 23;
        public static final int PERCENT = 24;
        public static final int LBRACE = 25;
        public static final int RBRACE = 26;
        public static final int EQEQUAL = 27;
        public static final int NOTEQUAL = 28;
        public static final int LESSEQUAL = 29;
        public static final int GREATEREQUAL = 30;
        public static final int TILDE = 31;
        public static final int CIRCUMFLEX = 32;
        public static final int LEFTSHIFT = 33;
        public static final int RIGHTSHIFT = 34;
        public static final int DOUBLESTAR = 35;
        public static final int PLUSEQUAL = 36;
        public static final int MINEQUAL = 37;
        public static final int STAREQUAL = 38;
        public static final int SLASHEQUAL = 39;
        public static final int PERCENTEQUAL = 40;
        public static final int AMPEREQUAL = 41;
        public static final int VBAREQUAL = 42;
        public static final int CIRCUMFLEXEQUAL = 43;
        public static final int LEFTSHIFTEQUAL = 44;
        public static final int RIGHTSHIFTEQUAL = 45;
        public static final int DOUBLESTAREQUAL = 46;
        public static final int DOUBLESLASH = 47;
        public static final int DOUBLESLASHEQUAL = 48;
        public static final int AT = 49;
        public static final int ATEQUAL = 50;
        public static final int RARROW = 51;
        public static final int ELLIPSIS = 52;
        public static final int COLONEQUAL = 53;
        public static final int OP = 54;
        public static final int AWAIT = 55;
        public static final int ASYNC = 56;
        public static final int TYPE_IGNORE = 57;
        public static final int TYPE_COMMENT = 58;
        public static final int SOFT_KEYWORD = 59;
        public static final int ERRORTOKEN = 60;
        public static final int COMMENT = 61;
        public static final int NL = 62;
        public static final int ENCODING = 63;
        public static final int N_TOKENS = 64;
        public static final String[] TOKEN_NAMES = new String[]{"ENDMARKER", "NAME", "NUMBER", "STRING", "NEWLINE", "INDENT", "DEDENT", "LPAR", "RPAR", "LSQB", "RSQB", "COLON", "COMMA", "SEMI", "PLUS", "MINUS", "STAR", "SLASH", "VBAR", "AMPER", "LESS", "GREATER", "EQUAL", "DOT", "PERCENT", "LBRACE", "RBRACE", "EQEQUAL", "NOTEQUAL", "LESSEQUAL", "GREATEREQUAL", "TILDE", "CIRCUMFLEX", "LEFTSHIFT", "RIGHTSHIFT", "DOUBLESTAR", "PLUSEQUAL", "MINEQUAL", "STAREQUAL", "SLASHEQUAL", "PERCENTEQUAL", "AMPEREQUAL", "VBAREQUAL", "CIRCUMFLEXEQUAL", "LEFTSHIFTEQUAL", "RIGHTSHIFTEQUAL", "DOUBLESTAREQUAL", "DOUBLESLASH", "DOUBLESLASHEQUAL", "AT", "ATEQUAL", "RARROW", "ELLIPSIS", "COLONEQUAL", "OP", "AWAIT", "ASYNC", "TYPE_IGNORE", "TYPE_COMMENT", "SOFT_KEYWORD", "<ERRORTOKEN>", "<COMMENT>", "<NL>", "<ENCODING>"};
    }
}

