/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.nio.ByteOrder;
import java.util.Arrays;

@ExportLibrary(value=PythonBufferAccessLibrary.class)
public final class ByteSequenceStorage
extends ArrayBasedSequenceStorage {
    private byte[] values;

    public ByteSequenceStorage(byte[] elements) {
        this(elements, elements.length);
    }

    public ByteSequenceStorage(byte[] elements, int length) {
        this.values = elements;
        this.capacity = this.values.length;
        this.length = length;
    }

    public ByteSequenceStorage(int capacity) {
        this.values = new byte[capacity];
        this.capacity = capacity;
        this.length = 0;
    }

    private void increaseCapacityExactWithCopy(int newCapacity) {
        this.values = Arrays.copyOf(this.values, newCapacity);
        this.capacity = this.values.length;
    }

    public void ensureCapacity(int newCapacity) throws ArithmeticException {
        if (CompilerDirectives.injectBranchProbability((double)0.25, (newCapacity > this.capacity ? 1 : 0) != 0)) {
            this.increaseCapacityExactWithCopy(ByteSequenceStorage.capacityFor(newCapacity));
        }
    }

    @Override
    public ByteSequenceStorage createEmpty(int newCapacity) {
        return new ByteSequenceStorage(newCapacity);
    }

    public void reverse() {
        if (this.length > 0) {
            int head = 0;
            int tail = this.length - 1;
            int middle = (this.length - 1) / 2;
            while (head <= middle) {
                byte temp = this.values[head];
                this.values[head] = this.values[tail];
                this.values[tail] = temp;
                ++head;
                --tail;
            }
        }
    }

    public byte getByteItemNormalized(int idx) {
        return this.values[idx];
    }

    public int getIntItemNormalized(int idx) {
        return this.values[idx] & 0xFF;
    }

    public void setByteItemNormalized(int idx, byte value) {
        this.values[idx] = value;
    }

    public void insertByteItem(int idx, byte value) {
        this.ensureCapacity(this.length + 1);
        for (int i = this.values.length - 1; i > idx; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[idx] = value;
        ++this.length;
    }

    public int indexOfByte(byte value) {
        return ArrayUtils.indexOf((byte[])this.values, (int)0, (int)this.length, (byte[])new byte[]{value});
    }

    public int indexOfInt(int value) {
        for (int i = 0; i < this.length; ++i) {
            if ((this.values[i] & 0xFF) != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getIndicativeValue() {
        return 0;
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    public Object[] getCopyOfInternalArray() {
        Object[] boxed = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            boxed[i] = this.values[i];
        }
        return boxed;
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        this.values = (byte[])arrayObject;
    }

    @Override
    public SequenceStorage.StorageType getElementType() {
        return SequenceStorage.StorageType.Byte;
    }

    @ExportMessage
    boolean isBuffer() {
        return true;
    }

    @ExportMessage
    boolean isReadonly() {
        return false;
    }

    @ExportMessage
    int getBufferLength() {
        return this.length;
    }

    @ExportMessage
    boolean hasInternalByteArray() {
        return true;
    }

    @ExportMessage
    public byte[] getInternalByteArray() {
        return this.values;
    }

    @ExportMessage
    byte readByte(int byteOffset) {
        return this.values[byteOffset];
    }

    @ExportMessage
    void writeByte(int byteOffset, byte value) {
        this.values[byteOffset] = value;
    }

    @ExportMessage
    short readShortByteOrder(int byteOffset, ByteOrder byteOrder) {
        return PythonUtils.byteArraySupport(byteOrder).getShort(this.values, byteOffset);
    }

    @ExportMessage
    void writeShortByteOrder(int byteOffset, short value, ByteOrder byteOrder) {
        PythonUtils.byteArraySupport(byteOrder).putShort(this.values, byteOffset, value);
    }

    @ExportMessage
    int readIntByteOrder(int byteOffset, ByteOrder byteOrder) {
        return PythonUtils.byteArraySupport(byteOrder).getInt(this.values, byteOffset);
    }

    @ExportMessage
    void writeIntByteOrder(int byteOffset, int value, ByteOrder byteOrder) {
        PythonUtils.byteArraySupport(byteOrder).putInt(this.values, byteOffset, value);
    }

    @ExportMessage
    long readLongByteOrder(int byteOffset, ByteOrder byteOrder) {
        return PythonUtils.byteArraySupport(byteOrder).getLong(this.values, byteOffset);
    }

    @ExportMessage
    void writeLongByteOrder(int byteOffset, long value, ByteOrder byteOrder) {
        PythonUtils.byteArraySupport(byteOrder).putLong(this.values, byteOffset, value);
    }

    @ExportMessage
    float readFloatByteOrder(int byteOffset, ByteOrder byteOrder) {
        return PythonUtils.byteArraySupport(byteOrder).getFloat(this.values, byteOffset);
    }

    @ExportMessage
    void writeFloatByteOrder(int byteOffset, float value, ByteOrder byteOrder) {
        PythonUtils.byteArraySupport(byteOrder).putFloat(this.values, byteOffset, value);
    }

    @ExportMessage
    double readDoubleByteOrder(int byteOffset, ByteOrder byteOrder) {
        return PythonUtils.byteArraySupport(byteOrder).getDouble(this.values, byteOffset);
    }

    @ExportMessage
    void writeDoubleByteOrder(int byteOffset, double value, ByteOrder byteOrder) {
        PythonUtils.byteArraySupport(byteOrder).putDouble(this.values, byteOffset, value);
    }
}

