/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.MapsId;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.AnnotationException;
import org.hibernate.DuplicateMappingException;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.ConfigurationArtefactType;
import org.hibernate.cfg.CopyIdentifierComponentSecondPass;
import org.hibernate.cfg.CreateKeySecondPass;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.RecoverableException;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.SecondaryTableSecondPass;
import org.hibernate.cfg.SetSimpleValueTypeSecondPass;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.cfg.annotations.Version;
import org.hibernate.cfg.annotations.reflection.JPAMetadataProvider;
import org.hibernate.cfg.beanvalidation.BeanValidationActivator;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfiguration
extends Configuration {
    private Logger log = LoggerFactory.getLogger(AnnotationConfiguration.class);
    public static final String DEFAULT_CACHE_CONCURRENCY_STRATEGY = "hibernate.cache.default_cache_concurrency_strategy";
    public static final String USE_NEW_ID_GENERATOR_MAPPINGS = "hibernate.id.new_generator_mappings";
    private static final String SEARCH_STARTUP_CLASS = "org.hibernate.search.event.EventListenerRegister";
    private static final String SEARCH_STARTUP_METHOD = "enableHibernateSearch";
    public static final String ARTEFACT_PROCESSING_ORDER = "hibernate.mapping.precedence";
    public static final ConfigurationArtefactType[] DEFAULT_ARTEFACT_PROCESSING_ORDER;
    private Map<String, IdGenerator> namedGenerators;
    private Map<String, Map<String, Join>> joins;
    private Map<String, AnnotatedClassType> classTypes;
    private Set<String> defaultNamedQueryNames;
    private Set<String> defaultNamedNativeQueryNames;
    private Set<String> defaultSqlResulSetMappingNames;
    private Set<String> defaultNamedGenerators;
    private Map<String, Properties> generatorTables;
    private Map<Table, List<UniqueConstraintHolder>> uniqueConstraintHoldersByTable;
    private Map<String, String> mappedByResolver;
    private Map<String, String> propertyRefResolver;
    private Map<String, AnyMetaDef> anyMetaDefs;
    private List<XClass> annotatedClasses;
    private Map<String, XClass> annotatedClassEntities;
    private Map<String, Document> hbmEntities;
    private List<CacheHolder> caches;
    private List<Document> hbmDocuments;
    private List<ConfigurationArtefactType> configurationArtefactPrecedence;
    private boolean inSecondPass = false;
    private transient ReflectionManager reflectionManager;
    private boolean isDefaultProcessed = false;
    private boolean isValidatorNotPresentLogged;
    private Map<XClass, Map<String, PropertyData>> propertiesAnnotatedWithMapsId;
    private Map<XClass, Map<String, PropertyData>> propertiesAnnotatedWithIdAndToOne;

    public AnnotationConfiguration() {
    }

    public AnnotationConfiguration(SettingsFactory sf) {
        super(sf);
    }

    protected List<XClass> orderAndFillHierarchy(List<XClass> original) {
        ArrayList<XClass> copy = new ArrayList<XClass>(original);
        this.insertMappedSuperclasses(original, copy);
        ArrayList<XClass> workingCopy = new ArrayList<XClass>(copy);
        ArrayList<XClass> newList = new ArrayList<XClass>(copy.size());
        while (workingCopy.size() > 0) {
            XClass clazz = (XClass)workingCopy.get(0);
            this.orderHierarchy(workingCopy, newList, copy, clazz);
        }
        return newList;
    }

    private void insertMappedSuperclasses(List<XClass> original, List<XClass> copy) {
        for (XClass clazz : original) {
            for (XClass superClass = clazz.getSuperclass(); superClass != null && !this.reflectionManager.equals(superClass, Object.class) && !copy.contains(superClass); superClass = superClass.getSuperclass()) {
                if (!superClass.isAnnotationPresent(Entity.class) && !superClass.isAnnotationPresent(MappedSuperclass.class)) continue;
                copy.add(superClass);
            }
        }
    }

    private void orderHierarchy(List<XClass> copy, List<XClass> newList, List<XClass> original, XClass clazz) {
        if (clazz == null || this.reflectionManager.equals(clazz, Object.class)) {
            return;
        }
        this.orderHierarchy(copy, newList, original, clazz.getSuperclass());
        if (original.contains(clazz)) {
            if (!newList.contains(clazz)) {
                newList.add(clazz);
            }
            copy.remove(clazz);
        }
    }

    public AnnotationConfiguration addAnnotatedClass(Class persistentClass) throws MappingException {
        XClass persistentXClass = this.reflectionManager.toXClass(persistentClass);
        try {
            this.annotatedClasses.add(persistentXClass);
            return this;
        }
        catch (MappingException me) {
            this.log.error("Could not compile the mapping annotations", (Throwable)me);
            throw me;
        }
    }

    public AnnotationConfiguration addPackage(String packageName) throws MappingException {
        this.log.info("Mapping package {}", (Object)packageName);
        try {
            AnnotationBinder.bindPackage(packageName, this.createExtendedMappings());
            return this;
        }
        catch (MappingException me) {
            this.log.error("Could not compile the mapping annotations", (Throwable)me);
            throw me;
        }
    }

    public ExtendedMappings createExtendedMappings() {
        return new ExtendedMappingsImpl();
    }

    public void setCacheConcurrencyStrategy(String clazz, String concurrencyStrategy, String region, boolean cacheLazyProperty) throws MappingException {
        this.caches.add(new CacheHolder(clazz, concurrencyStrategy, region, true, cacheLazyProperty));
    }

    public void setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy, String region) throws MappingException {
        this.caches.add(new CacheHolder(collectionRole, concurrencyStrategy, region, false, false));
    }

    protected void reset() {
        super.reset();
        this.namedGenerators = new HashMap<String, IdGenerator>();
        this.joins = new HashMap<String, Map<String, Join>>();
        this.classTypes = new HashMap<String, AnnotatedClassType>();
        this.generatorTables = new HashMap<String, Properties>();
        this.defaultNamedQueryNames = new HashSet<String>();
        this.defaultNamedNativeQueryNames = new HashSet<String>();
        this.defaultSqlResulSetMappingNames = new HashSet<String>();
        this.defaultNamedGenerators = new HashSet<String>();
        this.uniqueConstraintHoldersByTable = new HashMap<Table, List<UniqueConstraintHolder>>();
        this.mappedByResolver = new HashMap<String, String>();
        this.propertyRefResolver = new HashMap<String, String>();
        this.annotatedClasses = new ArrayList<XClass>();
        this.caches = new ArrayList<CacheHolder>();
        this.hbmEntities = new HashMap<String, Document>();
        this.annotatedClassEntities = new HashMap<String, XClass>();
        this.hbmDocuments = new ArrayList<Document>();
        this.namingStrategy = EJB3NamingStrategy.INSTANCE;
        this.setEntityResolver((EntityResolver)((Object)new EJB3DTDEntityResolver()));
        this.anyMetaDefs = new HashMap<String, AnyMetaDef>();
        this.propertiesAnnotatedWithMapsId = new HashMap<XClass, Map<String, PropertyData>>();
        this.propertiesAnnotatedWithIdAndToOne = new HashMap<XClass, Map<String, PropertyData>>();
        this.reflectionManager = new JavaReflectionManager();
        ((MetadataProviderInjector)this.reflectionManager).setMetadataProvider((MetadataProvider)new JPAMetadataProvider());
        this.configurationArtefactPrecedence = Collections.emptyList();
    }

    protected void secondPassCompile() throws MappingException {
        this.log.debug("Execute first pass mapping processing");
        ArrayList<XClass> tempAnnotatedClasses = new ArrayList<XClass>(this.annotatedClasses.size());
        for (XClass clazz : this.annotatedClasses) {
            if (clazz.isAnnotationPresent(Entity.class)) {
                this.annotatedClassEntities.put(clazz.getName(), clazz);
                tempAnnotatedClasses.add(clazz);
                continue;
            }
            if (!clazz.isAnnotationPresent(MappedSuperclass.class)) continue;
            tempAnnotatedClasses.add(clazz);
        }
        this.annotatedClasses = tempAnnotatedClasses;
        if (!this.isDefaultProcessed) {
            Object isDelimited = this.reflectionManager.getDefaults().get("delimited-identifier");
            if (isDelimited != null && isDelimited == Boolean.TRUE) {
                this.getProperties().put("hibernate.globally_quoted_identifiers", "true");
            }
            AnnotationBinder.bindDefaults(this.createExtendedMappings());
            this.isDefaultProcessed = true;
        }
        if (this.configurationArtefactPrecedence.isEmpty() && StringHelper.isNotEmpty((String)this.getProperties().getProperty(ARTEFACT_PROCESSING_ORDER))) {
            this.configurationArtefactPrecedence = this.parsePrecedence(this.getProperties().getProperty(ARTEFACT_PROCESSING_ORDER));
        }
        if (this.configurationArtefactPrecedence.isEmpty()) {
            this.configurationArtefactPrecedence = Arrays.asList(DEFAULT_ARTEFACT_PROCESSING_ORDER);
        }
        this.configurationArtefactPrecedence = Collections.unmodifiableList(this.configurationArtefactPrecedence);
        for (ConfigurationArtefactType p : this.configurationArtefactPrecedence) {
            this.removeConflictedArtifact(p);
            this.processArtifactsOfType(p);
        }
        int cacheNbr = this.caches.size();
        for (int index = 0; index < cacheNbr; ++index) {
            CacheHolder cacheHolder = this.caches.get(index);
            if (cacheHolder.isClass) {
                super.setCacheConcurrencyStrategy(cacheHolder.role, cacheHolder.usage, cacheHolder.region, cacheHolder.cacheLazy);
                continue;
            }
            super.setCollectionCacheConcurrencyStrategy(cacheHolder.role, cacheHolder.usage, cacheHolder.region);
        }
        this.caches.clear();
        try {
            this.inSecondPass = true;
            this.processSecondPassesOfType(PkDrivenByDefaultMapsIdSecondPass.class);
            this.processSecondPassesOfType(SetSimpleValueTypeSecondPass.class);
            this.processSecondPassesOfType(CopyIdentifierComponentSecondPass.class);
            this.processFkSecondPassInOrder();
            this.processSecondPassesOfType(CreateKeySecondPass.class);
            this.processSecondPassesOfType(SecondaryTableSecondPass.class);
            super.secondPassCompile();
            this.inSecondPass = false;
        }
        catch (RecoverableException e) {
            throw (RuntimeException)e.getCause();
        }
        for (Map.Entry<Table, List<UniqueConstraintHolder>> tableListEntry : this.uniqueConstraintHoldersByTable.entrySet()) {
            Table table = tableListEntry.getKey();
            List<UniqueConstraintHolder> uniqueConstraints = tableListEntry.getValue();
            int uniqueIndexPerTable = 0;
            for (UniqueConstraintHolder holder : uniqueConstraints) {
                String keyName = StringHelper.isEmpty((String)holder.getName()) ? "key" + ++uniqueIndexPerTable : holder.getName();
                this.buildUniqueKeyFromColumnNames(table, keyName, holder.getColumns());
            }
        }
        this.applyConstraintsToDDL();
    }

    private void processSecondPassesOfType(Class<? extends SecondPass> type) {
        Iterator iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            SecondPass sp = (SecondPass)iter.next();
            if (!type.isInstance(sp)) continue;
            sp.doSecondPass(this.classes);
            iter.remove();
        }
    }

    private void applyConstraintsToDDL() {
        boolean applyOnDdl = this.getProperties().getProperty("hibernate.validator.apply_to_ddl", "true").equalsIgnoreCase("true");
        if (!applyOnDdl) {
            return;
        }
        this.applyHibernateValidatorLegacyConstraintsOnDDL();
        this.applyBeanValidationConstraintsOnDDL();
    }

    private void applyHibernateValidatorLegacyConstraintsOnDDL() {
        Constructor validatorCtr = null;
        Method applyMethod = null;
        try {
            Class classValidator = ReflectHelper.classForName((String)"org.hibernate.validator.ClassValidator", ((Object)((Object)this)).getClass());
            Class messageInterpolator = ReflectHelper.classForName((String)"org.hibernate.validator.MessageInterpolator", ((Object)((Object)this)).getClass());
            validatorCtr = classValidator.getDeclaredConstructor(Class.class, ResourceBundle.class, messageInterpolator, Map.class, ReflectionManager.class);
            applyMethod = classValidator.getMethod("apply", PersistentClass.class);
        }
        catch (ClassNotFoundException e) {
            if (!this.isValidatorNotPresentLogged) {
                this.log.info("Hibernate Validator not found: ignoring");
            }
            this.isValidatorNotPresentLogged = true;
        }
        catch (NoSuchMethodException e) {
            throw new AnnotationException(e);
        }
        if (applyMethod != null) {
            for (PersistentClass persistentClazz : this.classes.values()) {
                String className = persistentClazz.getClassName();
                if (!StringHelper.isNotEmpty((String)className)) continue;
                try {
                    Object validator = validatorCtr.newInstance(ReflectHelper.classForName((String)className), null, null, null, this.reflectionManager);
                    applyMethod.invoke(validator, persistentClazz);
                }
                catch (Exception e) {
                    this.log.warn("Unable to apply constraints on DDL for " + className, (Throwable)e);
                }
            }
        }
    }

    private void applyBeanValidationConstraintsOnDDL() {
        BeanValidationActivator.applyDDL(this.classes.values(), this.getProperties());
    }

    private void processFkSecondPassInOrder() {
        this.log.debug("processing fk mappings (*ToOne and JoinedSubclass)");
        List<FkSecondPass> fkSecondPasses = this.getFKSecondPassesOnly();
        if (fkSecondPasses.size() == 0) {
            return;
        }
        HashMap<String, Set<FkSecondPass>> isADependencyOf = new HashMap<String, Set<FkSecondPass>>();
        ArrayList<FkSecondPass> endOfQueueFkSecondPasses = new ArrayList<FkSecondPass>(fkSecondPasses.size());
        for (FkSecondPass sp : fkSecondPasses) {
            if (sp.isInPrimaryKey()) {
                String referenceEntityName = sp.getReferencedEntityName();
                PersistentClass classMapping = this.getClassMapping(referenceEntityName);
                String dependentTable = classMapping.getTable().getQuotedName();
                if (!isADependencyOf.containsKey(dependentTable)) {
                    isADependencyOf.put(dependentTable, new HashSet());
                }
                ((Set)isADependencyOf.get(dependentTable)).add(sp);
                continue;
            }
            endOfQueueFkSecondPasses.add(sp);
        }
        ArrayList orderedFkSecondPasses = new ArrayList(fkSecondPasses.size());
        for (String tableName : isADependencyOf.keySet()) {
            this.buildRecursiveOrderedFkSecondPasses(orderedFkSecondPasses, isADependencyOf, tableName, tableName);
        }
        for (FkSecondPass sp : orderedFkSecondPasses) {
            sp.doSecondPass(this.classes);
        }
        this.processEndOfQueue(endOfQueueFkSecondPasses);
    }

    private void processEndOfQueue(List endOfQueueFkSecondPasses) {
        boolean stopProcess = false;
        RuntimeException originalException = null;
        while (!stopProcess) {
            ArrayList<SecondPass> failingSecondPasses = new ArrayList<SecondPass>();
            ListIterator it = endOfQueueFkSecondPasses.listIterator();
            while (it.hasNext()) {
                SecondPass pass = (SecondPass)it.next();
                try {
                    pass.doSecondPass(this.classes);
                }
                catch (RecoverableException e) {
                    failingSecondPasses.add(pass);
                    if (originalException != null) continue;
                    originalException = (RuntimeException)e.getCause();
                }
            }
            stopProcess = failingSecondPasses.size() == 0 || failingSecondPasses.size() == endOfQueueFkSecondPasses.size();
            endOfQueueFkSecondPasses = failingSecondPasses;
        }
        if (endOfQueueFkSecondPasses.size() > 0) {
            throw originalException;
        }
    }

    private List<FkSecondPass> getFKSecondPassesOnly() {
        Iterator iter = this.secondPasses.iterator();
        ArrayList<FkSecondPass> fkSecondPasses = new ArrayList<FkSecondPass>(this.secondPasses.size());
        while (iter.hasNext()) {
            SecondPass sp = (SecondPass)iter.next();
            if (!(sp instanceof FkSecondPass)) continue;
            fkSecondPasses.add((FkSecondPass)sp);
            iter.remove();
        }
        return fkSecondPasses;
    }

    private void buildRecursiveOrderedFkSecondPasses(List orderedFkSecondPasses, Map<String, Set<FkSecondPass>> isADependencyOf, String startTable, String currentTable) {
        Set<FkSecondPass> dependencies = isADependencyOf.get(currentTable);
        if (dependencies == null || dependencies.size() == 0) {
            return;
        }
        for (FkSecondPass sp : dependencies) {
            String dependentTable = sp.getValue().getTable().getQuotedName();
            if (dependentTable.compareTo(startTable) == 0) {
                StringBuilder sb = new StringBuilder("Foreign key circularity dependency involving the following tables: ");
                throw new AnnotationException(sb.toString());
            }
            this.buildRecursiveOrderedFkSecondPasses(orderedFkSecondPasses, isADependencyOf, startTable, dependentTable);
            if (orderedFkSecondPasses.contains(sp)) continue;
            orderedFkSecondPasses.add(0, sp);
        }
    }

    private void processArtifactsOfType(ConfigurationArtefactType p) {
        if (ConfigurationArtefactType.HBM.equals((Object)p)) {
            this.log.debug("Process hbm files");
            for (Document document : this.hbmDocuments) {
                super.add(document);
            }
            this.hbmDocuments.clear();
            this.hbmEntities.clear();
        } else if (ConfigurationArtefactType.CLASS.equals((Object)p)) {
            this.log.debug("Process annotated classes");
            List<XClass> orderedClasses = this.orderAndFillHierarchy(this.annotatedClasses);
            ExtendedMappings mappings = this.createExtendedMappings();
            Map<XClass, InheritanceState> inheritanceStatePerClass = AnnotationBinder.buildInheritanceStates(orderedClasses, mappings);
            for (XClass clazz : orderedClasses) {
                AnnotationBinder.bindClass(clazz, inheritanceStatePerClass, mappings);
            }
            this.annotatedClasses.clear();
            this.annotatedClassEntities.clear();
        }
    }

    private void removeConflictedArtifact(ConfigurationArtefactType p) {
        block3: {
            block2: {
                if (!ConfigurationArtefactType.HBM.equals((Object)p)) break block2;
                for (String entity : this.hbmEntities.keySet()) {
                    if (!this.annotatedClassEntities.containsKey(entity)) continue;
                    this.annotatedClasses.remove(this.annotatedClassEntities.get(entity));
                    this.annotatedClassEntities.remove(entity);
                }
                break block3;
            }
            if (!ConfigurationArtefactType.CLASS.equals((Object)p)) break block3;
            for (String entity : this.annotatedClassEntities.keySet()) {
                if (!this.hbmEntities.containsKey(entity)) continue;
                this.hbmDocuments.remove(this.hbmEntities.get(entity));
                this.hbmEntities.remove(entity);
            }
        }
    }

    private void buildUniqueKeyFromColumnNames(Table table, String keyName, String[] columnNames) {
        ExtendedMappings mappings = this.createExtendedMappings();
        keyName = mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(keyName);
        int size = columnNames.length;
        Column[] columns = new Column[size];
        HashSet<Column> unbound = new HashSet<Column>();
        HashSet<Column> unboundNoLogical = new HashSet<Column>();
        for (int index = 0; index < size; ++index) {
            String logicalColumnName = mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(columnNames[index]);
            try {
                String columnName = mappings.getPhysicalColumnName(logicalColumnName, table);
                columns[index] = new Column(columnName);
                unbound.add(columns[index]);
                continue;
            }
            catch (MappingException e) {
                unboundNoLogical.add(new Column(logicalColumnName));
            }
        }
        for (Column column : columns) {
            if (!table.containsColumn(column)) continue;
            UniqueKey uc = table.getOrCreateUniqueKey(keyName);
            uc.addColumn(table.getColumn(column));
            unbound.remove(column);
        }
        if (unbound.size() > 0 || unboundNoLogical.size() > 0) {
            StringBuilder sb = new StringBuilder("Unable to create unique key constraint (");
            for (String columnName : columnNames) {
                sb.append(columnName).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(") on table ").append(table.getName()).append(": ");
            for (Column column : unbound) {
                sb.append(column.getName()).append(", ");
            }
            for (Column column : unboundNoLogical) {
                sb.append(column.getName()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(" not found");
            throw new AnnotationException(sb.toString());
        }
    }

    protected void parseMappingElement(Element subelement, String name) {
        Attribute rsrc = subelement.attribute("resource");
        Attribute file = subelement.attribute("file");
        Attribute jar = subelement.attribute("jar");
        Attribute pckg = subelement.attribute("package");
        Attribute clazz = subelement.attribute("class");
        if (rsrc != null) {
            this.log.debug("{} <- {}", (Object)name, (Object)rsrc);
            this.addResource(rsrc.getValue());
        } else if (jar != null) {
            this.log.debug("{} <- {}", (Object)name, (Object)jar);
            this.addJar(new File(jar.getValue()));
        } else if (file != null) {
            this.log.debug("{} <- {}", (Object)name, (Object)file);
            this.addFile(file.getValue());
        } else if (pckg != null) {
            this.log.debug("{} <- {}", (Object)name, (Object)pckg);
            this.addPackage(pckg.getValue());
        } else if (clazz != null) {
            Class loadedClass;
            this.log.debug("{} <- {}", (Object)name, (Object)clazz);
            try {
                loadedClass = ReflectHelper.classForName((String)clazz.getValue());
            }
            catch (ClassNotFoundException cnf) {
                throw new MappingException("Unable to load class declared as <mapping class=\"" + clazz.getValue() + "\"/> in the configuration:", (Throwable)cnf);
            }
            catch (NoClassDefFoundError ncdf) {
                throw new MappingException("Unable to load class declared as <mapping class=\"" + clazz.getValue() + "\"/> in the configuration:", (Throwable)ncdf);
            }
            this.addAnnotatedClass(loadedClass);
        } else {
            throw new MappingException("<mapping> element in configuration specifies no attributes");
        }
    }

    public void add(Document doc) throws MappingException {
        boolean ejb3Xml = "entity-mappings".equals(doc.getRootElement().getName());
        if (this.inSecondPass) {
            if (!ejb3Xml) {
                super.add(doc);
            }
        } else if (!ejb3Xml) {
            Element hmNode = doc.getRootElement();
            Attribute packNode = hmNode.attribute("package");
            String defaultPackage = packNode != null ? packNode.getValue() : "";
            HashSet<String> entityNames = new HashSet<String>();
            AnnotationConfiguration.findClassNames(defaultPackage, hmNode, entityNames);
            for (String entity : entityNames) {
                this.hbmEntities.put(entity, doc);
            }
            this.hbmDocuments.add(doc);
        } else {
            MetadataProvider metadataProvider = ((MetadataProviderInjector)this.reflectionManager).getMetadataProvider();
            JPAMetadataProvider jpaMetadataProvider = (JPAMetadataProvider)metadataProvider;
            List<String> classnames = jpaMetadataProvider.getXMLContext().addDocument(doc);
            for (String classname : classnames) {
                try {
                    this.annotatedClasses.add(this.reflectionManager.classForName(classname, ((Object)((Object)this)).getClass()));
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to load class defined in XML: " + classname, e);
                }
            }
        }
    }

    private static void findClassNames(String defaultPackage, Element startNode, Set<String> names) {
        Iterator[] classes = new Iterator[]{startNode.elementIterator("class"), startNode.elementIterator("subclass"), startNode.elementIterator("joined-subclass"), startNode.elementIterator("union-subclass")};
        JoinedIterator classIterator = new JoinedIterator(classes);
        while (classIterator.hasNext()) {
            Element element = (Element)classIterator.next();
            String entityName = element.attributeValue("entity-name");
            if (entityName == null) {
                entityName = AnnotationConfiguration.getClassName(element.attribute("name"), defaultPackage);
            }
            names.add(entityName);
            AnnotationConfiguration.findClassNames(defaultPackage, element, names);
        }
    }

    private static String getClassName(Attribute name, String defaultPackage) {
        if (name == null) {
            return null;
        }
        String unqualifiedName = name.getValue();
        if (unqualifiedName == null) {
            return null;
        }
        if (unqualifiedName.indexOf(46) < 0 && defaultPackage != null) {
            return defaultPackage + '.' + unqualifiedName;
        }
        return unqualifiedName;
    }

    public void setPrecedence(String precedence) {
        this.configurationArtefactPrecedence = this.parsePrecedence(precedence);
    }

    private List<ConfigurationArtefactType> parsePrecedence(String s) {
        if (StringHelper.isEmpty((String)s)) {
            return Collections.emptyList();
        }
        StringTokenizer precedences = new StringTokenizer(s, ",; ", false);
        ArrayList<ConfigurationArtefactType> tmpPrecedences = new ArrayList<ConfigurationArtefactType>();
        while (precedences.hasMoreElements()) {
            tmpPrecedences.add(ConfigurationArtefactType.parsePrecedence((String)precedences.nextElement()));
        }
        return tmpPrecedences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationConfiguration addInputStream(InputStream xmlInputStream) throws MappingException {
        try {
            ArrayList<SAXParseException> errors = new ArrayList<SAXParseException>();
            SAXReader saxReader = new SAXReader();
            saxReader.setEntityResolver(this.getEntityResolver());
            saxReader.setErrorHandler((ErrorHandler)new ErrorLogger(errors));
            saxReader.setMergeAdjacentText(true);
            saxReader.setValidation(true);
            this.setValidationFor(saxReader, "orm_2_0.xsd");
            Document doc = null;
            try {
                doc = saxReader.read(new InputSource(xmlInputStream));
            }
            catch (DocumentException e) {
                Throwable throwable = e.getCause();
                if (e.getCause() == null || !(throwable instanceof SAXParseException)) {
                    throw new MappingException("Could not parse JPA mapping document", (Throwable)e);
                }
                errors.add((SAXParseException)throwable);
            }
            boolean isV1Schema = false;
            if (errors.size() != 0) {
                SAXParseException exception = (SAXParseException)errors.get(0);
                String errorMessage = exception.getMessage();
                boolean bl = isV1Schema = doc != null && errorMessage.contains("1.0") && errorMessage.contains("2.0") && errorMessage.contains("version");
            }
            if (isV1Schema) {
                errors.clear();
                this.setValidationFor(saxReader, "orm_1_0.xsd");
                try {
                    saxReader.read((Reader)new StringReader(doc.asXML()));
                }
                catch (DocumentException e) {
                    throw new AssertionFailure("Error in DOM4J leads to a bug in Hibernate", (Throwable)e);
                }
            }
            if (errors.size() != 0) {
                StringBuilder errorMessage = new StringBuilder();
                for (SAXParseException error : errors) {
                    errorMessage.append("Error parsing XML (line").append(error.getLineNumber()).append(" : column ").append(error.getColumnNumber()).append("): ").append(error.getMessage()).append("\n");
                }
                throw new MappingException("Invalid ORM mapping file.\n" + errorMessage.toString());
            }
            this.add(doc);
            AnnotationConfiguration annotationConfiguration = this;
            return annotationConfiguration;
        }
        finally {
            try {
                xmlInputStream.close();
            }
            catch (IOException ioe) {
                this.log.warn("Could not close input stream", (Throwable)ioe);
            }
        }
    }

    private void setValidationFor(SAXReader saxReader, String xsd) {
        try {
            saxReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            saxReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://java.sun.com/xml/ns/persistence/orm " + xsd));
        }
        catch (SAXException e) {
            saxReader.setValidation(false);
        }
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        this.enableLegacyHibernateValidator();
        this.enableBeanValidation();
        this.enableHibernateSearch();
        return super.buildSessionFactory();
    }

    private void enableLegacyHibernateValidator() {
        boolean enableValidatorListeners = !"false".equalsIgnoreCase(this.getProperty("hibernate.validator.autoregister_listeners"));
        Class validateEventListenerClass = null;
        try {
            validateEventListenerClass = ReflectHelper.classForName((String)"org.hibernate.validator.event.ValidateEventListener", AnnotationConfiguration.class);
        }
        catch (ClassNotFoundException e) {
            this.log.debug("Legacy Validator not present in classpath, ignoring event listener registration");
        }
        if (enableValidatorListeners && validateEventListenerClass != null) {
            Object validateEventListener;
            try {
                validateEventListener = validateEventListenerClass.newInstance();
            }
            catch (Exception e) {
                throw new AnnotationException("Unable to load Validator event listener", e);
            }
            boolean present = false;
            PreInsertEventListener[] listeners = this.getEventListeners().getPreInsertEventListeners();
            if (listeners != null) {
                for (PreInsertEventListener eventListener : listeners) {
                    present = present || validateEventListenerClass == eventListener.getClass();
                }
                if (!present) {
                    int length = listeners.length + 1;
                    PreInsertEventListener[] newListeners = new PreInsertEventListener[length];
                    System.arraycopy(listeners, 0, newListeners, 0, length - 1);
                    newListeners[length - 1] = (PreInsertEventListener)validateEventListener;
                    this.getEventListeners().setPreInsertEventListeners(newListeners);
                }
            } else {
                this.getEventListeners().setPreInsertEventListeners(new PreInsertEventListener[]{(PreInsertEventListener)validateEventListener});
            }
            present = false;
            listeners = this.getEventListeners().getPreUpdateEventListeners();
            if (listeners != null) {
                for (PreInsertEventListener eventListener : listeners) {
                    present = present || validateEventListenerClass == eventListener.getClass();
                }
                if (!present) {
                    int length = listeners.length + 1;
                    PreUpdateEventListener[] newListeners = new PreUpdateEventListener[length];
                    System.arraycopy(listeners, 0, newListeners, 0, length - 1);
                    newListeners[length - 1] = (PreUpdateEventListener)validateEventListener;
                    this.getEventListeners().setPreUpdateEventListeners(newListeners);
                }
            } else {
                this.getEventListeners().setPreUpdateEventListeners(new PreUpdateEventListener[]{(PreUpdateEventListener)validateEventListener});
            }
        }
    }

    private void enableBeanValidation() {
        BeanValidationActivator.activateBeanValidation(this.getEventListeners(), this.getProperties());
    }

    private void enableHibernateSearch() {
        Class searchStartupClass;
        try {
            searchStartupClass = ReflectHelper.classForName((String)SEARCH_STARTUP_CLASS, AnnotationConfiguration.class);
        }
        catch (ClassNotFoundException e) {
            try {
                searchStartupClass = ReflectHelper.classForName((String)"org.hibernate.cfg.search.HibernateSearchEventListenerRegister", AnnotationConfiguration.class);
            }
            catch (ClassNotFoundException cnfe) {
                this.log.debug("Search not present in classpath, ignoring event listener registration.");
                return;
            }
        }
        try {
            Object searchStartupInstance = searchStartupClass.newInstance();
            Method enableSearchMethod = searchStartupClass.getDeclaredMethod(SEARCH_STARTUP_METHOD, EventListeners.class, Properties.class);
            enableSearchMethod.invoke(searchStartupInstance, this.getEventListeners(), this.getProperties());
        }
        catch (InstantiationException e) {
            this.log.debug("Unable to instantiate {}, ignoring event listener registration.", (Object)SEARCH_STARTUP_CLASS);
        }
        catch (IllegalAccessException e) {
            this.log.debug("Unable to instantiate {}, ignoring event listener registration.", (Object)SEARCH_STARTUP_CLASS);
        }
        catch (NoSuchMethodException e) {
            this.log.debug("Method enableHibernateSearch() not found in {}.", (Object)SEARCH_STARTUP_CLASS);
        }
        catch (InvocationTargetException e) {
            this.log.debug("Unable to execute {}, ignoring event listener registration.", (Object)SEARCH_STARTUP_METHOD);
        }
    }

    public AnnotationConfiguration addFile(String xmlFile) throws MappingException {
        super.addFile(xmlFile);
        return this;
    }

    public AnnotationConfiguration addFile(File xmlFile) throws MappingException {
        super.addFile(xmlFile);
        return this;
    }

    public AnnotationConfiguration addCacheableFile(File xmlFile) throws MappingException {
        super.addCacheableFile(xmlFile);
        return this;
    }

    public AnnotationConfiguration addCacheableFile(String xmlFile) throws MappingException {
        super.addCacheableFile(xmlFile);
        return this;
    }

    public AnnotationConfiguration addXML(String xml) throws MappingException {
        super.addXML(xml);
        return this;
    }

    public AnnotationConfiguration addURL(URL url) throws MappingException {
        super.addURL(url);
        return this;
    }

    public AnnotationConfiguration addResource(String resourceName, ClassLoader classLoader) throws MappingException {
        super.addResource(resourceName, classLoader);
        return this;
    }

    public AnnotationConfiguration addDocument(org.w3c.dom.Document doc) throws MappingException {
        super.addDocument(doc);
        return this;
    }

    public AnnotationConfiguration addResource(String resourceName) throws MappingException {
        super.addResource(resourceName);
        return this;
    }

    public AnnotationConfiguration addClass(Class persistentClass) throws MappingException {
        super.addClass(persistentClass);
        return this;
    }

    public AnnotationConfiguration addJar(File jar) throws MappingException {
        super.addJar(jar);
        return this;
    }

    public AnnotationConfiguration addDirectory(File dir) throws MappingException {
        super.addDirectory(dir);
        return this;
    }

    public AnnotationConfiguration setInterceptor(Interceptor interceptor) {
        super.setInterceptor(interceptor);
        return this;
    }

    public AnnotationConfiguration setProperties(Properties properties) {
        super.setProperties(properties);
        return this;
    }

    public AnnotationConfiguration addProperties(Properties extraProperties) {
        super.addProperties(extraProperties);
        return this;
    }

    public AnnotationConfiguration mergeProperties(Properties properties) {
        super.mergeProperties(properties);
        return this;
    }

    public AnnotationConfiguration setProperty(String propertyName, String value) {
        super.setProperty(propertyName, value);
        return this;
    }

    public AnnotationConfiguration configure() throws HibernateException {
        super.configure();
        return this;
    }

    public AnnotationConfiguration configure(String resource) throws HibernateException {
        super.configure(resource);
        return this;
    }

    public AnnotationConfiguration configure(URL url) throws HibernateException {
        super.configure(url);
        return this;
    }

    public AnnotationConfiguration configure(File configFile) throws HibernateException {
        super.configure(configFile);
        return this;
    }

    protected AnnotationConfiguration doConfigure(InputStream stream, String resourceName) throws HibernateException {
        super.doConfigure(stream, resourceName);
        return this;
    }

    public AnnotationConfiguration configure(org.w3c.dom.Document document) throws HibernateException {
        super.configure(document);
        return this;
    }

    protected AnnotationConfiguration doConfigure(Document doc) throws HibernateException {
        super.doConfigure(doc);
        return this;
    }

    public AnnotationConfiguration setCacheConcurrencyStrategy(String clazz, String concurrencyStrategy) throws MappingException {
        super.setCacheConcurrencyStrategy(clazz, concurrencyStrategy);
        return this;
    }

    public AnnotationConfiguration setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy) throws MappingException {
        super.setCollectionCacheConcurrencyStrategy(collectionRole, concurrencyStrategy);
        return this;
    }

    public AnnotationConfiguration setNamingStrategy(NamingStrategy namingStrategy) {
        super.setNamingStrategy(namingStrategy);
        return this;
    }

    public ReflectionManager getReflectionManager() {
        return this.reflectionManager;
    }

    static {
        Version.touch();
        DEFAULT_ARTEFACT_PROCESSING_ORDER = new ConfigurationArtefactType[]{ConfigurationArtefactType.HBM, ConfigurationArtefactType.CLASS};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorLogger
    implements ErrorHandler {
        private List<SAXParseException> errors;

        public ErrorLogger(List<SAXParseException> errors) {
            this.errors = errors;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }
    }

    private static class CacheHolder {
        public String role;
        public String usage;
        public String region;
        public boolean isClass;
        public boolean cacheLazy;

        public CacheHolder(String role, String usage, String region, boolean isClass, boolean cacheLazy) {
            this.role = role;
            this.usage = usage;
            this.region = region;
            this.isClass = isClass;
            this.cacheLazy = cacheLazy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExtendedMappingsImpl
    extends Configuration.MappingsImpl
    implements ExtendedMappings {
        private Boolean useNewGeneratorMappings;
        private Collection<FetchProfile> annotationConfiguredProfile;

        public ExtendedMappingsImpl() {
            super((Configuration)AnnotationConfiguration.this);
            this.annotationConfiguredProfile = new ArrayList<FetchProfile>();
        }

        @Override
        public void addDefaultGenerator(IdGenerator generator) {
            this.addGenerator(generator);
            AnnotationConfiguration.this.defaultNamedGenerators.add(generator.getName());
        }

        @Override
        public boolean isInSecondPass() {
            return AnnotationConfiguration.this.inSecondPass;
        }

        @Override
        public PropertyData getPropertyAnnotatedWithMapsId(XClass entityType, String propertyName) {
            Map map = (Map)AnnotationConfiguration.this.propertiesAnnotatedWithMapsId.get(entityType);
            return map == null ? null : (PropertyData)map.get(propertyName);
        }

        @Override
        public void addPropertyAnnotatedWithMapsId(XClass entityType, PropertyData property) {
            HashMap<String, PropertyData> map = (HashMap<String, PropertyData>)AnnotationConfiguration.this.propertiesAnnotatedWithMapsId.get(entityType);
            if (map == null) {
                map = new HashMap<String, PropertyData>();
                AnnotationConfiguration.this.propertiesAnnotatedWithMapsId.put(entityType, map);
            }
            map.put(((MapsId)property.getProperty().getAnnotation(MapsId.class)).value(), property);
        }

        @Override
        public PropertyData getPropertyAnnotatedWithIdAndToOne(XClass entityType, String propertyName) {
            Map map = (Map)AnnotationConfiguration.this.propertiesAnnotatedWithIdAndToOne.get(entityType);
            return map == null ? null : (PropertyData)map.get(propertyName);
        }

        @Override
        public void addToOneAndIdProperty(XClass entityType, PropertyData property) {
            HashMap<String, PropertyData> map = (HashMap<String, PropertyData>)AnnotationConfiguration.this.propertiesAnnotatedWithIdAndToOne.get(entityType);
            if (map == null) {
                map = new HashMap<String, PropertyData>();
                AnnotationConfiguration.this.propertiesAnnotatedWithIdAndToOne.put(entityType, map);
            }
            map.put(property.getPropertyName(), property);
        }

        @Override
        public boolean useNewGeneratorMappings() {
            if (this.useNewGeneratorMappings == null) {
                String booleanName = this.getConfigurationProperties().getProperty(AnnotationConfiguration.USE_NEW_ID_GENERATOR_MAPPINGS);
                this.useNewGeneratorMappings = Boolean.valueOf(booleanName);
            }
            return this.useNewGeneratorMappings;
        }

        @Override
        public IdGenerator getGenerator(String name) {
            return this.getGenerator(name, null);
        }

        @Override
        public IdGenerator getGenerator(String name, Map<String, IdGenerator> localGenerators) {
            IdGenerator result;
            if (localGenerators != null && (result = localGenerators.get(name)) != null) {
                return result;
            }
            return (IdGenerator)AnnotationConfiguration.this.namedGenerators.get(name);
        }

        @Override
        public void addGenerator(IdGenerator generator) {
            IdGenerator old;
            if (!AnnotationConfiguration.this.defaultNamedGenerators.contains(generator.getName()) && (old = AnnotationConfiguration.this.namedGenerators.put(generator.getName(), generator)) != null) {
                AnnotationConfiguration.this.log.warn("duplicate generator name {}", (Object)old.getName());
            }
        }

        @Override
        public void addGeneratorTable(String name, Properties params) {
            Properties old = AnnotationConfiguration.this.generatorTables.put(name, params);
            if (old != null) {
                AnnotationConfiguration.this.log.warn("duplicate generator table: {}", (Object)name);
            }
        }

        @Override
        public Properties getGeneratorTableProperties(String name, Map<String, Properties> localGeneratorTables) {
            Properties result;
            if (localGeneratorTables != null && (result = localGeneratorTables.get(name)) != null) {
                return result;
            }
            return (Properties)AnnotationConfiguration.this.generatorTables.get(name);
        }

        @Override
        public Map<String, Join> getJoins(String entityName) {
            return (Map)AnnotationConfiguration.this.joins.get(entityName);
        }

        @Override
        public void addJoins(PersistentClass persistentClass, Map<String, Join> joins) {
            Map<String, Join> old = AnnotationConfiguration.this.joins.put(persistentClass.getEntityName(), joins);
            if (old != null) {
                AnnotationConfiguration.this.log.warn("duplicate joins for class: {}", (Object)persistentClass.getEntityName());
            }
        }

        @Override
        public AnnotatedClassType getClassType(XClass clazz) {
            AnnotatedClassType type = (AnnotatedClassType)((Object)AnnotationConfiguration.this.classTypes.get(clazz.getName()));
            if (type == null) {
                return this.addClassType(clazz);
            }
            return type;
        }

        @Override
        public AnnotatedClassType addClassType(XClass clazz) {
            AnnotatedClassType type = clazz.isAnnotationPresent(Entity.class) ? AnnotatedClassType.ENTITY : (clazz.isAnnotationPresent(Embeddable.class) ? AnnotatedClassType.EMBEDDABLE : (clazz.isAnnotationPresent(MappedSuperclass.class) ? AnnotatedClassType.EMBEDDABLE_SUPERCLASS : AnnotatedClassType.NONE));
            AnnotationConfiguration.this.classTypes.put(clazz.getName(), type);
            return type;
        }

        @Override
        public Map<Table, List<String[]>> getTableUniqueConstraints() {
            HashMap<Table, List<String[]>> deprecatedStructure = new HashMap<Table, List<String[]>>(CollectionHelper.determineProperSizing(this.getUniqueConstraintHoldersByTable()), 0.75f);
            for (Map.Entry<Table, List<UniqueConstraintHolder>> entry : this.getUniqueConstraintHoldersByTable().entrySet()) {
                ArrayList<String[]> columnsPerConstraint = new ArrayList<String[]>(CollectionHelper.determineProperSizing((int)entry.getValue().size()));
                deprecatedStructure.put(entry.getKey(), columnsPerConstraint);
                for (UniqueConstraintHolder holder : entry.getValue()) {
                    columnsPerConstraint.add(holder.getColumns());
                }
            }
            return deprecatedStructure;
        }

        @Override
        public Map<Table, List<UniqueConstraintHolder>> getUniqueConstraintHoldersByTable() {
            return AnnotationConfiguration.this.uniqueConstraintHoldersByTable;
        }

        @Override
        public void addUniqueConstraints(Table table, List uniqueConstraints) {
            ArrayList<UniqueConstraintHolder> constraintHolders = new ArrayList<UniqueConstraintHolder>(CollectionHelper.determineProperSizing((int)uniqueConstraints.size()));
            int keyNameBase = this.determineCurrentNumberOfUniqueConstraintHolders(table);
            for (String[] columns : uniqueConstraints) {
                String keyName = "key" + keyNameBase++;
                constraintHolders.add(new UniqueConstraintHolder().setName(keyName).setColumns(columns));
            }
            this.addUniqueConstraintHolders(table, constraintHolders);
        }

        private int determineCurrentNumberOfUniqueConstraintHolders(Table table) {
            List<UniqueConstraintHolder> currentHolders = this.getUniqueConstraintHoldersByTable().get(table);
            return currentHolders == null ? 0 : currentHolders.size();
        }

        @Override
        public void addUniqueConstraintHolders(Table table, List<UniqueConstraintHolder> uniqueConstraintHolders) {
            List<UniqueConstraintHolder> holderList = this.getUniqueConstraintHoldersByTable().get(table);
            if (holderList == null) {
                holderList = new ArrayList<UniqueConstraintHolder>();
                this.getUniqueConstraintHoldersByTable().put(table, holderList);
            }
            holderList.addAll(uniqueConstraintHolders);
        }

        @Override
        public void addMappedBy(String entityName, String propertyName, String inversePropertyName) {
            AnnotationConfiguration.this.mappedByResolver.put(entityName + "." + propertyName, inversePropertyName);
        }

        @Override
        public String getFromMappedBy(String entityName, String propertyName) {
            return (String)AnnotationConfiguration.this.mappedByResolver.get(entityName + "." + propertyName);
        }

        @Override
        public void addPropertyReferencedAssociation(String entityName, String propertyName, String propertyRef) {
            AnnotationConfiguration.this.propertyRefResolver.put(entityName + "." + propertyName, propertyRef);
        }

        @Override
        public String getPropertyReferencedAssociation(String entityName, String propertyName) {
            return (String)AnnotationConfiguration.this.propertyRefResolver.get(entityName + "." + propertyName);
        }

        public void addUniquePropertyReference(String referencedClass, String propertyName) {
            super.addUniquePropertyReference(referencedClass, propertyName);
        }

        public void addPropertyReference(String referencedClass, String propertyName) {
            super.addPropertyReference(referencedClass, propertyName);
        }

        @Override
        public ReflectionManager getReflectionManager() {
            return AnnotationConfiguration.this.reflectionManager;
        }

        @Override
        public void addDefaultQuery(String name, NamedQueryDefinition query) {
            super.addQuery(name, query);
            AnnotationConfiguration.this.defaultNamedQueryNames.add(name);
        }

        @Override
        public void addDefaultSQLQuery(String name, NamedSQLQueryDefinition query) {
            super.addSQLQuery(name, query);
            AnnotationConfiguration.this.defaultNamedNativeQueryNames.add(name);
        }

        @Override
        public void addDefaultResultSetMapping(ResultSetMappingDefinition definition) {
            String name = definition.getName();
            if (!AnnotationConfiguration.this.defaultSqlResulSetMappingNames.contains(name) && super.getResultSetMapping(name) != null) {
                this.removeResultSetMapping(name);
            }
            super.addResultSetMapping(definition);
            AnnotationConfiguration.this.defaultSqlResulSetMappingNames.add(name);
        }

        public void addQuery(String name, NamedQueryDefinition query) throws DuplicateMappingException {
            if (!AnnotationConfiguration.this.defaultNamedQueryNames.contains(name)) {
                super.addQuery(name, query);
            }
        }

        public void addResultSetMapping(ResultSetMappingDefinition definition) throws DuplicateMappingException {
            if (!AnnotationConfiguration.this.defaultSqlResulSetMappingNames.contains(definition.getName())) {
                super.addResultSetMapping(definition);
            }
        }

        public void addSQLQuery(String name, NamedSQLQueryDefinition query) throws DuplicateMappingException {
            if (!AnnotationConfiguration.this.defaultNamedNativeQueryNames.contains(name)) {
                super.addSQLQuery(name, query);
            }
        }

        @Override
        public Map getClasses() {
            return AnnotationConfiguration.this.classes;
        }

        @Override
        public void addAnyMetaDef(AnyMetaDef defAnn) throws AnnotationException {
            if (AnnotationConfiguration.this.anyMetaDefs.containsKey(defAnn.name())) {
                throw new AnnotationException("Two @AnyMetaDef with the same name defined: " + defAnn.name());
            }
            AnnotationConfiguration.this.anyMetaDefs.put(defAnn.name(), defAnn);
        }

        @Override
        public AnyMetaDef getAnyMetaDef(String name) {
            return (AnyMetaDef)AnnotationConfiguration.this.anyMetaDefs.get(name);
        }

        @Override
        public void addAnnotationConfiguredFetchProfile(FetchProfile fetchProfile) {
            this.annotationConfiguredProfile.add(fetchProfile);
        }

        @Override
        public boolean containsAnnotationConfiguredFetchProfile(FetchProfile fetchProfile) {
            for (FetchProfile profile : this.annotationConfiguredProfile) {
                if (profile != fetchProfile) continue;
                return true;
            }
            return false;
        }
    }
}

