/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ppg.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.ppg.generator.GeneratorException;
import org.infinispan.ppg.generator.RuleDefinition;

public class Machine {
    private static final String INDENT = "\t\t\t";
    private final List<String> imports = new ArrayList<String>();
    private final Map<String, String> variables = new HashMap<String, String>();
    private final String pkg;
    private final String simpleName;
    private final String baseClassName;
    private final String initAction;
    private final String exceptionally;
    private final String deadEnd;
    private final int maxSwitchStates;
    private final int userSwitchThreshold;
    private final int switchShift;
    private final boolean passContext;
    private List<State> states = new ArrayList<State>();

    public Machine(String pkg, String simpleName, String baseClassName, String initAction, String exceptionally, String deadEnd, int maxSwitchStates, int userSwitchThreshold, boolean passContext) {
        this.pkg = pkg;
        this.simpleName = simpleName;
        this.baseClassName = baseClassName;
        this.initAction = initAction;
        this.exceptionally = exceptionally;
        this.deadEnd = deadEnd;
        this.maxSwitchStates = Integer.highestOneBit(maxSwitchStates - 1) << 1;
        this.userSwitchThreshold = userSwitchThreshold;
        this.switchShift = 32 - Integer.numberOfLeadingZeros(maxSwitchStates - 1);
        this.passContext = passContext;
    }

    public State addState(List<RuleDefinition> ruleStack) {
        State s = new State(Machine.stackComment(ruleStack));
        s.id = this.states.size();
        this.states.add(s);
        return s;
    }

    /*
     * WARNING - void declaration
     */
    public String buildSource() {
        StringBuilder sb = new StringBuilder();
        StringBuilder extraMethods = new StringBuilder();
        sb.append("package ").append(this.pkg).append(";\n");
        sb.append("import java.util.List;\n");
        sb.append("import io.netty.buffer.ByteBuf;\n");
        sb.append("import io.netty.channel.ChannelHandlerContext;\n");
        if (this.baseClassName == null) {
            sb.append("import io.netty.handler.codec.ByteToMessageDecoder;\n");
        }
        for (String string : this.imports) {
            sb.append("import ").append(string).append(";\n");
        }
        sb.append("\npublic class ").append(this.simpleName).append(" extends ");
        sb.append(this.baseClassName != null ? this.baseClassName : "ByteToMessageDecoder").append(" {\n");
        sb.append("\tprivate int state;\n");
        sb.append("\tprivate int requestBytes;\n\n");
        for (Map.Entry entry : this.variables.entrySet()) {
            sb.append("\tprivate ").append((String)entry.getValue()).append(' ').append((String)entry.getKey()).append(";\n");
        }
        sb.append("\n");
        if (this.initAction != null) {
            sb.append(this.prettyPrint(this.initAction, 1)).append("\n");
        }
        int numLevels = (32 - Integer.numberOfLeadingZeros(this.states.size() - 1)) / this.switchShift + 1;
        sb.append("\t@Override\n");
        sb.append("\tpublic void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {\n");
        sb.append("\t\tint pos = buf.readerIndex();\n");
        sb.append("\t\ttry {\n");
        sb.append("\t\t\twhile (switch").append(numLevels > 1 ? numLevels - 1 + "_" : "").append("0(");
        if (this.passContext) {
            sb.append("ctx, ");
        }
        sb.append("buf));\n");
        sb.append("\t\t} catch (Throwable t) {\n");
        if (this.exceptionally == null) {
            sb.append("\t\t\tthrow t;\n");
        } else {
            sb.append("\t\t\texceptionally(t);\n");
        }
        sb.append("\t\t} finally {\n");
        sb.append("\t\t\trequestBytes += buf.readerIndex() - pos;\n");
        sb.append("\t\t}\n");
        sb.append("\t}\n\n");
        this.writeSwitch(sb, numLevels - 1, 0);
        boolean bl = false;
        for (State state : this.states) {
            if (state.id % this.maxSwitchStates == 0) {
                void var4_9;
                if (var4_9 != false) {
                    sb.append("\t\t}\n\t\treturn true;\n\t}\n\n");
                }
                sb.append("\tprivate boolean switch").append((int)(++var4_9)).append('(');
                if (this.passContext) {
                    sb.append("ChannelHandlerContext ctx, ");
                }
                sb.append("ByteBuf buf) throws Exception {\n");
                sb.append("\t\tbyte b;\n");
                sb.append("\t\tint pos;\n");
                sb.append("\t\tswitch (state) {\n");
            }
            sb.append("\t\tcase ").append(state.id).append(": \n");
            state.toSource(sb, extraMethods);
        }
        sb.append("\t\t}\n\t\treturn true;\n\t}\n\n");
        sb.append("\tprivate void deadEnd() {\n");
        if (this.deadEnd != null) {
            sb.append(this.prettyPrint(this.deadEnd, 2)).append("\n");
        } else {
            sb.append("\t\tthrow new IllegalArgumentException();\n");
        }
        sb.append("\t}\n\n");
        if (this.exceptionally != null) {
            sb.append("\tprivate void exceptionally(Throwable t) throws Exception {\n");
            sb.append(this.prettyPrint(this.exceptionally, 2)).append("\n");
            sb.append("\t}\n\n");
        }
        sb.append("\tprivate void reset() {\n");
        sb.append("\t\trequestBytes = 0;");
        for (Map.Entry entry : this.variables.entrySet()) {
            sb.append("\t\t").append((String)entry.getKey()).append(" = ").append(this.defaultFor((String)entry.getValue())).append(";\n");
        }
        sb.append("\t}\n\n");
        sb.append("\tpublic int requestBytes() {\n");
        sb.append("\t\treturn requestBytes;\n");
        sb.append("\t}\n");
        if (extraMethods.length() > 0) {
            sb.append("\n").append((CharSequence)extraMethods);
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String prettyPrint(String code, int indent) {
        String[] lines = code.split("\n", 0);
        StringBuilder sb = new StringBuilder();
        for (int ln = 0; ln < lines.length; ++ln) {
            int i;
            String line = lines[ln];
            int addIndent = 0;
            block5: for (i = 0; i < line.length(); ++i) {
                switch (line.charAt(i)) {
                    case '{': {
                        ++addIndent;
                        continue block5;
                    }
                    case '}': {
                        --indent;
                    }
                }
            }
            for (i = 0; i < indent; ++i) {
                sb.append('\t');
            }
            sb.append(line.trim());
            indent += addIndent;
            if (ln != lines.length - 1) {
                sb.append('\n');
            }
            if (indent != 1 || !line.trim().equals("}")) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private void writeSwitch(StringBuilder sb, int level, int offset) {
        int s;
        if (level < 1) {
            return;
        }
        sb.append("\tprivate boolean switch").append(level).append('_').append(offset).append('(');
        if (this.passContext) {
            sb.append("ChannelHandlerContext ctx, ");
        }
        sb.append("ByteBuf buf) throws Exception {\n");
        sb.append("\t\tswitch (state >> ").append(level * this.switchShift).append(") {\n");
        for (s = 0; s < this.maxSwitchStates && s + offset << level * this.switchShift < this.states.size(); ++s) {
            sb.append("\t\tcase ").append(s).append(": return switch");
            if (level > 1) {
                sb.append(level - 1).append('_').append(offset);
            } else {
                sb.append(s + offset);
            }
            sb.append('(');
            if (this.passContext) {
                sb.append("ctx, ");
            }
            sb.append("buf);\n");
        }
        sb.append("\t\tdefault: throw new IllegalStateException();\n");
        sb.append("\t\t}\n\t}\n\n");
        for (s = 0; s < this.maxSwitchStates && s + offset << level * this.switchShift < this.states.size(); ++s) {
            this.writeSwitch(sb, level - 1, (offset << this.switchShift) + s);
        }
    }

    private String defaultFor(String type) {
        switch (type) {
            case "int": 
            case "long": 
            case "byte": 
            case "short": 
            case "double": 
            case "float": 
            case "char": {
                return "0";
            }
            case "boolean": {
                return "false";
            }
        }
        return "null";
    }

    public void addVariable(String type, String name) {
        this.variables.put(name, type);
    }

    public void addImport(String className) {
        this.imports.add(className);
    }

    public void contractStates() {
        boolean contracted;
        do {
            contracted = false;
            Iterator<State> iterator = this.states.iterator();
            while (iterator.hasNext()) {
                State s = iterator.next();
                if (s.links.size() != 1 || ((Link)((State)s).links.get((int)0)).type != LinkType.BACKTRACK) continue;
                Link l = (Link)s.links.get(0);
                boolean contractedNow = false;
                for (State s2 : this.states) {
                    for (Link l2 : s2.links) {
                        if (l2.next != s || l2.type == LinkType.SENTINEL) continue;
                        l2.code = l2.code + "\n" + l.code;
                        l2.next = l.next;
                        contractedNow = true;
                    }
                }
                if (!contractedNow) continue;
                iterator.remove();
                contracted = true;
            }
        } while (contracted);
        for (int i = 0; i < this.states.size(); ++i) {
            this.states.get(i).id = i;
        }
    }

    private static String stackComment(List<RuleDefinition> ruleStack) {
        return ruleStack.stream().map(r -> r.qualifiedName).collect(Collectors.joining("/"));
    }

    static enum LinkType {
        ACTION,
        SENTINEL,
        BACKTRACK;

    }

    class Link {
        final LinkType type;
        String code;
        State next;

        Link(LinkType type, State target) {
            this.type = type;
            this.next = target;
        }
    }

    class State {
        private final String comment;
        private List<Link> links = new ArrayList<Link>();
        private int id;
        private String switchOn;

        private State(String comment) {
            this.comment = comment;
        }

        public State requireReadByte(String value, State target) {
            Link link = new Link(LinkType.ACTION, target);
            link.code = "if (!buf.isReadable()) return;\nb = buf.readByte();\nif ((0xFF & b) != " + value + ") deadEnd();";
            this.links.add(link);
            return link.next;
        }

        public State requireCall(String call, State target, List<RuleDefinition> ruleStack) {
            Link link = new Link(LinkType.ACTION, target);
            link.code = "pos = buf.readerIndex();\n" + call + ";\nif (buf.readerIndex() == pos) return false;";
            this.links.add(link);
            return link.next;
        }

        public State addSentinel(String sentinel, State target) {
            Link link = new Link(LinkType.SENTINEL, target);
            link.code = sentinel;
            this.links.add(link);
            return link.next;
        }

        public State addAction(String action, State target) {
            Link link = new Link(LinkType.ACTION, target);
            link.code = action;
            this.links.add(link);
            return link.next;
        }

        public State addBacktrack(String action, State target) {
            Link link = new Link(LinkType.BACKTRACK, target);
            link.code = action;
            this.links.add(link);
            return link.next;
        }

        void toSource(StringBuilder sb, StringBuilder extraMethods) {
            sb.append(Machine.INDENT).append("// ").append(this.comment).append("\n");
            if (this.links.isEmpty()) {
                sb.append(Machine.INDENT).append("deadEnd();\n");
                return;
            }
            String indent = Machine.INDENT;
            if (this.switchOn != null) {
                if (this.links.size() > Machine.this.userSwitchThreshold) {
                    sb.append(indent).append("return userSwitch").append(this.id).append("();\n");
                    extraMethods.append("\tprivate boolean userSwitch").append(this.id).append("() throws Exception {\n");
                    sb = extraMethods;
                    indent = "\t\t";
                }
                sb.append(indent).append("switch (").append(this.switchOn).append(") {\n");
            }
            Iterator<Link> iterator = this.links.iterator();
            while (iterator.hasNext()) {
                Link link = iterator.next();
                if (link.next != null && link.next != Machine.this.states.get(link.next.id)) {
                    throw new IllegalStateException("Target state was deleted!");
                }
                if (link.type == LinkType.SENTINEL) {
                    if (this.switchOn == null) {
                        sb.append(indent).append("if (").append(link.code).append(") {\n");
                    } else {
                        sb.append(indent).append("case ").append(link.code).append(": \n");
                    }
                    if (link.next != null) {
                        sb.append(indent).append("\tstate = ").append(link.next.id).append(";\n");
                        sb.append(indent).append("\treturn true;\n");
                    }
                    if (this.switchOn == null) {
                        sb.append(indent).append("}\n");
                    }
                } else {
                    if (this.switchOn != null) {
                        sb.append(indent).append("default: \n");
                        indent = indent + "\t";
                    }
                    sb.append(indent).append(link.code.replaceAll("\n", "\n" + indent)).append("\n");
                    if (link.next != null) {
                        sb.append(indent).append("state = ").append(link.next.id).append(";\n");
                        if (this.switchOn != null) {
                            indent = indent.substring(0, indent.length() - 1);
                            sb.append(indent).append("}\n");
                        }
                        if (link.next.id == this.id + 1) {
                            sb.append(indent).append("// fallthrough\n");
                        } else {
                            sb.append(indent).append("return true;\n");
                        }
                    } else if (this.switchOn != null) {
                        indent = indent.substring(0, indent.length() - 1);
                        sb.append(indent).append("}\n");
                    }
                }
                if (iterator.hasNext() && link.type != LinkType.SENTINEL) {
                    throw new GeneratorException("Branching without a sentinel");
                }
                if (iterator.hasNext() || link.type != LinkType.SENTINEL) continue;
                if (this.switchOn != null) {
                    sb.append(indent).append("default:\n");
                    sb.append(indent).append("\texceptionally(new IllegalArgumentException('").append(this.switchOn).append(" + \"' does not match any of the switch cases.\"));\n");
                    sb.append("}\n");
                    continue;
                }
                sb.append(indent).append("deadEnd();\n");
                sb.append(indent).append("return true;\n");
            }
            if (sb == extraMethods) {
                extraMethods.append("\t}\n\n");
            }
        }

        public void setSwitch(String var) {
            this.switchOn = var;
        }
    }
}

