/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.util.CertificateValidatorBuilder;

public class SSLSocketFactoryProvider {
    private X509Credential credential;
    private X509CertChainValidatorExt validator;

    public SSLSocketFactoryProvider(X509Credential credential, X509CertChainValidatorExt validator) {
        this.credential = credential;
        this.validator = validator;
    }

    public SSLSocketFactoryProvider(X509Credential credential) {
        this(credential, new CertificateValidatorBuilder().trustAnchorsUpdateInterval(60000L).build());
    }

    public SSLSocketFactory getSSLSockectFactory() {
        SSLContext context = null;
        try {
            context = SSLContext.getInstance("SSLv3");
        }
        catch (NoSuchAlgorithmException e) {
            throw new VOMSError(e.getMessage(), e);
        }
        KeyManager[] keyManagers = new KeyManager[]{this.credential.getKeyManager()};
        X509TrustManager trustManager = SocketFactoryCreator.getSSLTrustManager((X509CertChainValidator)this.validator);
        TrustManager[] trustManagers = new TrustManager[]{trustManager};
        SecureRandom secureRandom = null;
        secureRandom = new SecureRandom();
        try {
            context.init(keyManagers, trustManagers, secureRandom);
        }
        catch (KeyManagementException e) {
            throw new VOMSError(e.getMessage(), e);
        }
        return context.getSocketFactory();
    }
}

