/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.X509Credential;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.request.VOMSACRequest;
import org.italiangrid.voms.request.VOMSACService;
import org.italiangrid.voms.request.VOMSESLookupStrategy;
import org.italiangrid.voms.request.VOMSProtocol;
import org.italiangrid.voms.request.VOMSProtocolError;
import org.italiangrid.voms.request.VOMSProtocolListener;
import org.italiangrid.voms.request.VOMSRequestListener;
import org.italiangrid.voms.request.VOMSResponse;
import org.italiangrid.voms.request.VOMSServerInfo;
import org.italiangrid.voms.request.VOMSServerInfoStore;
import org.italiangrid.voms.request.VOMSServerInfoStoreListener;
import org.italiangrid.voms.request.impl.AbstractVOMSProtocol;
import org.italiangrid.voms.request.impl.DefaultVOMSServerInfoStore;
import org.italiangrid.voms.request.impl.LegacyProtocol;
import org.italiangrid.voms.request.impl.RESTProtocol;
import org.italiangrid.voms.util.NullListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVOMSACService
implements VOMSACService {
    protected VOMSRequestListener requestListener;
    protected VOMSProtocolListener protocolListener;
    protected X509CertChainValidatorExt validator;
    protected VOMSServerInfoStore serverInfoStore;
    protected VOMSProtocol httpProtocol;
    protected VOMSProtocol legacyProtocol;

    protected DefaultVOMSACService(Builder builder) {
        this.validator = builder.validator;
        this.requestListener = builder.requestListener;
        this.protocolListener = builder.protocolListener;
        this.serverInfoStore = builder.serverInfoStore;
        this.httpProtocol = builder.httpProtocol;
        this.legacyProtocol = builder.legacyProtocol;
    }

    protected AttributeCertificate getACFromResponse(VOMSACRequest request, VOMSResponse response) {
        byte[] acBytes = response.getAC();
        if (acBytes == null) {
            return null;
        }
        ASN1InputStream asn1InputStream = new ASN1InputStream(acBytes);
        AttributeCertificate attributeCertificate = null;
        try {
            attributeCertificate = AttributeCertificate.getInstance((Object)asn1InputStream.readObject());
            asn1InputStream.close();
            return attributeCertificate;
        }
        catch (Throwable e) {
            this.requestListener.notifyVOMSRequestFailure(request, null, new VOMSError("Error unmarshalling VOMS AC. Cause: " + e.getMessage(), e));
            return null;
        }
    }

    private VOMSResponse doRequest(VOMSProtocol protocol, VOMSServerInfo endpoint, X509Credential cred, VOMSACRequest req) {
        VOMSResponse response = null;
        try {
            response = protocol.doRequest(endpoint, cred, req);
        }
        catch (VOMSProtocolError e) {
            this.requestListener.notifyVOMSRequestFailure(req, endpoint, e);
        }
        return response;
    }

    protected void handleErrorsInResponse(VOMSACRequest request, VOMSServerInfo si, VOMSResponse response) {
        if (response.hasErrors()) {
            this.requestListener.notifyErrorsInVOMSReponse(request, si, response.errorMessages());
        }
    }

    protected void handleWarningsInResponse(VOMSACRequest request, VOMSServerInfo si, VOMSResponse response) {
        if (response.hasWarnings()) {
            this.requestListener.notifyWarningsInVOMSResponse(request, si, response.warningMessages());
        }
    }

    @Override
    public AttributeCertificate getVOMSAttributeCertificate(X509Credential credential, VOMSACRequest request) {
        List<VOMSServerInfo> vomsServerInfos = this.getVOMSServerInfos(request);
        if (vomsServerInfos.isEmpty()) {
            throw new VOMSError("VOMS server for VO " + request.getVoName() + " " + "is not known! Check your vomses configuration.");
        }
        VOMSResponse response = null;
        AttributeCertificate vomsAC = null;
        for (VOMSServerInfo vomsServerInfo : vomsServerInfos) {
            this.requestListener.notifyVOMSRequestStart(request, vomsServerInfo);
            response = this.doRequest(this.httpProtocol, vomsServerInfo, credential, request);
            if (response == null) {
                response = this.doRequest(this.legacyProtocol, vomsServerInfo, credential, request);
            }
            if (response == null) {
                this.requestListener.notifyVOMSRequestFailure(request, vomsServerInfo, new VOMSError("REST and legacy VOMS endpoints failed."));
                continue;
            }
            this.requestListener.notifyVOMSRequestSuccess(request, vomsServerInfo);
            this.handleErrorsInResponse(request, vomsServerInfo, response);
            this.handleWarningsInResponse(request, vomsServerInfo, response);
            vomsAC = this.getACFromResponse(request, response);
            if (response.hasErrors() || vomsAC == null) continue;
            return vomsAC;
        }
        this.requestListener.notifyVOMSRequestFailure(request, null, null);
        return null;
    }

    protected List<VOMSServerInfo> getVOMSServerInfos(VOMSACRequest request) {
        ArrayList<VOMSServerInfo> vomsServerInfos = new ArrayList<VOMSServerInfo>(this.serverInfoStore.getVOMSServerInfo(request.getVoName()));
        if (!vomsServerInfos.isEmpty()) {
            Collections.shuffle(vomsServerInfos);
        }
        return vomsServerInfos;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private VOMSRequestListener requestListener = NullListener.INSTANCE;
        private VOMSProtocolListener protocolListener = NullListener.INSTANCE;
        private VOMSServerInfoStoreListener storeListener = NullListener.INSTANCE;
        private X509CertChainValidatorExt validator;
        private VOMSServerInfoStore serverInfoStore;
        private VOMSESLookupStrategy vomsesLookupStrategy;
        private List<String> vomsesLocations;
        private int connectTimeout = 2000;
        private int readTimeout = 5000;
        private boolean skipHostnameChecks = true;
        protected VOMSProtocol httpProtocol;
        protected VOMSProtocol legacyProtocol;

        public Builder(X509CertChainValidatorExt certChainValidator) {
            if (certChainValidator == null) {
                throw new NullPointerException("Please provide a non-null certificate chain validator");
            }
            this.validator = certChainValidator;
        }

        public Builder requestListener(VOMSRequestListener l) {
            this.requestListener = l;
            return this;
        }

        public Builder serverInfoStoreListener(VOMSServerInfoStoreListener sl) {
            this.storeListener = sl;
            return this;
        }

        public Builder serverInfoStore(VOMSServerInfoStore sis) {
            this.serverInfoStore = sis;
            return this;
        }

        public Builder protocolListener(VOMSProtocolListener pl) {
            this.protocolListener = pl;
            return this;
        }

        public Builder connectTimeout(int timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public Builder readTimeout(int timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public Builder skipHostnameChecks(boolean s) {
            this.skipHostnameChecks = s;
            return this;
        }

        public Builder vomsesLookupStrategy(VOMSESLookupStrategy strategy) {
            this.vomsesLookupStrategy = strategy;
            return this;
        }

        public Builder vomsesLocations(List<String> vomsesLocations) {
            this.vomsesLocations = vomsesLocations;
            return this;
        }

        public Builder httpProtocol(VOMSProtocol httpProtocol) {
            this.httpProtocol = httpProtocol;
            return this;
        }

        public Builder legacyProtocol(VOMSProtocol legacyProtocol) {
            this.legacyProtocol = legacyProtocol;
            return this;
        }

        protected void buildServerInfoStore() {
            if (this.serverInfoStore != null) {
                return;
            }
            this.serverInfoStore = new DefaultVOMSServerInfoStore.Builder().lookupStrategy(this.vomsesLookupStrategy).storeListener(this.storeListener).vomsesPaths(this.vomsesLocations).build();
        }

        protected void buildProtocols() {
            AbstractVOMSProtocol p;
            if (this.httpProtocol == null) {
                p = new RESTProtocol(this.validator, this.protocolListener, this.connectTimeout, this.readTimeout);
                p.setSkipHostnameChecks(this.skipHostnameChecks);
                this.httpProtocol = p;
            }
            if (this.legacyProtocol == null) {
                p = new LegacyProtocol(this.validator, this.protocolListener, this.connectTimeout, this.readTimeout);
                p.setSkipHostnameChecks(this.skipHostnameChecks);
                this.legacyProtocol = p;
            }
        }

        public DefaultVOMSACService build() {
            this.buildServerInfoStore();
            this.buildProtocols();
            return new DefaultVOMSACService(this);
        }
    }
}

