/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.italiangrid.voms.request.VOMSESLookupStrategy;
import org.italiangrid.voms.request.VOMSESParser;
import org.italiangrid.voms.request.VOMSESParserFactory;
import org.italiangrid.voms.request.VOMSServerInfo;
import org.italiangrid.voms.request.VOMSServerInfoStore;
import org.italiangrid.voms.request.VOMSServerInfoStoreListener;
import org.italiangrid.voms.request.impl.BaseVOMSESLookupStrategy;
import org.italiangrid.voms.request.impl.DefaultVOMSESLookupStrategy;
import org.italiangrid.voms.util.NullListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVOMSServerInfoStore
implements VOMSServerInfoStore {
    private VOMSESLookupStrategy lookupStrategy;
    private VOMSServerInfoStoreListener listener;
    protected Map<String, Set<VOMSServerInfo>> serverInfoStore = new TreeMap<String, Set<VOMSServerInfo>>();
    private VOMSESParser vomsesParser;

    private DefaultVOMSServerInfoStore(Builder b) {
        this.lookupStrategy = b.lookupStrategy;
        this.listener = b.listener;
        this.vomsesParser = b.vomsesParser;
        this.initializeStore();
    }

    @Override
    public void addVOMSServerInfo(VOMSServerInfo info) {
        this.addVOMSServerInfo(info, null);
    }

    private void addVOMSServerInfo(VOMSServerInfo info, String path) {
        if (this.serverInfoStore.containsKey(info.getAlias())) {
            this.serverInfoStore.get(info.getAlias()).add(info);
        } else {
            HashSet<VOMSServerInfo> siCont = new HashSet<VOMSServerInfo>();
            siCont.add(info);
            this.serverInfoStore.put(info.getAlias(), siCont);
        }
        this.listener.notifyVOMSESInformationLoaded(path, info);
    }

    @Override
    public Set<VOMSServerInfo> getVOMSServerInfo() {
        HashSet<VOMSServerInfo> allEntries = new HashSet<VOMSServerInfo>();
        for (Map.Entry<String, Set<VOMSServerInfo>> entry : this.serverInfoStore.entrySet()) {
            allEntries.addAll((Collection<VOMSServerInfo>)entry.getValue());
        }
        return allEntries;
    }

    @Override
    public Set<VOMSServerInfo> getVOMSServerInfo(String voName) {
        Set<VOMSServerInfo> result = this.serverInfoStore.get(voName);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private void initializeStore() {
        List<File> vomsesPaths = this.lookupStrategy.lookupVomsesInfo();
        if (vomsesPaths.isEmpty()) {
            this.listener.notifyNoValidVOMSESError(this.lookupStrategy.searchedPaths());
        }
        for (File f : vomsesPaths) {
            this.listener.notifyVOMSESlookup(f.getAbsolutePath());
            List<VOMSServerInfo> vomsServerInfo = this.vomsesParser.parse(f);
            for (VOMSServerInfo si : vomsServerInfo) {
                this.addVOMSServerInfo(si, f.getAbsolutePath());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private List<String> vomsesPaths;
        private VOMSESLookupStrategy lookupStrategy;
        private VOMSServerInfoStoreListener listener = NullListener.INSTANCE;
        private VOMSESParser vomsesParser = VOMSESParserFactory.newVOMSESParser();

        public Builder lookupStrategy(VOMSESLookupStrategy strategy) {
            this.lookupStrategy = strategy;
            return this;
        }

        public Builder storeListener(VOMSServerInfoStoreListener l) {
            this.listener = l;
            return this;
        }

        public Builder vomsesParser(VOMSESParser p) {
            this.vomsesParser = p;
            return this;
        }

        public Builder vomsesPaths(List<String> paths) {
            this.vomsesPaths = paths;
            return this;
        }

        private void buildLookupStrategy() {
            if (this.lookupStrategy != null) {
                return;
            }
            this.lookupStrategy = this.vomsesPaths != null ? new BaseVOMSESLookupStrategy(this.vomsesPaths) : new DefaultVOMSESLookupStrategy();
        }

        public DefaultVOMSServerInfoStore build() {
            this.buildLookupStrategy();
            return new DefaultVOMSServerInfoStore(this);
        }
    }
}

