/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.request.VOMSACRequest;
import org.italiangrid.voms.request.VOMSProtocolListener;
import org.italiangrid.voms.request.VOMSServerInfo;
import org.italiangrid.voms.request.impl.VOMSRequestFactory;
import org.w3c.dom.Document;

public class LegacyRequestSender {
    private VOMSRequestFactory requestFactory = VOMSRequestFactory.instance();
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private VOMSProtocolListener listener;

    private LegacyRequestSender(VOMSProtocolListener listener) {
        this.listener = listener;
    }

    public static LegacyRequestSender instance(VOMSProtocolListener listener) {
        return new LegacyRequestSender(listener);
    }

    protected String xmlDocAsString(Document doc) {
        Transformer transformer;
        try {
            transformer = this.transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new VOMSError(e.getMessage(), e);
        }
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(doc);
        StreamResult res = new StreamResult(writer);
        try {
            transformer.transform(source, res);
        }
        catch (TransformerException e) {
            throw new VOMSError(e.getMessage(), e);
        }
        writer.flush();
        return writer.toString();
    }

    public void sendRequest(VOMSACRequest acRequest, VOMSServerInfo endpoint, OutputStream stream) {
        Transformer transformer;
        Document request = this.requestFactory.buildRequest(acRequest, endpoint);
        try {
            transformer = this.transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new VOMSError(e.getMessage(), e);
        }
        this.listener.notifyLegacyRequest(this.xmlDocAsString(request));
        DOMSource source = new DOMSource(request);
        StreamResult res = new StreamResult(stream);
        try {
            transformer.transform(source, res);
            stream.flush();
        }
        catch (Exception e) {
            throw new VOMSError(e.getMessage(), e);
        }
    }
}

