/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.store.impl;

import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.x500.X500Principal;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.store.LSCInfo;
import org.italiangrid.voms.store.VOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStoreStatusListener;
import org.italiangrid.voms.store.impl.DefaultLSCFileParser;
import org.italiangrid.voms.store.impl.LSCFile;
import org.italiangrid.voms.util.NullListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVOMSTrustStore
implements VOMSTrustStore {
    public static final String DEFAULT_VOMS_DIR = "/etc/grid-security/vomsdir";
    public static final String CERTIFICATE_FILENAME_SUFFIX = ".pem";
    public static final String LSC_FILENAME_SUFFIX = ".lsc";
    private final List<String> localTrustedDirs;
    private Map<String, X509Certificate> localAACertificatesByHash = new HashMap<String, X509Certificate>();
    private Map<String, Set<LSCInfo>> localLSCInfo = new HashMap<String, Set<LSCInfo>>();
    private VOMSTrustStoreStatusListener listener;
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final Lock read = this.rwLock.readLock();
    protected final Lock write = this.rwLock.writeLock();
    protected final Object listenerLock = new Object();

    protected static List<String> buildDefaultTrustedDirs() {
        ArrayList<String> tDirs = new ArrayList<String>();
        tDirs.add(DEFAULT_VOMS_DIR);
        return tDirs;
    }

    public DefaultVOMSTrustStore(List<String> localTrustDirs, VOMSTrustStoreStatusListener listener) {
        if (localTrustDirs == null) {
            throw new IllegalArgumentException("Please provide a non-null list of local trust directories!");
        }
        this.localTrustedDirs = localTrustDirs;
        this.listener = listener;
        this.loadTrustInformation();
    }

    public DefaultVOMSTrustStore(VOMSTrustStoreStatusListener listener) {
        this(DefaultVOMSTrustStore.buildDefaultTrustedDirs(), listener);
    }

    public DefaultVOMSTrustStore(List<String> localTrustDirs) {
        this(localTrustDirs, NullListener.INSTANCE);
    }

    public DefaultVOMSTrustStore() {
        this(DefaultVOMSTrustStore.buildDefaultTrustedDirs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLocalTrustedDirectories() {
        this.read.lock();
        try {
            List<String> list = this.localTrustedDirs;
            return list;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<X509Certificate> getLocalAACertificates() {
        this.read.lock();
        try {
            List<X509Certificate> list = Collections.unmodifiableList(new ArrayList<X509Certificate>(this.localAACertificatesByHash.values()));
            return list;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LSCInfo getLSC(String voName, String hostname) {
        this.read.lock();
        try {
            Set<LSCInfo> candidates = this.localLSCInfo.get(voName);
            if (candidates == null) {
                LSCInfo lSCInfo = null;
                return lSCInfo;
            }
            for (LSCInfo lsc : candidates) {
                if (!lsc.getHostname().equals(hostname)) continue;
                LSCInfo lSCInfo = lsc;
                return lSCInfo;
            }
            LSCInfo lSCInfo = null;
            return lSCInfo;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCertificatesFromDirectory(File directory) {
        File[] certFiles;
        this.directorySanityChecks(directory);
        Object object = this.listenerLock;
        synchronized (object) {
            this.listener.notifyCertficateLookupEvent(directory.getAbsolutePath());
        }
        for (File f : certFiles = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(DefaultVOMSTrustStore.CERTIFICATE_FILENAME_SUFFIX);
            }
        })) {
            this.loadCertificateFromFile(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCertificateFromFile(File file) {
        this.certificateFileSanityChecks(file);
        try {
            X509Certificate aaCert = CertificateUtils.loadCertificate((InputStream)new FileInputStream(file), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
            String aaCertHash = this.getOpensslCAHash(aaCert.getSubjectX500Principal());
            this.localAACertificatesByHash.put(aaCertHash, aaCert);
            Object object = this.listenerLock;
            synchronized (object) {
                this.listener.notifyCertificateLoadEvent(aaCert, file);
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Error parsing VOMS trusted certificate from %s. Reason: %s", file.getAbsolutePath(), e.getMessage());
            throw new VOMSError(errorMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLSCFromDirectory(File directory) {
        this.directorySanityChecks(directory);
        Object object = this.listenerLock;
        synchronized (object) {
            this.listener.notifyLSCLookupEvent(directory.getAbsolutePath());
        }
        File[] lscFiles = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(DefaultVOMSTrustStore.LSC_FILENAME_SUFFIX);
            }
        });
        if (lscFiles.length == 0) {
            return;
        }
        DefaultLSCFileParser lscParser = new DefaultLSCFileParser();
        String voName = directory.getName();
        for (File lsc : lscFiles) {
            String lscFileName = lsc.getName();
            String hostname = lscFileName.substring(0, lscFileName.indexOf(LSC_FILENAME_SUFFIX));
            LSCFile info = null;
            info = lscParser.parse(voName, hostname, lsc);
            Set<LSCInfo> localLscForVo = this.localLSCInfo.get(voName);
            if (localLscForVo == null) {
                localLscForVo = new HashSet<LSCInfo>();
                this.localLSCInfo.put(voName, localLscForVo);
            }
            localLscForVo.add(info);
            this.listener.notifyLSCLoadEvent(info, lsc);
        }
    }

    private void certificateFileSanityChecks(File certFile) {
        if (!certFile.exists()) {
            throw new VOMSError("Local VOMS trusted certificate does not exist:" + certFile.getAbsolutePath());
        }
        if (!certFile.canRead()) {
            throw new VOMSError("Local VOMS trusted certificate is not readable:" + certFile.getAbsolutePath());
        }
    }

    private void directorySanityChecks(File directory) {
        if (!directory.exists()) {
            throw new VOMSError("Local trust directory does not exists:" + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new VOMSError("Local trust directory is not a directory:" + directory.getAbsolutePath());
        }
        if (!directory.canRead()) {
            throw new VOMSError("Local trust directory is not readable:" + directory.getAbsolutePath());
        }
        if (!directory.canExecute()) {
            throw new VOMSError("Local trust directory is not traversable:" + directory.getAbsolutePath());
        }
    }

    private void cleanupStores() {
        this.localAACertificatesByHash.clear();
        this.localLSCInfo.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadTrustInformation() {
        this.write.lock();
        try {
            if (this.localTrustedDirs.isEmpty()) {
                throw new VOMSError("No local trust directory was specified for this trust store. Please provide at least one path where LSC and VOMS service certificates will be searched for.");
            }
            this.cleanupStores();
            for (String localDir : this.localTrustedDirs) {
                File[] voDirs;
                File baseTrustDir = new File(localDir);
                this.loadCertificatesFromDirectory(baseTrustDir);
                for (File voDir : voDirs = baseTrustDir.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                })) {
                    this.loadLSCFromDirectory(voDir);
                    this.loadCertificatesFromDirectory(voDir);
                }
            }
        }
        finally {
            this.write.unlock();
        }
    }

    private String getOpensslCAHash(X500Principal principal) {
        return OpensslTruststoreHelper.getOpenSSLCAHash((X500Principal)principal, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509Certificate getAACertificateBySubject(X500Principal aaCertSubject) {
        this.read.lock();
        try {
            String theCertHash = this.getOpensslCAHash(aaCertSubject);
            X509Certificate x509Certificate = this.localAACertificatesByHash.get(theCertHash);
            return x509Certificate;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Set<LSCInfo>> getAllLSCInfo() {
        this.read.lock();
        try {
            Map<String, Set<LSCInfo>> map = Collections.unmodifiableMap(this.localLSCInfo);
            return map;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatusListener(VOMSTrustStoreStatusListener statusListener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listener = statusListener;
        }
    }
}

