/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.AnyType;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.VectorType;
import org.jacorb.idl.parser;

public class SequenceType
extends VectorType {
    private boolean written = false;
    private static int idxNum = 0;
    private boolean recursive = false;
    public ConstExpr max = null;
    int length = 0;

    public SequenceType(int num) {
        super(num);
        this.name = null;
        this.typedefd = false;
    }

    @Override
    public Object clone() {
        SequenceType copy = new SequenceType(IdlSymbol.new_num());
        copy.type_spec = this.type_spec;
        copy.max = this.max;
        copy.length = this.length;
        copy.name = this.name;
        copy.pack_name = this.pack_name;
        copy.included = this.included;
        copy.typedefd = this.typedefd;
        copy.recursive = this.recursive;
        copy.set_token(this.get_token());
        copy.setEnclosingSymbol(this.getEnclosingSymbol());
        return copy;
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol symbol2) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != symbol2) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = symbol2;
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public void setPackage(String pkg) {
        pkg = parser.pack_replace(pkg);
        this.pack_name = this.pack_name.length() > 0 ? pkg + "." + this.pack_name : pkg;
        this.type_spec.setPackage(pkg);
        if (this.max != null) {
            this.max.setPackage(pkg);
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    void setRecursive() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Sequence " + this.typeName + " set recursive ------- this: " + this);
        }
        this.recursive = true;
    }

    @Override
    public String getTypeCodeExpression() {
        return this.getTypeCodeExpression(new HashSet());
    }

    @Override
    public String getTypeCodeExpression(Set knownTypes) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sequence getTypeCodeExpression " + this.name);
        }
        if (knownTypes.contains(this)) {
            return "org.omg.CORBA.ORB.init().create_recursive_tc(\"" + this.elementTypeSpec().id() + "\")";
        }
        knownTypes.add(this);
        String originalType = null;
        originalType = this.recursive ? "org.omg.CORBA.ORB.init().create_sequence_tc(" + this.length + ", org.omg.CORBA.ORB.init().create_recursive_tc(\"" + this.elementTypeSpec().id() + "\"))" : "org.omg.CORBA.ORB.init().create_sequence_tc(" + this.length + ", " + this.elementTypeExpression(knownTypes) + ")";
        return originalType;
    }

    public static int getNumber() {
        return idxNum++;
    }

    @Override
    public String printReadStatement(String var_name, String streamname) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sequence printReadStatement for " + this.typeName());
        }
        StringBuffer buffer = new StringBuffer();
        String type = this.typeName();
        String lgt = "_l" + var_name.replace('.', '_');
        if (lgt.indexOf(91) > 0) {
            lgt = lgt.substring(0, lgt.indexOf(91)) + "_";
        }
        lgt = lgt + SequenceType.getNumber();
        buffer.append("int " + lgt + " = " + streamname + ".read_long();" + Environment.NL);
        if (this.length != 0) {
            buffer.append("\t\tif (" + lgt + " > " + this.length + ")" + Environment.NL);
            buffer.append("\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Sequence length incorrect!\");" + Environment.NL);
        }
        buffer.append("\t\ttry" + Environment.NL + "\t\t{" + Environment.NL);
        buffer.append("\t\t\t int x = " + streamname + ".available();" + Environment.NL);
        buffer.append("\t\t\t if ( x > 0 && " + lgt + " > x )" + Environment.NL);
        buffer.append("\t\t\t\t{" + Environment.NL);
        buffer.append("\t\t\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Sequence length too large. Only \" + x + \" available and trying to assign \" + " + lgt + ");" + Environment.NL);
        buffer.append("\t\t\t\t}" + Environment.NL);
        buffer.append("\t\t}" + Environment.NL + "\t\tcatch (java.io.IOException e)" + Environment.NL + "\t\t{" + Environment.NL + "\t\t}" + Environment.NL);
        buffer.append("\t\t" + var_name + " = new " + type.substring(0, type.indexOf(91)) + "[" + lgt + "]" + type.substring(type.indexOf(93) + 1) + ";" + Environment.NL);
        TypeSpec elemType = this.elementTypeSpec();
        while (elemType instanceof AliasTypeSpec) {
            elemType = ((AliasTypeSpec)elemType).originalType();
        }
        if (elemType instanceof BaseType && !(elemType instanceof AnyType)) {
            String _tmp = elemType.printReadExpression(streamname);
            buffer.append("\t\t");
            buffer.append(_tmp.substring(0, _tmp.indexOf(40)));
            buffer.append("_array(");
            buffer.append(var_name);
            buffer.append(",0,");
            buffer.append(lgt);
            buffer.append(");");
        } else {
            char idx_variable = 'i';
            String indent = "";
            if (var_name.endsWith("]")) {
                idx_variable = (char)(var_name.charAt(var_name.length() - 2) + '\u0001');
                indent = "    ";
            }
            buffer.append("\t\t" + indent + "for (int " + idx_variable + "=0;" + idx_variable + "<" + var_name + ".length;" + idx_variable + "++)" + Environment.NL + "\t\t" + indent + "{" + Environment.NL);
            buffer.append("\t\t\t" + indent + this.elementTypeSpec().printReadStatement(var_name + "[" + idx_variable + "]", streamname) + Environment.NL);
            buffer.append("\t\t" + indent + "}" + Environment.NL);
        }
        return buffer.toString();
    }

    @Override
    public String printWriteStatement(String var_name, String streamname) {
        StringBuffer buffer = new StringBuffer();
        if (this.length != 0) {
            buffer.append("\t\tif (" + var_name + ".length > " + this.length + ")" + Environment.NL);
            buffer.append("\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Incorrect sequence length\");");
        }
        buffer.append(Environment.NL);
        buffer.append("\t\t" + streamname + ".write_long(" + var_name + ".length);" + Environment.NL);
        TypeSpec elemType = this.elementTypeSpec();
        while (elemType instanceof AliasTypeSpec) {
            elemType = ((AliasTypeSpec)elemType).originalType();
        }
        if (elemType instanceof BaseType && !(elemType instanceof AnyType)) {
            String _tmp = elemType.printWriteStatement(var_name, streamname);
            buffer.append("\t\t");
            buffer.append(_tmp.substring(0, _tmp.indexOf(40)));
            buffer.append("_array(");
            buffer.append(var_name);
            buffer.append(",0,");
            buffer.append(var_name);
            buffer.append(".length);");
        } else {
            char idx_variable = 'i';
            String indent = "";
            if (var_name.endsWith("]")) {
                idx_variable = (char)(var_name.charAt(var_name.length() - 2) + '\u0001');
                indent = "    ";
            }
            buffer.append("\t\t" + indent + "for (int " + idx_variable + "=0; " + idx_variable + "<" + var_name + ".length;" + idx_variable + "++)" + Environment.NL + "\t\t" + indent + "{" + Environment.NL);
            buffer.append("\t\t\t" + indent + this.elementTypeSpec().printWriteStatement(var_name + "[" + idx_variable + "]", streamname) + Environment.NL);
            buffer.append("\t\t" + indent + "}" + Environment.NL);
        }
        return buffer.toString();
    }

    @Override
    public String holderName() {
        if (!this.typedefd) {
            throw new RuntimeException("Compiler Error: should not be called (helpername on not typedef'd SequenceType " + this.name + ")");
        }
        String name = this.full_name();
        if (this.pack_name.length() > 0) {
            name = this.getFullName(name);
        }
        return name + "Holder";
    }

    @Override
    public String helperName() {
        if (!this.typedefd) {
            throw new RuntimeException("Compiler Error: should not be called (helperName() on not typedef'd SequenceType)");
        }
        String name = this.full_name();
        if (this.pack_name.length() > 0) {
            name = this.getFullName(name);
        }
        return name + "Helper";
    }

    public String className() {
        String cName;
        String fullName = this.full_name();
        if (fullName.indexOf(46) > 0) {
            this.pack_name = fullName.substring(0, fullName.lastIndexOf(46));
            cName = fullName.substring(fullName.lastIndexOf(46) + 1);
        } else {
            this.pack_name = "";
            cName = fullName;
        }
        return cName;
    }

    @Override
    public void parse() {
        if (this.max != null) {
            this.max.parse();
            this.length = this.max.pos_int_const();
        }
        if (this.type_spec.typeSpec() instanceof ScopedName) {
            TypeSpec typeSpec = ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec();
            if (typeSpec != null) {
                this.type_spec = typeSpec;
            }
            if (this.type_spec instanceof AliasTypeSpec) {
                this.addImportedAlias(this.type_spec.full_name());
            } else {
                this.addImportedName(this.type_spec.typeName());
            }
            this.addImportedName(this.type_spec.typeSpec().typeName());
        }
        try {
            NameTable.define(this.full_name(), IDLTypes.TYPE);
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            // empty catch block
        }
    }

    @Override
    public String full_name() {
        if (this.name == null) {
            return "<" + this.pack_name + ".anon>";
        }
        if (this.pack_name.length() > 0) {
            return ScopedName.unPseudoName(this.pack_name + "." + this.name);
        }
        return ScopedName.unPseudoName(this.name);
    }

    private void printHolderClass(String className, PrintWriter out) {
        if (!this.pack_name.equals("")) {
            out.println("package " + this.pack_name + ";" + Environment.NL);
        }
        String type = this.typeName();
        this.printImport(out);
        this.printClassComment("sequence", className, out);
        out.println("public" + parser.getFinalString() + " class " + className + "Holder");
        out.println("\timplements org.omg.CORBA.portable.Streamable");
        out.println("{");
        out.println("\tpublic " + type + " value;");
        out.println("\tpublic " + className + "Holder ()");
        out.println("\t{");
        out.println("\t}");
        out.println("\tpublic " + className + "Holder (final " + type + " initial)" + Environment.NL + "\t{");
        out.println("\t\tvalue = initial;");
        out.println("\t}");
        out.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        out.println("\t{");
        out.println("\t\treturn " + className + "Helper.type ();");
        out.println("\t}");
        out.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream _in)");
        out.println("\t{");
        out.println("\t\tvalue = " + className + "Helper.read (_in);");
        out.println("\t}");
        out.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream _out)");
        out.println("\t{");
        out.println("\t\t" + className + "Helper.write (_out,value);");
        out.println("\t}");
        out.println("}");
    }

    private void printHelperClass(String className, PrintWriter out) {
        String _tmp;
        if (!this.pack_name.equals("")) {
            out.println("package " + this.pack_name + ";");
        }
        String type = this.typeName();
        this.printImport(out);
        this.printClassComment("sequence", className, out);
        out.println("public" + parser.getFinalString() + " class " + className + "Helper");
        out.println("{");
        out.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        TypeSpec.printHelperClassMethods(out, type);
        this.printIdMethod(out);
        out.println("\tpublic static " + type + " read (final org.omg.CORBA.portable.InputStream in)");
        out.println("\t{");
        out.println("\t\tint l = in.read_long();");
        if (this.length != 0) {
            out.println("\t\tif (l > " + this.length + ")");
            out.println("\t\t\tthrow new org.omg.CORBA.MARSHAL();");
        }
        out.println("\t\t" + type + " result = new " + type.substring(0, type.indexOf(91)) + "[l]" + type.substring(type.indexOf(93) + 1) + ";");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            _tmp = this.elementTypeSpec().printReadExpression("in");
            out.println("\t\t" + _tmp.substring(0, _tmp.indexOf(40)) + "_array(result,0,result.length);");
        } else {
            out.println("\t\tfor (int i = 0; i < l; i++)");
            out.println("\t\t{");
            out.println("\t\t\t" + this.elementTypeSpec().printReadStatement("result[i]", "in"));
            out.println("\t\t}");
        }
        out.println("\t\treturn result;");
        out.println("\t}");
        out.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream out, final " + type + " s)");
        out.println("\t{");
        if (this.length != 0) {
            out.println("\t\tif (s.length > " + this.length + ")");
            out.println("\t\t\tthrow new org.omg.CORBA.MARSHAL();");
        }
        out.println("\t\tout.write_long(s.length);");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            _tmp = this.elementTypeSpec().printWriteStatement("s", "out");
            out.println(_tmp.substring(0, _tmp.indexOf(40)) + "_array(s,0,s.length);");
        } else {
            out.println("\t\tfor (int i = 0; i < s.length; i++)");
            out.println("\t\t\t" + this.elementTypeSpec().printWriteStatement("s[i]", "out"));
        }
        out.println("\t}");
        out.println("}");
    }

    @Override
    public void print(PrintWriter out) {
        try {
            if (!this.written && this.typedefd) {
                String fname;
                File file;
                String className;
                String fullName = this.full_name();
                if (fullName.indexOf(46) > 0) {
                    this.pack_name = fullName.substring(0, fullName.lastIndexOf(46));
                    className = fullName.substring(fullName.lastIndexOf(46) + 1);
                } else {
                    this.pack_name = "";
                    className = fullName;
                }
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                if (GlobalInputStream.isMoreRecentThan(file = new File(dir, fname = className + "Holder.java"))) {
                    PrintWriter holderOut = new PrintWriter(new FileWriter(file));
                    this.printHolderClass(className, holderOut);
                    holderOut.close();
                }
                if (GlobalInputStream.isMoreRecentThan(file = new File(dir, fname = className + "Helper.java"))) {
                    PrintWriter helperOut = new PrintWriter(new FileWriter(file));
                    this.printHelperClass(className, helperOut);
                    helperOut.close();
                }
                this.written = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("File IO error" + e);
        }
    }

    @Override
    public void printInsertIntoAny(PrintWriter out, String anyname, String varname) {
        out.println("\t" + this.helperName() + ".insert(" + anyname + ", " + varname + " );");
    }

    @Override
    public void printExtractResult(PrintWriter out, String resultname, String anyname, String resulttype) {
        throw new RuntimeException("DII Stubs not yet complete for Sequence types");
    }
}

